/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.drivers;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.core.tests.callGraph.CallGraphTestUtil;
import com.ibm.wala.examples.properties.WalaExamplesProperties;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.CollectionFilter;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphSlicer;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.PDFViewUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;

public class PDFTypeHierarchy {
    static final int CLASSPATH_INDEX = 1;
    public static final String DOT_FILE = "temp.dt";
    private static final String PDF_FILE = "th.pdf";
    public static Properties p;

    public static void main(String[] args) throws IOException {
        PDFTypeHierarchy.run(args);
    }

    public static Process run(String[] args) throws IOException {
        try {
            PDFTypeHierarchy.validateCommandLine(args);
            String classpath = args[1];
            AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(classpath, new FileProvider().getFile(CallGraphTestUtil.REGRESSION_EXCLUSIONS));
            ClassHierarchy cha = ClassHierarchyFactory.make(scope);
            Graph<IClass> g2 = PDFTypeHierarchy.typeHierarchy2Graph(cha);
            g2 = PDFTypeHierarchy.pruneForAppLoader(g2);
            String dotFile = p.getProperty("output_dir") + File.separatorChar + DOT_FILE;
            String pdfFile = p.getProperty("output_dir") + File.separatorChar + PDF_FILE;
            String dotExe = p.getProperty("dot_exe");
            String gvExe = p.getProperty("pdfview_exe");
            DotUtil.dotify(g2, null, dotFile, pdfFile, dotExe);
            return PDFViewUtil.launchPDFView(pdfFile, gvExe);
        }
        catch (WalaException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> Graph<T> pruneGraph(Graph<T> g2, Predicate<T> f) {
        Set<T> slice = GraphSlicer.slice(g2, f);
        return GraphSlicer.prune(g2, new CollectionFilter<T>(slice));
    }

    public static Graph<IClass> pruneForAppLoader(Graph<IClass> g2) {
        Predicate<IClass> f = c -> c.getClassLoader().getReference().equals(ClassLoaderReference.Application);
        return PDFTypeHierarchy.pruneGraph(g2, f);
    }

    public static void validateCommandLine(String[] args) {
        if (args.length < 2) {
            throw new UnsupportedOperationException("must have at least 2 command-line arguments");
        }
        if (!args[0].equals("-classpath")) {
            throw new UnsupportedOperationException("invalid command-line, args[0] should be -classpath, but is " + args[0]);
        }
    }

    public static Graph<IClass> typeHierarchy2Graph(IClassHierarchy cha) {
        SlowSparseNumberedGraph<IClass> result = SlowSparseNumberedGraph.make();
        for (IClass c : cha) {
            result.addNode(c);
        }
        for (IClass c : cha) {
            for (IClass x : cha.getImmediateSubclasses(c)) {
                result.addEdge(c, x);
            }
            if (!c.isInterface()) continue;
            for (IClass x : cha.getImplementors(c.getReference())) {
                result.addEdge(c, x);
            }
        }
        return result;
    }

    static {
        try {
            p = WalaProperties.loadProperties();
            p.putAll((Map<?, ?>)WalaExamplesProperties.loadProperties());
        }
        catch (WalaException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }
}

