/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.fixedpoint.impl;

import com.ibm.wala.fixedpoint.impl.GeneralStatement;
import com.ibm.wala.fixedpoint.impl.NullaryStatement;
import com.ibm.wala.fixpoint.AbstractStatement;
import com.ibm.wala.fixpoint.IFixedPointStatement;
import com.ibm.wala.fixpoint.IFixedPointSystem;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.fixpoint.UnaryStatement;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.GraphIntegrity;
import com.ibm.wala.util.graph.INodeWithNumber;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.SparseNumberedGraph;
import com.ibm.wala.util.graph.traverse.Topological;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class DefaultFixedPointSystem<T extends IVariable<T>>
implements IFixedPointSystem<T> {
    static final boolean DEBUG = false;
    private final NumberedGraph<INodeWithNumber> graph;
    private final Set<IFixedPointStatement<?>> equations = HashSetFactory.make();
    private final Set<IVariable<?>> variables = HashSetFactory.make();

    public DefaultFixedPointSystem(int expectedOut) {
        this.graph = new SparseNumberedGraph<INodeWithNumber>(expectedOut);
    }

    public DefaultFixedPointSystem() {
        this(1);
    }

    public boolean equals(Object obj) {
        return this.graph.equals(obj);
    }

    public int hashCode() {
        return this.graph.hashCode();
    }

    public String toString() {
        return this.graph.toString();
    }

    @Override
    public void removeStatement(IFixedPointStatement<T> s2) {
        this.graph.removeNodeAndEdges(s2);
    }

    @Override
    public Iterator<AbstractStatement> getStatements() {
        return new FilterIterator<Object>(this.graph.iterator(), AbstractStatement.class::isInstance);
    }

    @Override
    public void addStatement(IFixedPointStatement statement) throws IllegalArgumentException, UnimplementedError {
        if (statement == null) {
            throw new IllegalArgumentException("statement == null");
        }
        if (statement instanceof UnaryStatement) {
            this.addStatement((UnaryStatement)statement);
        } else if (statement instanceof NullaryStatement) {
            this.addStatement((NullaryStatement)statement);
        } else if (statement instanceof GeneralStatement) {
            this.addStatement((GeneralStatement)statement);
        } else {
            Assertions.UNREACHABLE("unexpected: " + statement.getClass());
        }
    }

    @Override
    public void addStatement(GeneralStatement<?> s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("s is null");
        }
        IVariable[] rhs = s2.getRHS();
        Object lhs = s2.getLHS();
        this.equations.add(s2);
        this.graph.addNode(s2);
        if (lhs != null) {
            this.variables.add((IVariable<?>)lhs);
            this.graph.addNode((INodeWithNumber)lhs);
            this.graph.addEdge(s2, (INodeWithNumber)lhs);
        }
        for (IVariable v : rhs) {
            IVariable variable = v;
            if (variable == null) continue;
            this.variables.add(variable);
            this.graph.addNode(variable);
            this.graph.addEdge(variable, s2);
        }
    }

    @Override
    public void addStatement(UnaryStatement<?> s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("s is null");
        }
        Object lhs = s2.getLHS();
        Object rhs = s2.getRightHandSide();
        this.equations.add(s2);
        this.graph.addNode(s2);
        if (lhs != null) {
            this.variables.add((IVariable<?>)lhs);
            this.graph.addNode((INodeWithNumber)lhs);
            this.graph.addEdge(s2, (INodeWithNumber)lhs);
        }
        this.variables.add((IVariable<?>)rhs);
        this.graph.addNode((INodeWithNumber)rhs);
        this.graph.addEdge((INodeWithNumber)rhs, s2);
    }

    @Override
    public void addStatement(NullaryStatement<?> s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("s is null");
        }
        Object lhs = s2.getLHS();
        this.equations.add(s2);
        this.graph.addNode(s2);
        if (lhs != null) {
            this.variables.add((IVariable<?>)lhs);
            this.graph.addNode((INodeWithNumber)lhs);
            this.graph.addEdge(s2, (INodeWithNumber)lhs);
        }
    }

    public void addVariable(T v) {
        this.variables.add((IVariable<?>)v);
        this.graph.addNode((INodeWithNumber)v);
    }

    public AbstractStatement<?, ?> getStep(int number) {
        return (AbstractStatement)this.graph.getNode(number);
    }

    @Override
    public void reorder() {
        Iterator<INodeWithNumber> order = Topological.makeTopologicalIter(this.graph).iterator();
        int number = 0;
        while (order.hasNext()) {
            INodeWithNumber elt = order.next();
            if (!(elt instanceof IVariable)) continue;
            IVariable v = (IVariable)elt;
            v.setOrderNumber(number++);
        }
    }

    private void checkGraph() {
        try {
            GraphIntegrity.check(this.graph);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    @Override
    public Iterator<? extends INodeWithNumber> getStatementsThatUse(T v) {
        return this.graph.containsNode((INodeWithNumber)v) ? this.graph.getSuccNodes((INodeWithNumber)v) : EmptyIterator.instance();
    }

    @Override
    public Iterator<? extends INodeWithNumber> getStatementsThatDef(T v) {
        return this.graph.containsNode((INodeWithNumber)v) ? this.graph.getPredNodes((INodeWithNumber)v) : EmptyIterator.instance();
    }

    public T getVariable(int n) {
        return (T)((IVariable)this.graph.getNode(n));
    }

    @Override
    public int getNumberOfStatementsThatUse(T v) {
        return this.graph.containsNode((INodeWithNumber)v) ? this.graph.getSuccNodeCount((INodeWithNumber)v) : 0;
    }

    @Override
    public int getNumberOfStatementsThatDef(T v) {
        return this.graph.containsNode((INodeWithNumber)v) ? this.graph.getPredNodeCount((INodeWithNumber)v) : 0;
    }

    @Override
    public Iterator<? extends INodeWithNumber> getVariables() {
        return new FilterIterator<INodeWithNumber>(this.graph.iterator(), Objects::nonNull);
    }

    public int getNumberOfNodes() {
        return this.graph.getNumberOfNodes();
    }

    public Iterator<? extends INodeWithNumber> getPredNodes(INodeWithNumber n) {
        return this.graph.getPredNodes(n);
    }

    public int getPredNodeCount(INodeWithNumber n) {
        return this.graph.getPredNodeCount(n);
    }

    @Override
    public boolean containsStatement(IFixedPointStatement<T> s2) {
        return this.equations.contains(s2);
    }

    @Override
    public boolean containsVariable(T v) {
        return this.variables.contains(v);
    }
}

