/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.cha;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.cha.CHAContextInterpreter;
import com.ibm.wala.ipa.callgraph.cha.ContextInsensitiveCHAContextInterpreter;
import com.ibm.wala.ipa.callgraph.impl.BasicCallGraph;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.FakeWorldClinitMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.ComposedIterator;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;

public class CHACallGraph
extends BasicCallGraph<CHAContextInterpreter> {
    private final IClassHierarchy cha;
    private final AnalysisOptions options;
    private final IAnalysisCacheView cache;
    private final boolean applicationOnly;
    private boolean isInitialized = false;
    private final Map<CallSiteReference, Set<IMethod>> targetCache = HashMapFactory.make();
    private int clinitPC = 0;
    private final Stack<CGNode> newNodes = new Stack();

    public CHACallGraph(IClassHierarchy cha) {
        this(cha, false);
    }

    public CHACallGraph(IClassHierarchy cha, boolean applicationOnly) {
        this.cha = cha;
        this.options = new AnalysisOptions();
        this.cache = new AnalysisCacheImpl();
        this.applicationOnly = applicationOnly;
        this.setInterpreter(new ContextInsensitiveCHAContextInterpreter());
    }

    public void init(Iterable<Entrypoint> entrypoints) throws CancelException {
        super.init();
        CGNode root = this.getFakeRootNode();
        int programCounter = 0;
        for (Entrypoint e : entrypoints) {
            root.addTarget(e.makeSite(programCounter++), null);
        }
        this.newNodes.push(root);
        this.closure();
        this.isInitialized = true;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    private Iterator<IMethod> getPossibleTargets(CallSiteReference site) {
        Set<IMethod> result = this.targetCache.get(site);
        if (result == null) {
            IMethod m3;
            result = site.isDispatch() ? this.cha.getPossibleTargets(site.getDeclaredTarget()) : ((m3 = this.cha.resolveMethod(site.getDeclaredTarget())) != null ? Collections.singleton(m3) : Collections.emptySet());
            this.targetCache.put(site, result);
        }
        return result.iterator();
    }

    @Override
    public Set<CGNode> getPossibleTargets(CGNode node, CallSiteReference site) {
        return Iterator2Collection.toSet(new MapIterator<IMethod, CGNode>(new FilterIterator<IMethod>(this.getPossibleTargets(site), this::isRelevantMethod), object -> {
            try {
                return this.findOrCreateNode((IMethod)object, Everywhere.EVERYWHERE);
            }
            catch (CancelException e) {
                assert (false) : e.toString();
                return null;
            }
        }));
    }

    @Override
    public int getNumberOfTargets(CGNode node, CallSiteReference site) {
        return IteratorUtil.count(this.getPossibleTargets(site));
    }

    @Override
    public Iterator<CallSiteReference> getPossibleSites(CGNode src, CGNode target) {
        return new FilterIterator<CallSiteReference>(((CHAContextInterpreter)this.getInterpreter(src)).iterateCallSites(src), o -> this.getPossibleTargets(src, (CallSiteReference)o).contains(target));
    }

    @Override
    protected CGNode makeFakeRootNode() throws CancelException {
        return new CHARootNode(Language.JAVA.getFakeRootMethod(this.cha, this.options, this.cache), Everywhere.EVERYWHERE);
    }

    @Override
    protected CGNode makeFakeWorldClinitNode() throws CancelException {
        return new CHARootNode(new FakeWorldClinitMethod(Language.JAVA.getFakeRootMethod(this.cha, this.options, this.cache).getDeclaringClass(), this.options, this.cache), Everywhere.EVERYWHERE);
    }

    @Override
    public CGNode findOrCreateNode(IMethod method, Context C2) throws CancelException {
        assert (C2.equals(Everywhere.EVERYWHERE));
        assert (!method.isAbstract());
        CGNode n = this.getNode(method, C2);
        if (n == null) {
            assert (!this.isInitialized);
            n = this.makeNewNode(method, C2);
            IMethod clinit = method.getDeclaringClass().getClassInitializer();
            if (clinit != null && this.getNode(clinit, Everywhere.EVERYWHERE) == null) {
                CGNode cln = this.makeNewNode(clinit, Everywhere.EVERYWHERE);
                CGNode clinits = this.getFakeWorldClinitNode();
                clinits.addTarget(CallSiteReference.make(this.clinitPC++, clinit.getReference(), IInvokeInstruction.Dispatch.STATIC), cln);
            }
        }
        return n;
    }

    private void closure() throws CancelException {
        while (!this.newNodes.isEmpty()) {
            CGNode n = this.newNodes.pop();
            for (CallSiteReference site : Iterator2Iterable.make(n.iterateCallSites())) {
                Iterator<IMethod> methods = this.getPossibleTargets(site);
                while (methods.hasNext()) {
                    CGNode callee;
                    IMethod target = methods.next();
                    if (!this.isRelevantMethod(target) || (callee = this.getNode(target, Everywhere.EVERYWHERE)) != null) continue;
                    callee = this.findOrCreateNode(target, Everywhere.EVERYWHERE);
                    if (n != this.getFakeRootNode()) continue;
                    this.registerEntrypoint(callee);
                }
            }
        }
    }

    private boolean isRelevantMethod(IMethod target) {
        return !target.isAbstract() && (!this.applicationOnly || this.cha.getScope().isApplicationLoader(target.getDeclaringClass().getClassLoader()));
    }

    private CGNode makeNewNode(IMethod method, Context C2) {
        BasicCallGraph.Key k = new BasicCallGraph.Key(method, C2);
        CHANode n = new CHANode(method, C2);
        this.registerNode(k, n);
        this.newNodes.push(n);
        return n;
    }

    @Override
    protected NumberedEdgeManager<CGNode> getEdgeManager() {
        return new NumberedEdgeManager<CGNode>(){
            private final Map<CGNode, SoftReference<Set<CGNode>>> predecessors = HashMapFactory.make();

            private Set<CGNode> getPreds(CGNode n) {
                if (this.predecessors.containsKey(n) && this.predecessors.get(n).get() != null) {
                    return this.predecessors.get(n).get();
                }
                HashSet<CGNode> preds = HashSetFactory.make();
                for (CGNode node : CHACallGraph.this) {
                    if (!CHACallGraph.this.getPossibleSites(node, n).hasNext()) continue;
                    preds.add(node);
                }
                this.predecessors.put(n, new SoftReference(preds));
                return preds;
            }

            @Override
            public Iterator<CGNode> getPredNodes(CGNode n) {
                return this.getPreds(n).iterator();
            }

            @Override
            public int getPredNodeCount(CGNode n) {
                return this.getPreds(n).size();
            }

            @Override
            public Iterator<CGNode> getSuccNodes(final CGNode n) {
                return new FilterIterator<CGNode>(new ComposedIterator<CallSiteReference, CGNode>(n.iterateCallSites()){

                    @Override
                    public Iterator<? extends CGNode> makeInner(CallSiteReference outer) {
                        return CHACallGraph.this.getPossibleTargets(n, outer).iterator();
                    }
                }, new Predicate<CGNode>(){
                    private final MutableIntSet nodes = IntSetUtil.make();

                    @Override
                    public boolean test(CGNode o) {
                        if (this.nodes.contains(o.getGraphNodeId())) {
                            return false;
                        }
                        this.nodes.add(o.getGraphNodeId());
                        return true;
                    }
                });
            }

            @Override
            public int getSuccNodeCount(CGNode N) {
                return IteratorUtil.count(this.getSuccNodes(N));
            }

            @Override
            public void addEdge(CGNode src, CGNode dst) {
                assert (false);
            }

            @Override
            public void removeEdge(CGNode src, CGNode dst) throws UnsupportedOperationException {
                assert (false);
            }

            @Override
            public void removeAllIncidentEdges(CGNode node) throws UnsupportedOperationException {
                assert (false);
            }

            @Override
            public void removeIncomingEdges(CGNode node) throws UnsupportedOperationException {
                assert (false);
            }

            @Override
            public void removeOutgoingEdges(CGNode node) throws UnsupportedOperationException {
                assert (false);
            }

            @Override
            public boolean hasEdge(CGNode src, CGNode dst) {
                return CHACallGraph.this.getPossibleSites(src, dst).hasNext();
            }

            @Override
            public IntSet getSuccNodeNumbers(CGNode node) {
                MutableIntSet result = IntSetUtil.make();
                for (CGNode s2 : Iterator2Iterable.make(this.getSuccNodes(node))) {
                    result.add(s2.getGraphNodeId());
                }
                return result;
            }

            @Override
            public IntSet getPredNodeNumbers(CGNode node) {
                MutableIntSet result = IntSetUtil.make();
                for (CGNode s2 : Iterator2Iterable.make(this.getPredNodes(node))) {
                    result.add(s2.getGraphNodeId());
                }
                return result;
            }
        };
    }

    private class CHARootNode
    extends CHANode {
        private final Set<CallSiteReference> calls;

        protected CHARootNode(IMethod method, Context C2) {
            super(method, C2);
            this.calls = HashSetFactory.make();
        }

        @Override
        public Iterator<CallSiteReference> iterateCallSites() {
            return this.calls.iterator();
        }

        @Override
        public boolean addTarget(CallSiteReference reference, CGNode target) {
            return this.calls.add(reference);
        }
    }

    private class CHANode
    extends BasicCallGraph.NodeImpl {
        protected CHANode(IMethod method, Context C2) {
            super(method, C2);
        }

        @Override
        public IR getIR() {
            return CHACallGraph.this.cache.getIR(this.method);
        }

        @Override
        public DefUse getDU() {
            return CHACallGraph.this.cache.getDefUse(CHACallGraph.this.cache.getIR(this.method));
        }

        @Override
        public Iterator<NewSiteReference> iterateNewSites() {
            return ((CHAContextInterpreter)CHACallGraph.this.getInterpreter(this)).iterateNewSites(this);
        }

        @Override
        public Iterator<CallSiteReference> iterateCallSites() {
            return ((CHAContextInterpreter)CHACallGraph.this.getInterpreter(this)).iterateCallSites(this);
        }

        @Override
        public boolean equals(Object obj) {
            return obj.getClass() == this.getClass() && this.getMethod().equals(((CHANode)obj).getMethod());
        }

        @Override
        public int hashCode() {
            return this.getMethod().hashCode();
        }

        @Override
        public boolean addTarget(CallSiteReference reference, CGNode target) {
            return false;
        }
    }
}

