/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.ArgumentTypeEntrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import java.util.HashSet;
import java.util.function.Function;

public class AllApplicationEntrypoints
extends HashSet<Entrypoint> {
    private static final long serialVersionUID = 6541081454519490199L;
    private static final boolean DEBUG = false;

    public AllApplicationEntrypoints(AnalysisScope scope, IClassHierarchy cha, Function<IClass, Boolean> isApplicationClass) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        for (IClass klass : cha) {
            if (klass.isInterface() || !isApplicationClass.apply(klass).booleanValue()) continue;
            for (IMethod iMethod : klass.getDeclaredMethods()) {
                if (iMethod.isAbstract()) continue;
                this.add(new ArgumentTypeEntrypoint(iMethod, cha));
            }
        }
    }

    public AllApplicationEntrypoints(AnalysisScope scope, IClassHierarchy cha) {
        this(scope, cha, klass -> scope.getApplicationLoader().equals(klass.getClassLoader().getReference()));
    }
}

