/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.DelegatingContext;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.util.intset.IntSet;

public class UnionContextSelector
implements ContextSelector {
    private final ContextSelector A;
    private final ContextSelector B;

    public UnionContextSelector(ContextSelector A2, ContextSelector B) {
        if (A2 == null) {
            throw new IllegalArgumentException("The ContextSelector given as A may not be null");
        }
        if (B == null) {
            throw new IllegalArgumentException("The ContextSelector given as B may not be null");
        }
        this.A = A2;
        this.B = B;
    }

    @Override
    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] receiver) {
        Context ctxA = this.A.getCalleeTarget(caller, site, callee, receiver);
        Context ctxB = this.B.getCalleeTarget(caller, site, callee, receiver);
        if (ctxA == null) {
            return ctxB;
        }
        if (ctxB == null) {
            return ctxA;
        }
        DelegatingContext ctxU = new DelegatingContext(ctxA, ctxB);
        return ctxU;
    }

    @Override
    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        return this.A.getRelevantParameters(caller, site).union(this.B.getRelevantParameters(caller, site));
    }

    public String toString() {
        return "<UnionContextSelector A=" + this.A + " B=" + this.B + " />";
    }
}

