/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;

public class ClassBasedInstanceKeys
implements InstanceKeyFactory {
    private static final boolean DEBUG = false;
    private final AnalysisOptions options;
    private final IClassHierarchy cha;

    public ClassBasedInstanceKeys(AnalysisOptions options, IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("null cha");
        }
        this.cha = cha;
        this.options = options;
    }

    @Override
    public InstanceKey getInstanceKeyForAllocation(CGNode node, NewSiteReference allocation) {
        if (allocation == null) {
            throw new IllegalArgumentException("allocation is null");
        }
        if (String.valueOf(allocation).contains("java/lang/invoke/DirectMethodHandle$StaticAccessor")) {
            System.err.println("got " + allocation + " in " + node);
        }
        if (this.options.getClassTargetSelector() == null) {
            throw new IllegalStateException("options did not specify class target selector");
        }
        IClass type = this.options.getClassTargetSelector().getAllocatedTarget(node, allocation);
        if (type == null) {
            return null;
        }
        ConcreteTypeKey key = new ConcreteTypeKey(type);
        return key;
    }

    @Override
    public InstanceKey getInstanceKeyForMultiNewArray(CGNode node, NewSiteReference allocation, int dim) {
        ArrayClass type = (ArrayClass)this.options.getClassTargetSelector().getAllocatedTarget(node, allocation);
        assert (type != null);
        assert (type != null) : "null type for " + allocation;
        int i = 0;
        while (i <= dim) {
            ++i;
            if (type == null) {
                Assertions.UNREACHABLE();
            }
            type = (ArrayClass)type.getElementClass();
        }
        if (type == null) {
            return null;
        }
        ConcreteTypeKey key = new ConcreteTypeKey(type);
        return key;
    }

    @Override
    public <T> InstanceKey getInstanceKeyForConstant(TypeReference type, T S) {
        if (type == null || this.cha.lookupClass(type) == null) {
            return null;
        }
        if (this.options.getUseConstantSpecificKeys()) {
            return new ConstantKey<T>(S, this.cha.lookupClass(type));
        }
        return new ConcreteTypeKey(this.cha.lookupClass(type));
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter peiLoc, TypeReference type) {
        IClass klass = this.cha.lookupClass(type);
        if (klass == null) {
            return null;
        }
        return new ConcreteTypeKey(this.cha.lookupClass(type));
    }

    @Override
    public InstanceKey getInstanceKeyForMetadataObject(Object obj, TypeReference objType) {
        IClass cls = this.cha.lookupClass(objType);
        assert (cls != null) : objType;
        if (obj instanceof TypeReference) {
            IClass klass = this.cha.lookupClass((TypeReference)obj);
            if (klass == null) {
                return new ConcreteTypeKey(cls);
            }
            return new ConstantKey<IClass>(klass, cls);
        }
        if (obj instanceof MethodReference) {
            IMethod m3 = this.cha.resolveMethod((MethodReference)obj);
            if (m3 == null) {
                return new ConcreteTypeKey(cls);
            }
            return new ConstantKey<IMethod>(m3, cls);
        }
        if (obj instanceof Descriptor) {
            return new ConstantKey<Descriptor>((Descriptor)obj, cls);
        }
        throw new Error();
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }
}

