/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;

public class ContainerUtil {
    private static final TypeName FreezableListName = TypeName.string2TypeName("Lcom/sun/corba/se/internal/ior/FreezableList");
    public static final TypeReference FreezableList = TypeReference.findOrCreate(ClassLoaderReference.Primordial, FreezableListName);
    private static final TypeName JarAttributesName = TypeName.string2TypeName("Ljava/util/jar/Attributes");
    public static final TypeReference JarAttributes = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JarAttributesName);
    private static final Collection<TypeReference> miscContainers = HashSetFactory.make();

    public static boolean isContainer(IClass c) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (ClassLoaderReference.Primordial.equals(c.getClassLoader().getReference()) && TypeReference.JavaUtilCollection.getName().getPackage().equals(c.getReference().getName().getPackage())) {
            IClass collection = c.getClassHierarchy().lookupClass(TypeReference.JavaUtilCollection);
            IClass map = c.getClassHierarchy().lookupClass(TypeReference.JavaUtilMap);
            if (c.isInterface()) {
                assert (collection != null);
                assert (map != null);
                Collection<IClass> s2 = c.getAllImplementedInterfaces();
                if (s2.contains(collection) || s2.contains(map)) {
                    return true;
                }
            } else if (c.getClassHierarchy().implementsInterface(c, collection) || c.getClassHierarchy().implementsInterface(c, map)) {
                return true;
            }
        }
        if (miscContainers.contains(c.getReference())) {
            return true;
        }
        return c.isArrayClass() && ((ArrayClass)c).getElementClass() != null && ((ArrayClass)c).getElementClass().getReference().isReferenceType();
    }

    static {
        miscContainers.add(FreezableList);
        miscContainers.add(JarAttributes);
    }
}

