/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.analysis.reflection.IllegalArgumentExceptionContext;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticClass;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AssignOperator;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.IPointerOperator;
import com.ibm.wala.ipa.callgraph.propagation.IPointsToSolver;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationSystem;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.UnarySideEffect;
import com.ibm.wala.ipa.callgraph.propagation.ZeroLengthArrayInNode;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class PropagationCallGraphBuilder
implements CallGraphBuilder<InstanceKey> {
    private static final boolean DEBUG_ALL = false;
    static final boolean DEBUG_ASSIGN = false;
    private static final boolean DEBUG_ARRAY_LOAD = false;
    private static final boolean DEBUG_ARRAY_STORE = false;
    private static final boolean DEBUG_FILTER = false;
    protected static final boolean DEBUG_GENERAL = false;
    private static final boolean DEBUG_GET = false;
    private static final boolean DEBUG_PUT = false;
    private static final boolean DEBUG_ENTRYPOINTS = false;
    protected PointerKeyFactory pointerKeyFactory;
    private final IClass JAVA_LANG_OBJECT;
    public final IClassHierarchy cha;
    protected final AnalysisOptions options;
    private final IAnalysisCacheView analysisCache;
    private final Set<CGNode> alreadyVisited = HashSetFactory.make();
    private Set<CGNode> discoveredNodes = HashSetFactory.make();
    protected final Set<CallSiteReference> entrypointCallSites = HashSetFactory.make();
    protected PropagationSystem system;
    private IPointsToSolver solver;
    protected final ExplicitCallGraph callGraph;
    public static final AssignOperator assignOperator = new AssignOperator();
    public final FilterOperator filterOperator = new FilterOperator();
    protected final InverseFilterOperator inverseFilterOperator = new InverseFilterOperator();
    private SSAContextInterpreter contextInterpreter;
    protected ContextSelector contextSelector;
    protected InstanceKeyFactory instanceKeyFactory;
    private final boolean rememberGetPutHistory = true;

    public PropagationSystem getSystem() {
        return this.system;
    }

    protected PropagationCallGraphBuilder(IMethod abstractRootMethod, AnalysisOptions options, IAnalysisCacheView cache, PointerKeyFactory pointerKeyFactory) {
        if (abstractRootMethod == null) {
            throw new IllegalArgumentException("cha is null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        assert (cache != null);
        this.cha = abstractRootMethod.getClassHierarchy();
        this.options = options;
        this.analysisCache = cache;
        assert (pointerKeyFactory != null);
        this.pointerKeyFactory = pointerKeyFactory;
        this.callGraph = this.createEmptyCallGraph(abstractRootMethod, options);
        try {
            this.callGraph.init();
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        this.callGraph.setInterpreter(this.contextInterpreter);
        this.JAVA_LANG_OBJECT = this.cha.lookupClass(TypeReference.JavaLangObject);
    }

    protected ExplicitCallGraph createEmptyCallGraph(IMethod abstractRootMethod, AnalysisOptions options) {
        return new ExplicitCallGraph(abstractRootMethod, options, this.getAnalysisCache());
    }

    protected boolean isJavaLangObject(IClass klass) {
        return klass.getReference().equals(TypeReference.JavaLangObject);
    }

    public CallGraph makeCallGraph(AnalysisOptions options) throws IllegalArgumentException, CancelException {
        return this.makeCallGraph(options, null);
    }

    @Override
    public CallGraph makeCallGraph(AnalysisOptions options, MonitorUtil.IProgressMonitor monitor) throws IllegalArgumentException, CallGraphBuilderCancelException {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        this.system = this.makeSystem(options);
        this.system.setMinEquationsForTopSort(options.getMinEquationsForTopSort());
        this.system.setTopologicalGrowthFactor(options.getTopologicalGrowthFactor());
        this.system.setMaxEvalBetweenTopo(options.getMaxEvalBetweenTopo());
        this.discoveredNodes = HashSetFactory.make();
        this.discoveredNodes.add(this.callGraph.getFakeRootNode());
        for (Entrypoint entrypoint : options.getEntrypoints()) {
            SSAAbstractInvokeInstruction call = entrypoint.addCall((AbstractRootMethod)this.callGraph.getFakeRootNode().getMethod());
            if (call == null) {
                Warnings.add(EntrypointResolutionWarning.create(entrypoint));
                continue;
            }
            this.entrypointCallSites.add(call.getCallSite());
        }
        if (this.entrypointCallSites.isEmpty()) {
            throw new IllegalStateException("Could not create a entrypoint callsites: " + Warnings.asString());
        }
        this.customInit();
        this.solver = this.makeSolver();
        try {
            this.solver.solve(monitor);
        }
        catch (CancelException | CancelRuntimeException e) {
            CallGraphBuilderCancelException callGraphBuilderCancelException = CallGraphBuilderCancelException.createCallGraphBuilderCancelException(e, (CallGraph)this.callGraph, this.system.extractPointerAnalysis(this));
            throw callGraphBuilderCancelException;
        }
        return this.callGraph;
    }

    protected PropagationSystem makeSystem(AnalysisOptions options) {
        return new PropagationSystem(this.callGraph, this.pointerKeyFactory, this.instanceKeyFactory);
    }

    protected abstract IPointsToSolver makeSolver();

    protected void customInit() {
    }

    protected abstract boolean addConstraintsFromNode(CGNode var1, MonitorUtil.IProgressMonitor var2) throws CancelException;

    protected boolean addConstraintsFromNewNodes(MonitorUtil.IProgressMonitor monitor) throws CancelException {
        boolean result = false;
        while (!this.discoveredNodes.isEmpty()) {
            Iterator<CGNode> it = this.discoveredNodes.iterator();
            this.discoveredNodes = HashSetFactory.make();
            while (it.hasNext()) {
                CGNode n = it.next();
                result |= this.addConstraintsFromNode(n, monitor);
            }
        }
        return result;
    }

    public PointerKey getPointerKeyForLocal(CGNode node, int valueNumber) {
        return this.pointerKeyFactory.getPointerKeyForLocal(node, valueNumber);
    }

    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, FilteredPointerKey.TypeFilter filter) {
        assert (filter != null);
        return this.pointerKeyFactory.getFilteredPointerKeyForLocal(node, valueNumber, filter);
    }

    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, IClass filter) {
        return this.getFilteredPointerKeyForLocal(node, valueNumber, new FilteredPointerKey.SingleClassFilter(filter));
    }

    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, InstanceKey filter) {
        return this.getFilteredPointerKeyForLocal(node, valueNumber, new FilteredPointerKey.SingleInstanceFilter(filter));
    }

    public PointerKey getPointerKeyForReturnValue(CGNode node) {
        return this.pointerKeyFactory.getPointerKeyForReturnValue(node);
    }

    public PointerKey getPointerKeyForExceptionalReturnValue(CGNode node) {
        return this.pointerKeyFactory.getPointerKeyForExceptionalReturnValue(node);
    }

    public PointerKey getPointerKeyForStaticField(IField f) {
        assert (f != null) : "null FieldReference";
        return this.pointerKeyFactory.getPointerKeyForStaticField(f);
    }

    public PointerKey getPointerKeyForInstanceField(InstanceKey I2, IField field) {
        if (field == null) {
            throw new IllegalArgumentException("field is null");
        }
        if (I2 == null) {
            throw new IllegalArgumentException("I is null");
        }
        IClass t = field.getDeclaringClass();
        IClass C2 = I2.getConcreteType();
        if (!(C2 instanceof SyntheticClass) && !this.getClassHierarchy().isSubclassOf(C2, t)) {
            return null;
        }
        return this.pointerKeyFactory.getPointerKeyForInstanceField(I2, field);
    }

    public PointerKey getPointerKeyForArrayContents(InstanceKey I2) {
        if (I2 == null) {
            throw new IllegalArgumentException("I is null");
        }
        IClass C2 = I2.getConcreteType();
        if (!C2.isArrayClass()) assert (false) : "illegal arguments: " + I2;
        return this.pointerKeyFactory.getPointerKeyForArrayContents(I2);
    }

    protected void assignInstanceToCatch(PointerKey exceptionVar, Set<IClass> catchClasses, InstanceKey e) {
        if (PropagationCallGraphBuilder.catches(catchClasses, e.getConcreteType(), this.cha)) {
            this.system.newConstraint(exceptionVar, e);
        }
    }

    protected void addAssignmentsForCatchPointerKey(PointerKey exceptionVar, Set<IClass> catchClasses, PointerKey e) {
        for (IClass c : catchClasses) {
            if (c.getReference().equals(c.getClassLoader().getLanguage().getThrowableType())) {
                this.system.newConstraint(exceptionVar, assignOperator, e);
                continue;
            }
            TypedPointerKey typedException = TypedPointerKey.make(exceptionVar, c);
            this.system.newConstraint((PointerKey)typedException, this.filterOperator, e);
            this.system.newConstraint(exceptionVar, assignOperator, (PointerKey)typedException);
        }
    }

    public static boolean catches(Set<IClass> catchClasses, IClass klass, IClassHierarchy cha) {
        IClass c;
        if (catchClasses == null) {
            throw new IllegalArgumentException("catchClasses is null");
        }
        if (catchClasses.size() == 1 && (c = catchClasses.iterator().next()) != null && c.getReference().equals(TypeReference.JavaLangThread)) {
            return true;
        }
        for (IClass c2 : catchClasses) {
            if (c2 == null || !cha.isAssignableFrom(c2, klass)) continue;
            return true;
        }
        return false;
    }

    public static boolean representsNullType(InstanceKey key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        IClass cls = key.getConcreteType();
        Language L = cls.getClassLoader().getLanguage();
        return L.isNullType(cls.getReference());
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public AnalysisOptions getOptions() {
        return this.options;
    }

    public IClass getJavaLangObject() {
        return this.JAVA_LANG_OBJECT;
    }

    public ExplicitCallGraph getCallGraph() {
        return this.callGraph;
    }

    public void setContextInterpreter(SSAContextInterpreter interpreter) {
        this.contextInterpreter = interpreter;
        this.callGraph.setInterpreter(interpreter);
    }

    @Override
    public PointerAnalysis<InstanceKey> getPointerAnalysis() {
        return this.system.extractPointerAnalysis(this);
    }

    public PropagationSystem getPropagationSystem() {
        return this.system;
    }

    public PointerKeyFactory getPointerKeyFactory() {
        return this.pointerKeyFactory;
    }

    public void setPointerKeyFactory(PointerKeyFactory pkFact) {
        this.pointerKeyFactory = pkFact;
    }

    public RTAContextInterpreter getContextInterpreter() {
        return this.contextInterpreter;
    }

    protected CGNode getTargetForCall(CGNode caller, CallSiteReference site, IClass recv, InstanceKey[] iKey) {
        IMethod targetMethod = this.options.getMethodTargetSelector().getCalleeTarget(caller, site, recv);
        if (targetMethod == null || targetMethod.isAbstract()) {
            return null;
        }
        Context targetContext = this.contextSelector.getCalleeTarget(caller, site, targetMethod, iKey);
        if (targetContext == null || targetContext.isA(IllegalArgumentExceptionContext.class)) {
            return null;
        }
        try {
            return this.getCallGraph().findOrCreateNode(targetMethod, targetContext);
        }
        catch (CancelException e) {
            return null;
        }
    }

    public ContextSelector getContextSelector() {
        return this.contextSelector;
    }

    public void setContextSelector(ContextSelector selector) {
        this.contextSelector = selector;
    }

    public InstanceKeyFactory getInstanceKeys() {
        return this.instanceKeyFactory;
    }

    public void setInstanceKeys(InstanceKeyFactory keys) {
        this.instanceKeyFactory = keys;
    }

    public InstanceKey getInstanceKeyForAllocation(CGNode node, NewSiteReference allocation) {
        return this.instanceKeyFactory.getInstanceKeyForAllocation(node, allocation);
    }

    public InstanceKey getInstanceKeyForMultiNewArray(CGNode node, NewSiteReference allocation, int dim) {
        return this.instanceKeyFactory.getInstanceKeyForMultiNewArray(node, allocation, dim);
    }

    public <T> InstanceKey getInstanceKeyForConstant(TypeReference type, T S) {
        return this.instanceKeyFactory.getInstanceKeyForConstant(type, S);
    }

    public InstanceKey getInstanceKeyForMetadataObject(Object obj, TypeReference objType) {
        return this.instanceKeyFactory.getInstanceKeyForMetadataObject(obj, objType);
    }

    public boolean haveAlreadyVisited(CGNode node) {
        return this.alreadyVisited.contains(node);
    }

    protected void markAlreadyVisited(CGNode node) {
        this.alreadyVisited.add(node);
    }

    public void markDiscovered(CGNode node) {
        this.discoveredNodes.add(node);
    }

    protected void markChanged(CGNode node) {
        this.alreadyVisited.remove(node);
        this.discoveredNodes.add(node);
    }

    protected boolean wasChanged(CGNode node) {
        return this.discoveredNodes.contains(node) && !this.alreadyVisited.contains(node);
    }

    protected MutableIntSet getMutableInstanceKeysForClass(IClass klass) {
        return this.system.cloneInstanceKeysForClass(klass);
    }

    protected IntSet getInstanceKeysForClass(IClass klass) {
        return this.system.getInstanceKeysForClass(klass);
    }

    protected IntSet filterForClass(IntSet S, IClass klass) {
        MutableIntSet filter = null;
        if (klass.getReference().equals(TypeReference.JavaLangObject)) {
            return S;
        }
        filter = this.getMutableInstanceKeysForClass(klass);
        boolean debug = false;
        filter.intersectWith(S);
        return filter;
    }

    protected IPointsToSolver getSolver() {
        return this.solver;
    }

    public void addConstraintsFromChangedNode(CGNode node, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        this.unconditionallyAddConstraintsFromNode(node, monitor);
    }

    protected abstract boolean unconditionallyAddConstraintsFromNode(CGNode var1, MonitorUtil.IProgressMonitor var2) throws CancelException;

    @Override
    public IAnalysisCacheView getAnalysisCache() {
        return this.analysisCache;
    }

    protected static class MutableBoolean {
        boolean b = false;

        protected MutableBoolean() {
        }
    }

    protected class InverseFilterOperator
    extends FilterOperator {
        @Override
        public String toString() {
            return "InverseFilter";
        }

        @Override
        public boolean isComplex() {
            return false;
        }

        @Override
        public byte evaluate(PointsToSetVariable lhs, PointsToSetVariable rhs) {
            FilteredPointerKey pk = (FilteredPointerKey)lhs.getPointerKey();
            FilteredPointerKey.TypeFilter filter = pk.getTypeFilter();
            boolean debug = false;
            if (rhs.size() == 0) {
                return 0;
            }
            boolean changed = filter.addInverseFiltered(PropagationCallGraphBuilder.this.system, lhs, rhs);
            return changed ? (byte)1 : 0;
        }
    }

    public final class InstanceArrayStoreOperator
    extends UnaryOperator<PointsToSetVariable>
    implements IPointerOperator {
        private final InstanceKey instance;
        protected final MutableIntSet priorInstances = IntSetUtil.make();

        @Override
        public String toString() {
            return "InstanceArrayStore ";
        }

        public InstanceArrayStoreOperator(InstanceKey instance) {
            this.instance = instance;
        }

        @Override
        public byte evaluate(PointsToSetVariable dummyLHS, PointsToSetVariable var) {
            PointsToSetVariable arrayref = var;
            if (arrayref.size() == 0) {
                return 0;
            }
            MutableIntSet value = arrayref.getValue();
            MutableBoolean sideEffect = new MutableBoolean();
            IntSetAction action = i -> {
                InstanceKey I2 = PropagationCallGraphBuilder.this.system.getInstanceKey(i);
                if (!I2.getConcreteType().isArrayClass()) {
                    return;
                }
                if (I2 instanceof ZeroLengthArrayInNode) {
                    return;
                }
                TypeReference C2 = I2.getConcreteType().getReference().getArrayElementType();
                if (C2.isPrimitiveType()) {
                    return;
                }
                IClass contents = PropagationCallGraphBuilder.this.getClassHierarchy().lookupClass(C2);
                if (contents == null) assert (false) : "null type for " + C2 + ' ' + I2.getConcreteType();
                PointerKey p = PropagationCallGraphBuilder.this.getPointerKeyForArrayContents(I2);
                if (contents.isInterface()) {
                    if (PropagationCallGraphBuilder.this.getClassHierarchy().implementsInterface(this.instance.getConcreteType(), contents)) {
                        sideEffect.b |= PropagationCallGraphBuilder.this.system.newConstraint(p, this.instance);
                    }
                } else if (PropagationCallGraphBuilder.this.getClassHierarchy().isSubclassOf(this.instance.getConcreteType(), contents)) {
                    sideEffect.b |= PropagationCallGraphBuilder.this.system.newConstraint(p, this.instance);
                }
            };
            if (this.priorInstances != null) {
                value.foreachExcluding(this.priorInstances, action);
                this.priorInstances.addAll(value);
            } else {
                value.foreach(action);
            }
            int sideEffectMask = sideEffect.b ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        @Override
        public int hashCode() {
            return 9839 * this.instance.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof InstanceArrayStoreOperator) {
                InstanceArrayStoreOperator other = (InstanceArrayStoreOperator)o;
                return this.instance.equals(other.instance);
            }
            return false;
        }

        @Override
        public boolean isComplex() {
            return true;
        }
    }

    public final class InstancePutFieldOperator
    extends UnaryOperator<PointsToSetVariable>
    implements IPointerOperator {
        private final IField field;
        private final InstanceKey instance;
        protected final MutableIntSet priorInstances = IntSetUtil.make();

        @Override
        public String toString() {
            return "InstancePutField" + this.field;
        }

        public InstancePutFieldOperator(IField field, InstanceKey instance) {
            this.field = field;
            this.instance = instance;
        }

        @Override
        public byte evaluate(PointsToSetVariable dummyLHS, PointsToSetVariable var) {
            PointsToSetVariable ref = var;
            if (ref.size() == 0) {
                return 0;
            }
            MutableIntSet value = ref.getValue();
            MutableBoolean sideEffect = new MutableBoolean();
            IntSetAction action = i -> {
                PointerKey p;
                InstanceKey I2 = PropagationCallGraphBuilder.this.system.getInstanceKey(i);
                if (!PropagationCallGraphBuilder.representsNullType(I2) && (p = PropagationCallGraphBuilder.this.getPointerKeyForInstanceField(I2, this.field)) != null) {
                    sideEffect.b |= PropagationCallGraphBuilder.this.system.newConstraint(p, this.instance);
                }
            };
            if (this.priorInstances != null) {
                value.foreachExcluding(this.priorInstances, action);
                this.priorInstances.addAll(value);
            } else {
                value.foreach(action);
            }
            int sideEffectMask = sideEffect.b ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        @Override
        public int hashCode() {
            return this.field.hashCode() + 9839 * this.instance.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof InstancePutFieldOperator) {
                InstancePutFieldOperator other = (InstancePutFieldOperator)o;
                return this.field.equals(other.field) && this.instance.equals(other.instance);
            }
            return false;
        }

        @Override
        public boolean isComplex() {
            return true;
        }
    }

    public class PutFieldOperator
    extends UnarySideEffect
    implements IPointerOperator {
        private final IField field;
        protected final MutableIntSet priorInstances;

        @Override
        public String toString() {
            return "PutField" + this.getField();
        }

        public PutFieldOperator(IField field, PointsToSetVariable val) {
            super(val);
            this.priorInstances = IntSetUtil.make();
            this.field = field;
            PropagationCallGraphBuilder.this.system.registerFixedSet(val, this);
        }

        @Override
        public boolean isComplex() {
            return true;
        }

        @Override
        public byte evaluate(PointsToSetVariable rhs) {
            if (rhs.size() == 0) {
                return 0;
            }
            PointsToSetVariable val = this.getFixedSet();
            PointerKey pVal = val.getPointerKey();
            IntSet value = rhs.getValue();
            value = this.filterInstances(value);
            UnaryOperator<PointsToSetVariable> assign = this.getPutAssignmentOperator();
            if (assign == null) {
                Assertions.UNREACHABLE();
            }
            MutableBoolean sideEffect = new MutableBoolean();
            IntSetAction action = i -> {
                PointerKey p;
                InstanceKey I2 = PropagationCallGraphBuilder.this.system.getInstanceKey(i);
                if (!PropagationCallGraphBuilder.representsNullType(I2) && (p = PropagationCallGraphBuilder.this.getPointerKeyForInstanceField(I2, this.getField())) != null) {
                    sideEffect.b |= PropagationCallGraphBuilder.this.system.newFieldWrite(p, assign, pVal);
                }
            };
            if (this.priorInstances != null) {
                value.foreachExcluding(this.priorInstances, action);
                this.priorInstances.addAll(value);
            } else {
                value.foreach(action);
            }
            int sideEffectMask = sideEffect.b ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        protected IntSet filterInstances(IntSet value) {
            return value;
        }

        @Override
        public int hashCode() {
            return 9857 * this.getField().hashCode() + this.getFixedSet().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o != null && o.getClass().equals(this.getClass())) {
                PutFieldOperator other = (PutFieldOperator)o;
                return this.getField().equals(other.getField()) && this.getFixedSet().equals(other.getFixedSet());
            }
            return false;
        }

        public UnaryOperator<PointsToSetVariable> getPutAssignmentOperator() {
            return assignOperator;
        }

        protected IField getField() {
            return this.field;
        }

        @Override
        protected boolean isLoadOperator() {
            return false;
        }
    }

    public class GetFieldOperator
    extends UnarySideEffect
    implements IPointerOperator {
        private final IField field;
        protected final MutableIntSet priorInstances;

        public GetFieldOperator(IField field, PointsToSetVariable def) {
            super(def);
            this.priorInstances = IntSetUtil.make();
            this.field = field;
            PropagationCallGraphBuilder.this.system.registerFixedSet(def, this);
        }

        @Override
        public String toString() {
            return "GetField " + this.getField() + ',' + this.getFixedSet().getPointerKey();
        }

        @Override
        public byte evaluate(PointsToSetVariable rhs) {
            PointsToSetVariable ref = rhs;
            if (ref.size() == 0) {
                return 0;
            }
            PointsToSetVariable def = this.getFixedSet();
            PointerKey dVal = def.getPointerKey();
            IntSet value = this.filterInstances(ref.getValue());
            MutableBoolean sideEffect = new MutableBoolean();
            IntSetAction action = i -> {
                PointerKey p;
                InstanceKey I2 = PropagationCallGraphBuilder.this.system.getInstanceKey(i);
                if (!PropagationCallGraphBuilder.representsNullType(I2) && (p = PropagationCallGraphBuilder.this.getPointerKeyForInstanceField(I2, this.getField())) != null) {
                    sideEffect.b |= PropagationCallGraphBuilder.this.system.newFieldRead(dVal, assignOperator, p);
                }
            };
            if (this.priorInstances != null) {
                value.foreachExcluding(this.priorInstances, action);
                this.priorInstances.addAll(value);
            } else {
                value.foreach(action);
            }
            int sideEffectMask = sideEffect.b ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        protected IntSet filterInstances(IntSet value) {
            return value;
        }

        @Override
        public int hashCode() {
            return 9857 * this.getField().hashCode() + this.getFixedSet().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof GetFieldOperator) {
                GetFieldOperator other = (GetFieldOperator)o;
                return this.getField().equals(other.getField()) && this.getFixedSet().equals(other.getFixedSet());
            }
            return false;
        }

        protected IField getField() {
            return this.field;
        }

        @Override
        protected boolean isLoadOperator() {
            return true;
        }

        @Override
        public boolean isComplex() {
            return true;
        }
    }

    public final class ArrayStoreOperator
    extends UnarySideEffect
    implements IPointerOperator {
        @Override
        public String toString() {
            return "ArrayStore";
        }

        public ArrayStoreOperator(PointsToSetVariable val) {
            super(val);
            PropagationCallGraphBuilder.this.system.registerFixedSet(val, this);
        }

        @Override
        public byte evaluate(PointsToSetVariable rhs) {
            if (rhs.size() == 0) {
                return 0;
            }
            PointsToSetVariable val = this.getFixedSet();
            PointerKey pVal = val.getPointerKey();
            List<InstanceKey> instances = PropagationCallGraphBuilder.this.system.getInstances(rhs.getValue());
            boolean sideEffect = false;
            for (InstanceKey I2 : instances) {
                TypeReference C2;
                if (!I2.getConcreteType().isArrayClass() || I2 instanceof ZeroLengthArrayInNode || (C2 = I2.getConcreteType().getReference().getArrayElementType()).isPrimitiveType()) continue;
                IClass contents = PropagationCallGraphBuilder.this.getClassHierarchy().lookupClass(C2);
                if (contents == null) assert (false) : "null type for " + C2 + ' ' + I2.getConcreteType();
                PointerKey p = PropagationCallGraphBuilder.this.getPointerKeyForArrayContents(I2);
                if (PropagationCallGraphBuilder.this.isJavaLangObject(contents)) {
                    sideEffect |= PropagationCallGraphBuilder.this.system.newFieldWrite(p, assignOperator, pVal);
                    continue;
                }
                sideEffect |= PropagationCallGraphBuilder.this.system.newFieldWrite(p, PropagationCallGraphBuilder.this.filterOperator, pVal);
            }
            int sideEffectMask = sideEffect ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        @Override
        public int hashCode() {
            return 9859 + super.hashCode();
        }

        @Override
        public boolean isComplex() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        protected boolean isLoadOperator() {
            return false;
        }
    }

    public final class ArrayLoadOperator
    extends UnarySideEffect
    implements IPointerOperator {
        protected final MutableIntSet priorInstances;

        @Override
        public String toString() {
            return "ArrayLoad";
        }

        public ArrayLoadOperator(PointsToSetVariable def) {
            super(def);
            this.priorInstances = IntSetUtil.make();
            PropagationCallGraphBuilder.this.system.registerFixedSet(def, this);
        }

        @Override
        public byte evaluate(PointsToSetVariable rhs) {
            if (rhs.size() == 0) {
                return 0;
            }
            PointsToSetVariable def = this.getFixedSet();
            PointerKey dVal = def.getPointerKey();
            MutableBoolean sideEffect = new MutableBoolean();
            IntSetAction action = i -> {
                InstanceKey I2 = PropagationCallGraphBuilder.this.system.getInstanceKey(i);
                if (!I2.getConcreteType().isArrayClass()) {
                    return;
                }
                TypeReference C2 = I2.getConcreteType().getReference().getArrayElementType();
                if (C2.isPrimitiveType()) {
                    return;
                }
                PointerKey p = PropagationCallGraphBuilder.this.getPointerKeyForArrayContents(I2);
                if (p == null) {
                    return;
                }
                sideEffect.b |= PropagationCallGraphBuilder.this.system.newFieldRead(dVal, assignOperator, p);
            };
            if (this.priorInstances != null) {
                rhs.getValue().foreachExcluding(this.priorInstances, action);
                this.priorInstances.addAll(rhs.getValue());
            } else {
                rhs.getValue().foreach(action);
            }
            int sideEffectMask = sideEffect.b ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        @Override
        public int hashCode() {
            return 9871 + super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        protected boolean isLoadOperator() {
            return true;
        }

        @Override
        public boolean isComplex() {
            return true;
        }
    }

    public class FilterOperator
    extends UnaryOperator<PointsToSetVariable>
    implements IPointerOperator {
        protected FilterOperator() {
        }

        @Override
        public byte evaluate(PointsToSetVariable lhs, PointsToSetVariable rhs) {
            FilteredPointerKey pk = (FilteredPointerKey)lhs.getPointerKey();
            if (rhs.size() == 0) {
                return 0;
            }
            boolean changed = false;
            FilteredPointerKey.TypeFilter filter = pk.getTypeFilter();
            changed = filter.addFiltered(PropagationCallGraphBuilder.this.system, lhs, rhs);
            return changed ? (byte)1 : 0;
        }

        @Override
        public boolean isComplex() {
            return false;
        }

        @Override
        public String toString() {
            return "Filter ";
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return 88651;
        }
    }

    public static final class TypedPointerKey
    implements FilteredPointerKey {
        private final IClass type;
        private final PointerKey base;

        static TypedPointerKey make(PointerKey base, IClass type) {
            assert (type != null);
            return new TypedPointerKey(base, type);
        }

        private TypedPointerKey(PointerKey base, IClass type) {
            this.type = type;
            this.base = base;
            assert (type != null);
            assert (!(type instanceof FilteredPointerKey));
        }

        @Override
        public FilteredPointerKey.TypeFilter getTypeFilter() {
            return new FilteredPointerKey.SingleClassFilter(this.type);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypedPointerKey) {
                TypedPointerKey other = (TypedPointerKey)obj;
                return this.type.equals(other.type) && this.base.equals(other.base);
            }
            return false;
        }

        public int hashCode() {
            return 67931 * this.base.hashCode() + this.type.hashCode();
        }

        public String toString() {
            return "{ " + this.base + " type: " + this.type + '}';
        }

        public PointerKey getBase() {
            return this.base;
        }
    }

    private static class ExceptionLookupFailure
    extends Warning {
        final TypeReference t;

        ExceptionLookupFailure(TypeReference t) {
            super((byte)2);
            this.t = t;
        }

        @Override
        public String getMsg() {
            return this.getClass().toString() + " : " + this.t;
        }

        public static ExceptionLookupFailure create(TypeReference t) {
            return new ExceptionLookupFailure(t);
        }
    }

    private static class EntrypointResolutionWarning
    extends Warning {
        final Entrypoint entrypoint;

        EntrypointResolutionWarning(Entrypoint entrypoint) {
            super((byte)2);
            this.entrypoint = entrypoint;
        }

        @Override
        public String getMsg() {
            return this.getClass().toString() + " : " + this.entrypoint;
        }

        public static EntrypointResolutionWarning create(Entrypoint entrypoint) {
            return new EntrypointResolutionWarning(entrypoint);
        }
    }
}

