/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNode;
import com.ibm.wala.ipa.callgraph.propagation.ContainerUtil;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXInstanceKeys;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.EmptyIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.strings.Atom;

public class ContainerContextSelector
implements ContextSelector {
    private static final boolean DEBUG = false;
    private static final TypeName SyntheticSystemName = TypeName.string2TypeName("Lcom/ibm/wala/model/java/lang/System");
    public static final TypeReference SyntheticSystem = TypeReference.findOrCreate(ClassLoaderReference.Primordial, SyntheticSystemName);
    public static final TypeReference JavaUtilHashtable = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/util/Hashtable");
    public static final Atom arraycopyAtom = Atom.findOrCreateUnicodeAtom("arraycopy");
    private static final Descriptor arraycopyDesc = Descriptor.findOrCreateUTF8("(Ljava/lang/Object;Ljava/lang/Object;)V");
    public static final MethodReference synthArraycopy = MethodReference.findOrCreate(SyntheticSystem, arraycopyAtom, arraycopyDesc);
    private static final TypeReference Arrays = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/util/Arrays");
    private static final Atom asList = Atom.findOrCreateUnicodeAtom("asList");
    private static final Atom copyOf = Atom.findOrCreateUnicodeAtom("copyOf");
    private static final Atom copyOfRange = Atom.findOrCreateUnicodeAtom("copyOfRange");
    private static final Atom toString = Atom.findOrCreateUnicodeAtom("toString");
    private static final MethodReference StringValueOf = MethodReference.findOrCreate(TypeReference.JavaLangString, "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
    private static final MethodReference HashtableNewEntry = MethodReference.findOrCreate(JavaUtilHashtable, "newEntry", "(Ljava/lang/Object;Ljava/lang/Object;I)Ljava/util/Hashtable$Entry;");
    private final IClassHierarchy cha;
    private final ZeroXInstanceKeys delegate;
    private static final IntSet thisParameter = IntSetUtil.make(new int[]{0});

    public ContainerContextSelector(IClassHierarchy cha, ZeroXInstanceKeys delegate) {
        this.cha = cha;
        this.delegate = delegate;
        if (delegate == null) {
            throw new IllegalArgumentException("null delegate");
        }
    }

    @Override
    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] keys) {
        InstanceKey receiver = null;
        if (keys != null && keys.length > 0 && keys[0] != null) {
            receiver = keys[0];
        }
        if (this.mayUnderstand(site, callee, receiver)) {
            if (ContainerContextSelector.isWellKnownStaticFactory(callee.getReference())) {
                return new CallerSiteContext(caller, site);
            }
            if (receiver == null) {
                Assertions.UNREACHABLE("null receiver for " + site);
            }
            return new ReceiverInstanceContext(receiver);
        }
        return null;
    }

    public static boolean isWellKnownStaticFactory(MethodReference m3) {
        if (ContainerContextSelector.isArrayCopyingMethod(m3)) {
            return true;
        }
        if (ContainerContextSelector.isArrayToStringMethod(m3)) {
            return true;
        }
        if (m3.equals(StringValueOf)) {
            return true;
        }
        return m3.equals(HashtableNewEntry);
    }

    public static boolean isArrayCopyingMethod(MethodReference m3) {
        if (m3 == null) {
            throw new IllegalArgumentException("null m");
        }
        if (m3.getDeclaringClass().equals(TypeReference.JavaLangSystem) && m3.getName().toString().equals("arraycopy")) {
            return true;
        }
        if (m3.equals(synthArraycopy)) {
            return true;
        }
        return ContainerContextSelector.isArrayCopyMethod(m3);
    }

    private static boolean isArrayCopyMethod(MethodReference m3) {
        return m3.getDeclaringClass().equals(Arrays) && (m3.getName().equals(asList) || m3.getName().equals(copyOf) || m3.getName().equals(copyOfRange));
    }

    private static boolean isArrayToStringMethod(MethodReference m3) {
        return m3.getDeclaringClass().equals(Arrays) && m3.getName().equals(toString);
    }

    public static Context findRecursiveMatchingContext(IMethod M, Context C2, InstanceKey receiver) {
        Context result = ContainerContextSelector.findRecursiveMatchingContext(M, C2);
        if (result != null) {
            return result;
        }
        if (receiver instanceof AllocationSiteInNode) {
            AllocationSiteInNode a = (AllocationSiteInNode)receiver;
            IMethod m3 = a.getNode().getMethod();
            return ContainerContextSelector.findRecursiveMatchingContext(m3, C2);
        }
        return null;
    }

    public static CGNode findNodeRecursiveMatchingContext(IMethod m3, Context c) {
        if (c.isA(ReceiverInstanceContext.class)) {
            InstanceKey receiver = (InstanceKey)c.get(ContextKey.RECEIVER);
            if (!(receiver instanceof AllocationSiteInNode)) {
                return null;
            }
            AllocationSiteInNode i = (AllocationSiteInNode)receiver;
            CGNode n = i.getNode();
            if (n.getMethod().equals(m3)) {
                return n;
            }
            return ContainerContextSelector.findNodeRecursiveMatchingContext(m3, n.getContext());
        }
        if (c.isA(CallerContext.class)) {
            CGNode n = (CGNode)c.get(ContextKey.CALLER);
            if (n.getMethod().equals(m3)) {
                return n;
            }
            return ContainerContextSelector.findNodeRecursiveMatchingContext(m3, n.getContext());
        }
        return null;
    }

    public static Context findRecursiveMatchingContext(IMethod M, Context C2) {
        CGNode n = ContainerContextSelector.findNodeRecursiveMatchingContext(M, C2);
        return n == null ? null : n.getContext();
    }

    public boolean mayUnderstand(CallSiteReference site, IMethod targetMethod, InstanceKey receiver) {
        AllocationSiteInNode I2;
        CGNode N;
        if (targetMethod == null) {
            throw new IllegalArgumentException("targetMethod is null");
        }
        if (ContainerContextSelector.isWellKnownStaticFactory(targetMethod.getReference())) {
            return true;
        }
        if (site.isStatic()) {
            return false;
        }
        if (receiver == null) {
            return false;
        }
        if (targetMethod.getDeclaringClass().getReference().equals(TypeReference.JavaLangObject)) {
            return false;
        }
        if (this.isContainer(targetMethod.getDeclaringClass())) {
            return true;
        }
        if (!this.delegate.isInteresting(receiver.getConcreteType())) {
            return false;
        }
        return receiver instanceof AllocationSiteInNode && (N = (I2 = (AllocationSiteInNode)receiver).getNode()).getContext().isA(ReceiverInstanceContext.class);
    }

    protected boolean isContainer(IClass C2) {
        return ContainerUtil.isContainer(C2);
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    @Override
    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        if (site.isDispatch()) {
            return thisParameter;
        }
        return EmptyIntSet.instance;
    }
}

