/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKeyWithFilter;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;

public class DefaultPointerKeyFactory
implements PointerKeyFactory {
    @Override
    public PointerKey getPointerKeyForLocal(CGNode node, int valueNumber) {
        if (valueNumber <= 0) {
            throw new IllegalArgumentException("illegal value number: " + valueNumber + " in " + node);
        }
        return new LocalPointerKey(node, valueNumber);
    }

    @Override
    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, FilteredPointerKey.TypeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("null filter");
        }
        assert (valueNumber > 0) : "illegal value number: " + valueNumber + " in " + node;
        return new LocalPointerKeyWithFilter(node, valueNumber, filter);
    }

    @Override
    public PointerKey getPointerKeyForReturnValue(CGNode node) {
        return new ReturnValueKey(node);
    }

    @Override
    public PointerKey getPointerKeyForExceptionalReturnValue(CGNode node) {
        return new ExceptionReturnValueKey(node);
    }

    @Override
    public PointerKey getPointerKeyForStaticField(IField f) {
        if (f == null) {
            throw new IllegalArgumentException("null f");
        }
        return new StaticFieldKey(f);
    }

    @Override
    public PointerKey getPointerKeyForInstanceField(InstanceKey I2, IField field) {
        if (field == null) {
            throw new IllegalArgumentException("field is null");
        }
        IField resolveAgain = I2.getConcreteType().getField(field.getName(), field.getFieldTypeReference().getName());
        if (resolveAgain != null) {
            field = resolveAgain;
        }
        return new InstanceFieldKey(I2, field);
    }

    @Override
    public PointerKey getPointerKeyForArrayContents(InstanceKey I2) {
        return new ArrayContentsKey(I2);
    }
}

