/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.rta;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.ClassBasedInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DefaultPointerKeyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TypeBasedHeapModel
implements HeapModel {
    private static final boolean DEBUG = false;
    final DefaultPointerKeyFactory pointerKeys = new DefaultPointerKeyFactory();
    private final ClassBasedInstanceKeys iKeyFactory;
    private final Collection<IClass> klasses;
    private final CallGraph cg;
    private final Collection<CGNode> nodesHandled = HashSetFactory.make();
    private Map<PointerKey, Object> pKeys;

    public TypeBasedHeapModel(AnalysisOptions options, Collection<IClass> klasses, CallGraph cg) {
        if (cg == null) {
            throw new IllegalArgumentException("cg is null");
        }
        this.iKeyFactory = new ClassBasedInstanceKeys(options, cg.getClassHierarchy());
        this.klasses = klasses;
        this.cg = cg;
    }

    private void initAllPKeys() {
        if (this.pKeys == null) {
            this.pKeys = HashMapFactory.make();
        }
        for (IClass klass : this.klasses) {
            this.pKeys.putAll(this.computePointerKeys(klass));
        }
        for (CGNode node : this.cg) {
            this.initPKeysForNode(node);
        }
    }

    private void initPKeysForNode(CGNode node) {
        if (this.pKeys == null) {
            this.pKeys = HashMapFactory.make();
        }
        if (!this.nodesHandled.contains(node)) {
            this.nodesHandled.add(node);
            this.pKeys.putAll(this.computePointerKeys(node));
        }
    }

    private Map<PointerKey, Object> computePointerKeys(CGNode node) {
        IR ir = node.getIR();
        if (ir == null) {
            return Collections.emptyMap();
        }
        HashMap<PointerKey, Object> result = HashMapFactory.make();
        SymbolTable s2 = ir.getSymbolTable();
        if (s2 == null) {
            return Collections.emptyMap();
        }
        TypeInference ti = TypeInference.make(ir, false);
        for (int i = 1; i <= s2.getMaxValueNumber(); ++i) {
            if (s2.isConstant(i)) {
                if (!s2.isStringConstant(i)) continue;
                TypeReference type = node.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(s2.getStringValue(i));
                result.put(this.pointerKeys.getPointerKeyForLocal(node, i), this.getInstanceKeyForConstant(type, s2.getConstantValue(i)));
                continue;
            }
            TypeAbstraction t = ti.getType(i);
            if (t.getType() == null || !t.getType().isReferenceType()) continue;
            result.put(this.pointerKeys.getPointerKeyForLocal(node, i), this.pointerKeys.getFilteredPointerKeyForLocal(node, i, new FilteredPointerKey.SingleClassFilter(t.getType())));
        }
        return result;
    }

    private Map<PointerKey, Object> computePointerKeys(IClass klass) {
        HashMap<PointerKey, Object> result = HashMapFactory.make();
        if (klass.isArrayClass()) {
            ArrayClass a = (ArrayClass)klass;
            if (a.getElementClass() != null && a.getElementClass().isReferenceType()) {
                PointerKey p = this.pointerKeys.getPointerKeyForArrayContents(new ConcreteTypeKey(a));
                result.put(p, p);
            }
        } else {
            for (IField f : klass.getAllFields()) {
                PointerKey p;
                if (f.getFieldTypeReference().isPrimitiveType()) continue;
                if (f.isStatic()) {
                    p = this.pointerKeys.getPointerKeyForStaticField(f);
                    result.put(p, p);
                    continue;
                }
                p = this.pointerKeys.getPointerKeyForInstanceField(new ConcreteTypeKey(klass), f);
                result.put(p, p);
            }
        }
        return result;
    }

    @Override
    public Iterator<PointerKey> iteratePointerKeys() {
        this.initAllPKeys();
        return IteratorUtil.filter(this.pKeys.values().iterator(), PointerKey.class);
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.iKeyFactory.getClassHierarchy();
    }

    @Override
    public InstanceKey getInstanceKeyForAllocation(CGNode node, NewSiteReference allocation) throws UnimplementedError {
        return this.iKeyFactory.getInstanceKeyForAllocation(node, allocation);
    }

    @Override
    public InstanceKey getInstanceKeyForMultiNewArray(CGNode node, NewSiteReference allocation, int dim) throws UnimplementedError {
        return this.iKeyFactory.getInstanceKeyForMultiNewArray(node, allocation, dim);
    }

    public InstanceKey getInstanceKeyForConstant(TypeReference type, Object S) {
        return this.iKeyFactory.getInstanceKeyForConstant(type, S);
    }

    public String getStringConstantForInstanceKey() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter instr, TypeReference type) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public InstanceKey getInstanceKeyForMetadataObject(Object obj, TypeReference objType) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public FilteredPointerKey getPointerKeyForLocal(CGNode node, int valueNumber) {
        this.initPKeysForNode(node);
        PointerKey p = this.pointerKeys.getPointerKeyForLocal(node, valueNumber);
        Object result = this.pKeys.get(p);
        if (result == null) {
            return null;
        }
        if (result instanceof FilteredPointerKey) {
            return (FilteredPointerKey)result;
        }
        if (result instanceof ConcreteTypeKey) {
            ConcreteTypeKey c = (ConcreteTypeKey)result;
            if (c.getConcreteType().getReference().equals(TypeReference.JavaLangString)) {
                return this.pointerKeys.getFilteredPointerKeyForLocal(node, valueNumber, new FilteredPointerKey.SingleClassFilter(c.getConcreteType()));
            }
            Assertions.UNREACHABLE("need to handle " + result.getClass());
            return null;
        }
        Assertions.UNREACHABLE("need to handle " + result.getClass());
        return null;
    }

    @Override
    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, FilteredPointerKey.TypeFilter filter) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public PointerKey getPointerKeyForReturnValue(CGNode node) {
        return this.pointerKeys.getPointerKeyForReturnValue(node);
    }

    @Override
    public PointerKey getPointerKeyForExceptionalReturnValue(CGNode node) {
        return this.pointerKeys.getPointerKeyForExceptionalReturnValue(node);
    }

    @Override
    public PointerKey getPointerKeyForStaticField(IField f) {
        return this.pointerKeys.getPointerKeyForStaticField(f);
    }

    @Override
    public PointerKey getPointerKeyForInstanceField(InstanceKey I2, IField field) {
        return this.pointerKeys.getPointerKeyForInstanceField(I2, field);
    }

    @Override
    public PointerKey getPointerKeyForArrayContents(InstanceKey I2) {
        return this.pointerKeys.getPointerKeyForArrayContents(I2);
    }

    protected ClassBasedInstanceKeys getIKeyFactory() {
        return this.iKeyFactory;
    }
}

