/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.rta;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractPointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKeyWithFilter;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.rta.TypeBasedHeapModel;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeBasedPointerAnalysis
extends AbstractPointerAnalysis {
    private final Collection<IClass> klasses;
    private final TypeBasedHeapModel heapModel;
    private final Map<IClass, OrdinalSet<InstanceKey>> pointsTo = HashMapFactory.make();

    private TypeBasedPointerAnalysis(AnalysisOptions options, Collection<IClass> klasses, CallGraph cg) throws AssertionError {
        super(cg, TypeBasedPointerAnalysis.makeInstanceKeys(klasses));
        this.klasses = klasses;
        this.heapModel = new TypeBasedHeapModel(options, klasses, cg);
    }

    private static MutableMapping<InstanceKey> makeInstanceKeys(Collection<IClass> c) {
        if (c == null) {
            throw new IllegalArgumentException("null c");
        }
        MutableMapping<InstanceKey> result = MutableMapping.make();
        for (IClass klass : c) {
            if (klass.isAbstract() || klass.isInterface()) continue;
            result.add(new ConcreteTypeKey(klass));
        }
        return result;
    }

    public static TypeBasedPointerAnalysis make(AnalysisOptions options, Collection<IClass> klasses, CallGraph cg) throws AssertionError {
        return new TypeBasedPointerAnalysis(options, klasses, cg);
    }

    @Override
    public OrdinalSet<InstanceKey> getPointsToSet(PointerKey key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        IClass type = this.inferType(key);
        if (type == null) {
            return OrdinalSet.empty();
        }
        OrdinalSet<InstanceKey> result = this.pointsTo.get(type);
        if (result == null) {
            result = this.computeOrdinalInstanceSet(type);
            this.pointsTo.put(type, result);
        }
        return result;
    }

    private OrdinalSet<InstanceKey> computeOrdinalInstanceSet(IClass type) {
        Set<IClass> klasses = null;
        if (type.isInterface()) {
            klasses = this.getCallGraph().getClassHierarchy().getImplementors(type.getReference());
        } else {
            Collection<IClass> sc = this.getCallGraph().getClassHierarchy().computeSubClasses(type.getReference());
            klasses = HashSetFactory.make();
            for (IClass c : sc) {
                if (c.isInterface()) continue;
                klasses.add(c);
            }
        }
        HashSet<IClass> c = HashSetFactory.make();
        for (IClass klass : klasses) {
            if (klass.isArrayClass()) {
                TypeReference elementType = klass.getReference().getArrayElementType();
                if (elementType.isPrimitiveType()) {
                    c.add(klass);
                    continue;
                }
                c.add(klass.getClassHierarchy().lookupClass(TypeReference.JavaLangObject.getArrayTypeForElementType()));
                continue;
            }
            if (!this.klasses.contains(klass)) continue;
            c.add(klass);
        }
        OrdinalSet<InstanceKey> result = this.toOrdinalInstanceKeySet(c);
        return result;
    }

    private OrdinalSet<InstanceKey> toOrdinalInstanceKeySet(Collection<IClass> c) {
        BimodalMutableIntSet s2 = new BimodalMutableIntSet();
        for (IClass klass : c) {
            int index = this.getInstanceKeyMapping().add(new ConcreteTypeKey(klass));
            s2.add(index);
        }
        return new OrdinalSet<InstanceKey>(s2, this.getInstanceKeyMapping());
    }

    private IClass inferType(PointerKey key) {
        if (key instanceof LocalPointerKeyWithFilter) {
            LocalPointerKeyWithFilter lpk = (LocalPointerKeyWithFilter)key;
            FilteredPointerKey.TypeFilter filter = lpk.getTypeFilter();
            assert (filter instanceof FilteredPointerKey.SingleClassFilter);
            return ((FilteredPointerKey.SingleClassFilter)filter).getConcreteType();
        }
        if (key instanceof StaticFieldKey) {
            StaticFieldKey s2 = (StaticFieldKey)key;
            return this.getCallGraph().getClassHierarchy().lookupClass(s2.getField().getFieldTypeReference());
        }
        if (key instanceof InstanceFieldKey) {
            InstanceFieldKey i = (InstanceFieldKey)key;
            return this.getCallGraph().getClassHierarchy().lookupClass(i.getField().getFieldTypeReference());
        }
        if (key instanceof ArrayContentsKey) {
            ArrayContentsKey i = (ArrayContentsKey)key;
            FilteredPointerKey.TypeFilter filter = i.getTypeFilter();
            assert (filter instanceof FilteredPointerKey.SingleClassFilter);
            return ((FilteredPointerKey.SingleClassFilter)filter).getConcreteType();
        }
        if (key instanceof ExceptionReturnValueKey) {
            return this.getCallGraph().getClassHierarchy().lookupClass(TypeReference.JavaLangException);
        }
        if (key instanceof ReturnValueKey) {
            ReturnValueKey r = (ReturnValueKey)key;
            return this.getCallGraph().getClassHierarchy().lookupClass(r.getNode().getMethod().getReturnType());
        }
        Assertions.UNREACHABLE("inferType " + key.getClass());
        return null;
    }

    @Override
    public HeapModel getHeapModel() {
        return this.heapModel;
    }

    public Collection<PointerKey> getPointerKeys() {
        return Iterator2Collection.toSet(this.heapModel.iteratePointerKeys());
    }

    @Override
    public boolean isFiltered(PointerKey pk) {
        return false;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.heapModel.getClassHierarchy();
    }
}

