/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.util;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;

public class CallGraphSearchUtil {
    private CallGraphSearchUtil() {
    }

    public static CGNode findMainMethod(CallGraph cg) {
        Descriptor d = Descriptor.findOrCreateUTF8("([Ljava/lang/String;)V");
        Atom name = Atom.findOrCreateUnicodeAtom("main");
        return CallGraphSearchUtil.findMethod(cg, d, name);
    }

    public static CGNode findMethod(CallGraph cg, Descriptor d, Atom name) {
        for (CGNode n : Iterator2Iterable.make(cg.getSuccNodes(cg.getFakeRootNode()))) {
            if (!n.getMethod().getName().equals(name) || !n.getMethod().getDescriptor().equals(d)) continue;
            return n;
        }
        for (CGNode n : cg) {
            if (!n.getMethod().getName().equals(name) || !n.getMethod().getDescriptor().equals(d)) continue;
            return n;
        }
        Assertions.UNREACHABLE("failed to find method " + name);
        return null;
    }

    public static CGNode findMethod(CallGraph cg, String name) {
        Atom a = Atom.findOrCreateUnicodeAtom(name);
        for (CGNode n : cg) {
            if (!n.getMethod().getName().equals(a)) continue;
            return n;
        }
        System.err.println("call graph " + cg);
        Assertions.UNREACHABLE("failed to find method " + name);
        return null;
    }
}

