/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cfg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cfg.EdgeFilter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;

public class PrunedCFG<I, T extends IBasicBlock<I>>
extends AbstractNumberedGraph<T>
implements ControlFlowGraph<I, T> {
    private final ControlFlowGraph<I, T> cfg;
    private final FilteredNodes<T> nodes;
    private final FilteredCFGEdges<I, T> edges;

    public static <I, T extends IBasicBlock<I>> PrunedCFG<I, T> make(ControlFlowGraph<I, T> cfg, EdgeFilter<T> filter) {
        if (cfg == null) {
            throw new IllegalArgumentException("cfg is null");
        }
        return new PrunedCFG<I, T>(cfg, filter);
    }

    private PrunedCFG(final ControlFlowGraph<I, T> cfg, final EdgeFilter<T> filter) {
        this.cfg = cfg;
        AbstractNumberedGraph temp = new AbstractNumberedGraph<T>(){
            private final NumberedEdgeManager<T> edges;
            {
                this.edges = new FilteredCFGEdges(cfg, cfg, filter);
            }

            @Override
            protected NumberedNodeManager<T> getNodeManager() {
                return cfg;
            }

            @Override
            protected NumberedEdgeManager<T> getEdgeManager() {
                return this.edges;
            }
        };
        Set reachable = DFS.getReachableNodes(temp, Collections.singleton(cfg.entry()));
        Set back = DFS.getReachableNodes(GraphInverter.invert(temp), Collections.singleton(cfg.exit()));
        reachable.retainAll(back);
        reachable.add(cfg.entry());
        reachable.add(cfg.exit());
        this.nodes = new FilteredNodes(cfg, reachable);
        this.edges = new FilteredCFGEdges<I, T>(cfg, this.nodes, filter);
    }

    @Override
    protected NumberedNodeManager<T> getNodeManager() {
        return this.nodes;
    }

    @Override
    protected NumberedEdgeManager<T> getEdgeManager() {
        return this.edges;
    }

    @Override
    public List<T> getExceptionalSuccessors(T N) {
        ArrayList<IBasicBlock> result = new ArrayList<IBasicBlock>();
        for (IBasicBlock s2 : Iterator2Iterable.make(this.edges.getExceptionalSuccessors(N))) {
            result.add(s2);
        }
        return result;
    }

    @Override
    public Collection<T> getNormalSuccessors(T N) {
        return Iterator2Collection.toSet(this.edges.getNormalSuccessors(N));
    }

    @Override
    public Collection<T> getExceptionalPredecessors(T N) {
        return Iterator2Collection.toSet(this.edges.getExceptionalPredecessors(N));
    }

    @Override
    public Collection<T> getNormalPredecessors(T N) {
        return Iterator2Collection.toSet(this.edges.getNormalPredecessors(N));
    }

    @Override
    public T entry() {
        return (T)((IBasicBlock)this.cfg.entry());
    }

    @Override
    public T exit() {
        return (T)((IBasicBlock)this.cfg.exit());
    }

    @Override
    public T getBlockForInstruction(int index) {
        return this.cfg.getBlockForInstruction(index);
    }

    @Override
    public I[] getInstructions() {
        return this.cfg.getInstructions();
    }

    @Override
    public int getProgramCounter(int index) {
        return this.cfg.getProgramCounter(index);
    }

    @Override
    public IMethod getMethod() {
        return this.cfg.getMethod();
    }

    @Override
    public BitVector getCatchBlocks() {
        BitVector result = new BitVector();
        BitVector blocks = this.cfg.getCatchBlocks();
        int i = 0;
        while ((i = blocks.nextSetBit(i)) != -1) {
            if (!this.nodes.containsNode(this.getNode(i))) continue;
            result.set(i);
        }
        return result;
    }

    public IntSet getPhiIndices(T bb) {
        assert (this.containsNode(bb));
        assert (this.cfg.containsNode(bb));
        int i = 0;
        MutableIntSet valid = IntSetUtil.make();
        for (IBasicBlock pb : Iterator2Iterable.make(this.cfg.getPredNodes(bb))) {
            if (this.nodes.containsNode(pb)) {
                valid.add(i);
            }
            ++i;
        }
        return valid;
    }

    private static class FilteredNodes<T>
    implements NumberedNodeManager<T> {
        private final NumberedNodeManager<T> nodes;
        private final Set<T> subset;

        FilteredNodes(NumberedNodeManager<T> nodes, Set<T> subset) {
            this.nodes = nodes;
            this.subset = subset;
        }

        @Override
        public int getNumber(T N) {
            if (this.subset.contains(N)) {
                return this.nodes.getNumber(N);
            }
            return -1;
        }

        @Override
        public T getNode(int number) {
            T N = this.nodes.getNode(number);
            if (this.subset.contains(N)) {
                return N;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int getMaxNumber() {
            int max = -1;
            for (Object N : this.nodes) {
                if (!this.subset.contains(N) || this.getNumber(N) <= max) continue;
                max = this.getNumber(N);
            }
            return max;
        }

        private Iterator<T> filterNodes(Iterator<T> nodeIterator) {
            return new FilterIterator<Object>(nodeIterator, this.subset::contains);
        }

        @Override
        public Iterator<T> iterateNodes(IntSet s2) {
            return this.filterNodes(this.nodes.iterateNodes(s2));
        }

        @Override
        public Iterator<T> iterator() {
            return this.filterNodes(this.nodes.iterator());
        }

        @Override
        public Stream<T> stream() {
            return this.nodes.stream().filter(this.subset::contains);
        }

        @Override
        public int getNumberOfNodes() {
            return this.subset.size();
        }

        @Override
        public void addNode(T n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeNode(T n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsNode(T N) {
            return this.subset.contains(N);
        }
    }

    private static class FilteredCFGEdges<I, T extends IBasicBlock<I>>
    implements NumberedEdgeManager<T> {
        private final ControlFlowGraph<I, T> cfg;
        private final NumberedNodeManager<T> currentCFGNodes;
        private final EdgeFilter<T> filter;

        FilteredCFGEdges(ControlFlowGraph<I, T> cfg, NumberedNodeManager<T> currentCFGNodes, EdgeFilter<T> filter) {
            this.cfg = cfg;
            this.filter = filter;
            this.currentCFGNodes = currentCFGNodes;
        }

        public Iterator<T> getExceptionalSuccessors(T N) {
            return new FilterIterator<IBasicBlock>(this.cfg.getExceptionalSuccessors(N).iterator(), o -> this.currentCFGNodes.containsNode((IBasicBlock)o) && this.filter.hasExceptionalEdge((IBasicBlock)N, (IBasicBlock)o));
        }

        public Iterator<T> getNormalSuccessors(T N) {
            return new FilterIterator<IBasicBlock>(this.cfg.getNormalSuccessors(N).iterator(), o -> this.currentCFGNodes.containsNode((IBasicBlock)o) && this.filter.hasNormalEdge((IBasicBlock)N, (IBasicBlock)o));
        }

        public Iterator<T> getExceptionalPredecessors(T N) {
            return new FilterIterator<IBasicBlock>(this.cfg.getExceptionalPredecessors(N).iterator(), o -> this.currentCFGNodes.containsNode((IBasicBlock)o) && this.filter.hasExceptionalEdge((IBasicBlock)o, (IBasicBlock)N));
        }

        public Iterator<T> getNormalPredecessors(T N) {
            return new FilterIterator<IBasicBlock>(this.cfg.getNormalPredecessors(N).iterator(), o -> this.currentCFGNodes.containsNode((IBasicBlock)o) && this.filter.hasNormalEdge((IBasicBlock)o, (IBasicBlock)N));
        }

        @Override
        public Iterator<T> getSuccNodes(T N) {
            return new FilterIterator<IBasicBlock>(this.cfg.getSuccNodes(N), o -> this.currentCFGNodes.containsNode((IBasicBlock)o) && (this.filter.hasNormalEdge((IBasicBlock)N, (IBasicBlock)o) || this.filter.hasExceptionalEdge((IBasicBlock)N, (IBasicBlock)o)));
        }

        @Override
        public int getSuccNodeCount(T N) {
            return Iterator2Collection.toSet(this.getSuccNodes(N)).size();
        }

        @Override
        public IntSet getSuccNodeNumbers(T N) {
            MutableIntSet bits = IntSetUtil.make();
            for (IBasicBlock EE : Iterator2Iterable.make(this.getSuccNodes(N))) {
                bits.add(EE.getNumber());
            }
            return bits;
        }

        @Override
        public Iterator<T> getPredNodes(T N) {
            return new FilterIterator<IBasicBlock>(this.cfg.getPredNodes(N), o -> this.currentCFGNodes.containsNode((IBasicBlock)o) && (this.filter.hasNormalEdge((IBasicBlock)o, (IBasicBlock)N) || this.filter.hasExceptionalEdge((IBasicBlock)o, (IBasicBlock)N)));
        }

        @Override
        public int getPredNodeCount(T N) {
            return Iterator2Collection.toSet(this.getPredNodes(N)).size();
        }

        @Override
        public IntSet getPredNodeNumbers(T N) {
            MutableIntSet bits = IntSetUtil.make();
            for (IBasicBlock EE : Iterator2Iterable.make(this.getPredNodes(N))) {
                bits.add(EE.getNumber());
            }
            return bits;
        }

        @Override
        public boolean hasEdge(T src, T dst) {
            for (IBasicBlock EE : Iterator2Iterable.make(this.getSuccNodes(src))) {
                if (!EE.equals(dst)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addEdge(T src, T dst) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeEdge(T src, T dst) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAllIncidentEdges(T node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeIncomingEdges(T node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeOutgoingEdges(T node) {
            throw new UnsupportedOperationException();
        }
    }
}

