/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.modref;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ModRefFieldAccess {
    private final CallGraph cg;
    private final Map<CGNode, Map<IClass, Set<IField>>> mods;
    private final Map<CGNode, Map<IClass, Set<IField>>> refs;
    private final Map<CGNode, Map<IClass, Set<IField>>> tmods;
    private final Map<CGNode, Map<IClass, Set<IField>>> trefs;
    private final List<CGNode> done;

    private ModRefFieldAccess(CallGraph cg) {
        this.cg = cg;
        this.refs = new HashMap<CGNode, Map<IClass, Set<IField>>>();
        this.mods = new HashMap<CGNode, Map<IClass, Set<IField>>>();
        this.trefs = new HashMap<CGNode, Map<IClass, Set<IField>>>();
        this.tmods = new HashMap<CGNode, Map<IClass, Set<IField>>>();
        this.done = new LinkedList<CGNode>();
    }

    public static ModRefFieldAccess compute(CallGraph cg) {
        ModRefFieldAccess fa = new ModRefFieldAccess(cg);
        fa.run();
        return fa;
    }

    public Map<IClass, Set<IField>> getMod(CGNode node) {
        return this.mods.get(node);
    }

    public Map<IClass, Set<IField>> getRef(CGNode node) {
        return this.refs.get(node);
    }

    public Map<IClass, Set<IField>> getTransitiveMod(CGNode node) {
        return this.tmods.get(node);
    }

    public Map<IClass, Set<IField>> getTransitiveRef(CGNode node) {
        return this.trefs.get(node);
    }

    private void run() {
        for (CGNode cgNode : this.cg) {
            IR ir;
            if (!this.refs.containsKey(cgNode)) {
                this.refs.put(cgNode, new HashMap());
            }
            if (!this.mods.containsKey(cgNode)) {
                this.mods.put(cgNode, new HashMap());
            }
            if ((ir = cgNode.getIR()) == null) continue;
            for (SSAInstruction instr : Iterator2Iterable.make(ir.iterateNormalInstructions())) {
                IClass cls;
                IField field;
                if (instr instanceof SSAGetInstruction) {
                    SSAGetInstruction get = (SSAGetInstruction)instr;
                    FieldReference fref = get.getDeclaredField();
                    field = this.cg.getClassHierarchy().resolveField(fref);
                    if (field == null || (cls = field.getDeclaringClass()) == null) continue;
                    if (!this.refs.get(cgNode).containsKey(cls)) {
                        this.refs.get(cgNode).put(cls, new HashSet());
                    }
                    this.refs.get(cgNode).get(cls).add(field);
                    continue;
                }
                if (!(instr instanceof SSAPutInstruction)) continue;
                SSAPutInstruction put = (SSAPutInstruction)instr;
                FieldReference fput = put.getDeclaredField();
                field = this.cg.getClassHierarchy().resolveField(fput);
                if (field == null || (cls = field.getDeclaringClass()) == null) continue;
                if (!this.mods.get(cgNode).containsKey(cls)) {
                    this.mods.get(cgNode).put(cls, new HashSet());
                }
                this.mods.get(cgNode).get(cls).add(field);
            }
        }
        this.recAdd(this.cg.getFakeRootNode());
    }

    private TwoMaps recAdd(CGNode node) {
        IR ir;
        if (!this.trefs.containsKey(node)) {
            this.trefs.put(node, new HashMap());
        }
        if (!this.tmods.containsKey(node)) {
            this.tmods.put(node, new HashMap());
        }
        if ((ir = node.getIR()) != null) {
            for (SSAInstruction instr : Iterator2Iterable.make(ir.iterateNormalInstructions())) {
                IClass cls;
                IField field;
                if (instr instanceof SSAGetInstruction) {
                    SSAGetInstruction get = (SSAGetInstruction)instr;
                    FieldReference fref = get.getDeclaredField();
                    field = this.cg.getClassHierarchy().resolveField(fref);
                    if (field == null || (cls = field.getDeclaringClass()) == null) continue;
                    if (!this.trefs.get(node).containsKey(cls)) {
                        this.trefs.get(node).put(cls, new HashSet());
                    }
                    this.trefs.get(node).get(cls).add(field);
                    continue;
                }
                if (!(instr instanceof SSAPutInstruction)) continue;
                SSAPutInstruction put = (SSAPutInstruction)instr;
                FieldReference fput = put.getDeclaredField();
                field = this.cg.getClassHierarchy().resolveField(fput);
                if (field == null || (cls = field.getDeclaringClass()) == null) continue;
                if (!this.tmods.get(node).containsKey(cls)) {
                    this.tmods.get(node).put(cls, new HashSet());
                }
                this.tmods.get(node).get(cls).add(field);
            }
        }
        for (CGNode n : Iterator2Iterable.make(this.cg.getSuccNodes(node))) {
            if (this.done.contains(n)) continue;
            this.done.add(n);
            TwoMaps t = this.recAdd(n);
            for (IClass c : t.getRefs().keySet()) {
                if (this.trefs.get(node).containsKey(c)) {
                    this.trefs.get(node).get(c).addAll((Collection<IField>)t.getRefs().get(c));
                    continue;
                }
                this.trefs.get(node).put(c, t.getRefs().get(c));
            }
            for (IClass c : t.getMods().keySet()) {
                if (this.tmods.get(node).containsKey(c)) {
                    this.tmods.get(node).get(c).addAll((Collection<IField>)t.getMods().get(c));
                    continue;
                }
                this.tmods.get(node).put(c, t.getMods().get(c));
            }
        }
        return new TwoMaps(this.tmods.get(node), this.trefs.get(node));
    }

    private static class TwoMaps {
        private Map<IClass, Set<IField>> mods;
        private Map<IClass, Set<IField>> refs;

        public TwoMaps(Map<IClass, Set<IField>> mods, Map<IClass, Set<IField>> refs) {
            this.mods = mods;
            this.refs = refs;
            if (mods == null) {
                this.mods = new HashMap<IClass, Set<IField>>();
            }
            if (refs == null) {
                this.refs = new HashMap<IClass, Set<IField>>();
            }
        }

        public Map<IClass, Set<IField>> getMods() {
            return this.mods;
        }

        public Map<IClass, Set<IField>> getRefs() {
            return this.refs;
        }
    }
}

