/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.cdg.ControlDependenceGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cfg.ExceptionPrunedCFG;
import com.ibm.wala.ipa.cfg.PrunedCFG;
import com.ibm.wala.ipa.modref.ExtendedHeapModel;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCallee;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCaller;
import com.ibm.wala.ipa.slicer.GetCaughtExceptionStatement;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ipa.slicer.HeapReachingDefs;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.MethodExitStatement;
import com.ibm.wala.ipa.slicer.NormalReturnCallee;
import com.ibm.wala.ipa.slicer.NormalReturnCaller;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.ParamCallee;
import com.ibm.wala.ipa.slicer.ParamCaller;
import com.ibm.wala.ipa.slicer.PhiStatement;
import com.ibm.wala.ipa.slicer.PiStatement;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ipa.slicer.ValueNumberCarrier;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.GraphUtil;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.dominators.Dominators;
import com.ibm.wala.util.graph.labeled.SlowSparseNumberedLabeledGraph;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class PDG<T extends InstanceKey>
implements NumberedGraph<Statement> {
    private final SlowSparseNumberedLabeledGraph<Statement, Dependency> delegate = new SlowSparseNumberedLabeledGraph(Dependency.DATA_AND_CONTROL_DEP);
    private static final boolean VERBOSE = false;
    private final CGNode node;
    private Statement[] paramCalleeStatements;
    private Statement[] returnStatements;
    private final Map<CallSiteReference, Statement> callSite2Statement = HashMapFactory.make();
    private final Map<CallSiteReference, Set<Statement>> callerParamStatements = HashMapFactory.make();
    private final Map<CallSiteReference, Set<Statement>> callerReturnStatements = HashMapFactory.make();
    private final HeapExclusions exclusions;
    private final Collection<PointerKey> locationsHandled = HashSetFactory.make();
    private final PointerAnalysis<T> pa;
    private final ExtendedHeapModel heapModel;
    private final Map<CGNode, OrdinalSet<PointerKey>> mod;
    private final Slicer.DataDependenceOptions dOptions;
    private final Slicer.ControlDependenceOptions cOptions;
    private final CallGraph cg;
    private final ModRef<T> modRef;
    private final Map<CGNode, OrdinalSet<PointerKey>> ref;
    private final boolean ignoreAllocHeapDefs;
    private boolean isPopulated = false;

    public PDG(CGNode node, PointerAnalysis<T> pa, Map<CGNode, OrdinalSet<PointerKey>> mod, Map<CGNode, OrdinalSet<PointerKey>> ref, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions, HeapExclusions exclusions, CallGraph cg, ModRef<T> modRef) {
        this(node, pa, mod, ref, dOptions, cOptions, exclusions, cg, modRef, false);
    }

    public PDG(CGNode node, PointerAnalysis<T> pa, Map<CGNode, OrdinalSet<PointerKey>> mod, Map<CGNode, OrdinalSet<PointerKey>> ref, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions, HeapExclusions exclusions, CallGraph cg, ModRef<T> modRef, boolean ignoreAllocHeapDefs) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        this.cg = cg;
        this.node = node;
        this.heapModel = pa != null ? modRef.makeHeapModel(pa) : null;
        this.pa = pa;
        this.dOptions = dOptions;
        this.cOptions = cOptions;
        this.mod = mod;
        this.exclusions = exclusions;
        this.modRef = modRef;
        this.ref = ref;
        this.ignoreAllocHeapDefs = ignoreAllocHeapDefs;
    }

    private void populate() {
        if (!this.isPopulated) {
            IR ir = this.node.getIR();
            this.isPopulated = true;
            Map<SSAInstruction, Integer> instructionIndices = PDG.computeInstructionIndices(ir);
            this.createNodes(this.ref, ir);
            this.createScalarEdges(this.cOptions, ir, instructionIndices);
        }
    }

    private void createScalarEdges(Slicer.ControlDependenceOptions cOptions, IR ir, Map<SSAInstruction, Integer> instructionIndices) {
        this.createScalarDataDependenceEdges(ir, instructionIndices);
        this.createControlDependenceEdges(cOptions, ir, instructionIndices);
    }

    public Set<Statement> getCallerParamStatements(SSAAbstractInvokeInstruction call) throws IllegalArgumentException {
        if (call == null) {
            throw new IllegalArgumentException("call == null");
        }
        this.populate();
        return this.callerParamStatements.get(call.getCallSite());
    }

    public Set<Statement> getCallStatements(SSAAbstractInvokeInstruction call) throws IllegalArgumentException {
        Set<Statement> callerParamStatements = this.getCallerParamStatements(call);
        HashSet<Statement> result = HashSetFactory.make(callerParamStatements.size() + 1);
        result.addAll(callerParamStatements);
        result.add(this.callSite2Statement.get(call.getCallSite()));
        return result;
    }

    public Set<Statement> getCallerReturnStatements(SSAAbstractInvokeInstruction call) throws IllegalArgumentException {
        if (call == null) {
            throw new IllegalArgumentException("call == null");
        }
        this.populate();
        return this.callerReturnStatements.get(call.getCallSite());
    }

    private void createControlDependenceEdges(Slicer.ControlDependenceOptions cOptions, IR ir, Map<SSAInstruction, Integer> instructionIndices) {
        if (cOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
            return;
        }
        if (ir == null) {
            return;
        }
        ControlFlowGraph<SSAInstruction, ISSABasicBlock> controlFlowGraph = ir.getControlFlowGraph();
        if (cOptions.isIgnoreExceptions()) {
            PrunedCFG<SSAInstruction, ISSABasicBlock> prunedCFG = ExceptionPrunedCFG.make(controlFlowGraph);
            if (prunedCFG.getNumberOfNodes() == 2 && prunedCFG.containsNode((ISSABasicBlock)controlFlowGraph.entry()) && prunedCFG.containsNode((ISSABasicBlock)controlFlowGraph.exit()) && GraphUtil.countEdges(prunedCFG) == 0L) {
                return;
            }
            controlFlowGraph = prunedCFG;
        } else {
            Assertions.productionAssertion(cOptions.equals((Object)Slicer.ControlDependenceOptions.FULL));
        }
        ControlDependenceGraph<ISSABasicBlock> cdg = new ControlDependenceGraph<ISSABasicBlock>(controlFlowGraph);
        for (ISSABasicBlock bb : cdg) {
            if (bb.isExitBlock()) continue;
            Statement src = null;
            if (bb.isEntryBlock()) {
                src = new MethodEntryStatement(this.node);
            } else {
                SSAInstruction s2 = ir.getInstructions()[bb.getLastInstructionIndex()];
                if (s2 != null) {
                    src = this.ssaInstruction2Statement(s2, ir, instructionIndices);
                }
            }
            if (src == null) continue;
            for (ISSABasicBlock bb2 : Iterator2Iterable.make(cdg.getSuccNodes(bb))) {
                for (SSAInstruction st : bb2) {
                    if (st == null) continue;
                    Statement dest = this.ssaInstruction2Statement(st, ir, instructionIndices);
                    assert (src != null);
                    this.delegate.addEdge(src, dest);
                    this.delegate.addEdge(src, dest, Dependency.CONTROL_DEP);
                }
            }
        }
        MethodEntryStatement methodEntry = new MethodEntryStatement(this.node);
        Dominators dom = Dominators.make(controlFlowGraph, controlFlowGraph.entry());
        for (ISSABasicBlock exitDom : Iterator2Iterable.make(dom.dominators(controlFlowGraph.exit()))) {
            for (SSAInstruction st : exitDom) {
                Statement dest = this.ssaInstruction2Statement(st, ir, instructionIndices);
                this.delegate.addEdge(methodEntry, dest);
                this.delegate.addEdge(methodEntry, dest, Dependency.CONTROL_DEP);
            }
        }
        if (!this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
            for (ISSABasicBlock bb : cdg) {
                for (SSAPhiInstruction phi : Iterator2Iterable.make(bb.iteratePhis())) {
                    Statement phiSt = this.ssaInstruction2Statement(phi, ir, instructionIndices);
                    int phiUseIndex = 0;
                    for (ISSABasicBlock pb : Iterator2Iterable.make(controlFlowGraph.getPredNodes(bb))) {
                        int use = phi.getUse(phiUseIndex);
                        if (use == -1) continue;
                        if (controlFlowGraph.getSuccNodeCount(pb) > 1) {
                            SSAInstruction pss = ir.getInstructions()[pb.getLastInstructionIndex()];
                            assert (pss != null);
                            Statement pst = this.ssaInstruction2Statement(pss, ir, instructionIndices);
                            this.delegate.addEdge(pst, phiSt);
                            this.delegate.addEdge(pst, phiSt, Dependency.CONTROL_DEP);
                        } else {
                            for (ISSABasicBlock cpb : Iterator2Iterable.make(cdg.getPredNodes(pb))) {
                                if (cpb.getLastInstructionIndex() < 0) continue;
                                SSAInstruction cps = ir.getInstructions()[cpb.getLastInstructionIndex()];
                                assert (cps != null) : "unexpected null final instruction for CDG predecessor " + cpb + " in node " + this.node;
                                Statement cpst = this.ssaInstruction2Statement(cps, ir, instructionIndices);
                                this.delegate.addEdge(cpst, phiSt);
                                this.delegate.addEdge(cpst, phiSt, Dependency.CONTROL_DEP);
                            }
                        }
                        ++phiUseIndex;
                    }
                }
            }
        }
    }

    private void createScalarDataDependenceEdges(IR ir, Map<SSAInstruction, Integer> instructionIndices) {
        Object st;
        if (this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
            return;
        }
        if (ir == null) {
            return;
        }
        DefUse DU = new DefUse(ir);
        SSAInstruction[] instructions = ir.getInstructions();
        if (!this.dOptions.isIgnoreExceptions()) {
            for (ISSABasicBlock bb : ir.getControlFlowGraph()) {
                SSACFG.ExceptionHandlerBasicBlock ehbb;
                if (!bb.isCatchBlock() || (ehbb = (SSACFG.ExceptionHandlerBasicBlock)bb).getCatchInstruction() == null) continue;
                Statement c = this.ssaInstruction2Statement(ehbb.getCatchInstruction(), ir, instructionIndices);
                for (ISSABasicBlock pb : ir.getControlFlowGraph().getExceptionalPredecessors(ehbb)) {
                    st = instructions[pb.getLastInstructionIndex()];
                    if (st instanceof SSAAbstractInvokeInstruction) {
                        this.delegate.addEdge(new ExceptionalReturnCaller(this.node, pb.getLastInstructionIndex()), c);
                        continue;
                    }
                    if (!(st instanceof SSAAbstractThrowInstruction)) continue;
                    this.delegate.addEdge(this.ssaInstruction2Statement((SSAInstruction)st, ir, instructionIndices), c);
                }
            }
        }
        block10: for (Statement s2 : this) {
            switch (s2.getKind()) {
                case NORMAL: 
                case CATCH: 
                case PI: 
                case PHI: {
                    SSAInstruction statement = PDG.statement2SSAInstruction(instructions, s2);
                    if (statement instanceof SSAAbstractInvokeInstruction) continue block10;
                    if (this.dOptions.isTerminateAtCast() && statement instanceof SSACheckCastInstruction || this.dOptions.isTerminateAtCast() && statement instanceof SSAInstanceofInstruction) break;
                    for (int i = 0; i < statement.getNumberOfDefs(); ++i) {
                        int def = statement.getDef(i);
                        for (SSAInstruction use : Iterator2Iterable.make(DU.getUses(def))) {
                            SSAArrayReferenceInstruction arr;
                            int base;
                            if (this.dOptions.isIgnoreBasePtrs() && (use instanceof SSANewInstruction || PDG.hasBasePointer(use) && (def == (base = PDG.getBasePointer(use)) || use instanceof SSAArrayReferenceInstruction && def == (arr = (SSAArrayReferenceInstruction)use).getIndex()))) continue;
                            Statement u = this.ssaInstruction2Statement(use, ir, instructionIndices);
                            this.delegate.addEdge(s2, u);
                        }
                    }
                    continue block10;
                }
                case EXC_RET_CALLER: 
                case NORMAL_RET_CALLER: 
                case PARAM_CALLEE: {
                    if (this.dOptions.isIgnoreExceptions()) assert (!s2.getKind().equals((Object)Statement.Kind.EXC_RET_CALLER));
                    ValueNumberCarrier a = (ValueNumberCarrier)((Object)s2);
                    for (SSAInstruction use : Iterator2Iterable.make(DU.getUses(a.getValueNumber()))) {
                        if (this.dOptions.isIgnoreBasePtrs()) {
                            if (use instanceof SSANewInstruction) continue;
                            if (PDG.hasBasePointer(use)) {
                                int base = PDG.getBasePointer(use);
                                if (a.getValueNumber() == base) continue;
                                if (use instanceof SSAArrayReferenceInstruction) {
                                    SSAArrayReferenceInstruction arr = (SSAArrayReferenceInstruction)use;
                                    if (a.getValueNumber() == arr.getIndex()) continue;
                                }
                            }
                        }
                        Statement u = this.ssaInstruction2Statement(use, ir, instructionIndices);
                        this.delegate.addEdge(s2, u);
                    }
                    continue block10;
                }
                case NORMAL_RET_CALLEE: {
                    for (NormalStatement ret : this.computeReturnStatements(ir)) {
                        this.delegate.addEdge(ret, s2);
                    }
                    continue block10;
                }
                case EXC_RET_CALLEE: {
                    if (this.dOptions.isIgnoreExceptions()) {
                        Assertions.UNREACHABLE();
                    }
                    IntIterator ii = PDG.getPEIs(ir).intIterator();
                    while (ii.hasNext()) {
                        int index = ii.next();
                        SSAInstruction pei = ir.getInstructions()[index];
                        if (this.dOptions.isTerminateAtCast() && pei instanceof SSACheckCastInstruction) continue;
                        if (pei instanceof SSAAbstractInvokeInstruction) {
                            if (this.dOptions.isIgnoreExceptions()) continue;
                            ExceptionalReturnCaller st2 = new ExceptionalReturnCaller(this.node, index);
                            this.delegate.addEdge(st2, s2);
                            continue;
                        }
                        this.delegate.addEdge(new NormalStatement(this.node, index), s2);
                    }
                    continue block10;
                }
                case PARAM_CALLER: {
                    ParamCaller pac = (ParamCaller)s2;
                    int vn = pac.getValueNumber();
                    if (vn <= -1) continue block10;
                    if (ir.getSymbolTable().isParameter(vn)) {
                        ParamCallee a = new ParamCallee(this.node, vn);
                        this.delegate.addEdge(a, pac);
                        break;
                    }
                    SSAInstruction d = DU.getDef(vn);
                    if (this.dOptions.isTerminateAtCast() && d instanceof SSACheckCastInstruction) break;
                    if (d == null) continue block10;
                    if (d instanceof SSAAbstractInvokeInstruction) {
                        SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)d;
                        if (vn == call.getException()) {
                            if (this.dOptions.isIgnoreExceptions()) continue block10;
                            st = new ExceptionalReturnCaller(this.node, instructionIndices.get(d));
                            this.delegate.addEdge((Statement)st, pac);
                            break;
                        }
                        st = new NormalReturnCaller(this.node, instructionIndices.get(d));
                        this.delegate.addEdge((Statement)st, pac);
                        break;
                    }
                    Statement ds = this.ssaInstruction2Statement(d, ir, instructionIndices);
                    this.delegate.addEdge(ds, pac);
                    break;
                }
                case HEAP_RET_CALLEE: 
                case HEAP_RET_CALLER: 
                case HEAP_PARAM_CALLER: 
                case HEAP_PARAM_CALLEE: 
                case METHOD_ENTRY: 
                case METHOD_EXIT: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE(s2.toString());
                }
            }
        }
    }

    private void createHeapDataDependenceEdges(PointerKey pk) {
        if (this.locationsHandled.contains(pk)) {
            return;
        }
        this.locationsHandled.add(pk);
        if (this.dOptions.isIgnoreHeap() || this.exclusions != null && this.exclusions.excludes(pk)) {
            return;
        }
        TypeReference t = HeapExclusions.getType(pk);
        if (t == null) {
            return;
        }
        IR ir = this.node.getIR();
        if (ir == null) {
            return;
        }
        Predicate<Statement> f = o -> {
            if (o instanceof HeapStatement) {
                HeapStatement h2 = (HeapStatement)o;
                return h2.getLocation().equals(pk);
            }
            return true;
        };
        Iterator2Set<Statement> relevantStatements = Iterator2Collection.toSet(new FilterIterator<Statement>(this.iterator(), f));
        Map<Statement, OrdinalSet<Statement>> heapReachingDefs = new HeapReachingDefs<T>(this.modRef, this.heapModel).computeReachingDefs(this.node, ir, this.pa, this.mod, relevantStatements, new HeapExclusions(SetComplement.complement(new SingletonSet(t))), this.cg);
        block6: for (Map.Entry<Statement, OrdinalSet<Statement>> entry : heapReachingDefs.entrySet()) {
            switch (entry.getKey().getKind()) {
                case NORMAL: 
                case CATCH: 
                case PI: 
                case PHI: {
                    OrdinalSet<Statement> defs = entry.getValue();
                    if (defs == null) continue block6;
                    for (Statement def : defs) {
                        this.delegate.addEdge(def, entry.getKey());
                    }
                    continue block6;
                }
                case EXC_RET_CALLER: 
                case NORMAL_RET_CALLER: 
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLEE: 
                case EXC_RET_CALLEE: 
                case PARAM_CALLER: {
                    break;
                }
                case HEAP_RET_CALLEE: 
                case HEAP_RET_CALLER: 
                case HEAP_PARAM_CALLER: {
                    OrdinalSet<Statement> defs = entry.getValue();
                    if (defs == null) continue block6;
                    for (Statement def : defs) {
                        this.delegate.addEdge(def, entry.getKey());
                    }
                    continue block6;
                }
                case HEAP_PARAM_CALLEE: 
                case METHOD_ENTRY: 
                case METHOD_EXIT: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE(entry.getKey().toString());
                }
            }
        }
    }

    private static boolean hasBasePointer(SSAInstruction use) {
        if (use instanceof SSAFieldAccessInstruction) {
            SSAFieldAccessInstruction f = (SSAFieldAccessInstruction)use;
            return !f.isStatic();
        }
        if (use instanceof SSAArrayReferenceInstruction) {
            return true;
        }
        return use instanceof SSAArrayLengthInstruction;
    }

    private static int getBasePointer(SSAInstruction use) {
        if (use instanceof SSAFieldAccessInstruction) {
            SSAFieldAccessInstruction f = (SSAFieldAccessInstruction)use;
            return f.getRef();
        }
        if (use instanceof SSAArrayReferenceInstruction) {
            SSAArrayReferenceInstruction a = (SSAArrayReferenceInstruction)use;
            return a.getArrayRef();
        }
        if (use instanceof SSAArrayLengthInstruction) {
            SSAArrayLengthInstruction s2 = (SSAArrayLengthInstruction)use;
            return s2.getArrayRef();
        }
        Assertions.UNREACHABLE("BOOM");
        return -1;
    }

    private Collection<NormalStatement> computeReturnStatements(IR ir) {
        Predicate<Statement> filter = o -> {
            if (o instanceof NormalStatement) {
                NormalStatement s2 = (NormalStatement)o;
                SSAInstruction st = ir.getInstructions()[s2.getInstructionIndex()];
                return st instanceof SSAReturnInstruction;
            }
            return false;
        };
        return Iterator2Collection.toSet(new MapIterator<Statement, NormalStatement>(new FilterIterator<Statement>(this.iterator(), filter), NormalStatement.class::cast));
    }

    private static IntSet getPEIs(IR ir) {
        BitVectorIntSet result = new BitVectorIntSet();
        for (int i = 0; i < ir.getInstructions().length; ++i) {
            if (ir.getInstructions()[i] == null || !ir.getInstructions()[i].isPEI()) continue;
            result.add(i);
        }
        return result;
    }

    private Statement ssaInstruction2Statement(SSAInstruction s2, IR ir, Map<SSAInstruction, Integer> instructionIndices) {
        return PDG.ssaInstruction2Statement(this.node, s2, instructionIndices, ir);
    }

    public static synchronized Statement ssaInstruction2Statement(CGNode node, SSAInstruction s2, Map<SSAInstruction, Integer> instructionIndices, IR ir) {
        if (node == null) {
            throw new IllegalArgumentException("null node");
        }
        if (s2 == null) {
            throw new IllegalArgumentException("null s");
        }
        if (s2 instanceof SSAPhiInstruction) {
            SSAPhiInstruction phi = (SSAPhiInstruction)s2;
            return new PhiStatement(node, phi);
        }
        if (s2 instanceof SSAPiInstruction) {
            SSAPiInstruction pi = (SSAPiInstruction)s2;
            return new PiStatement(node, pi);
        }
        if (s2 instanceof SSAGetCaughtExceptionInstruction) {
            return new GetCaughtExceptionStatement(node, (SSAGetCaughtExceptionInstruction)s2);
        }
        Integer x = instructionIndices.get(s2);
        if (x == null) {
            Assertions.UNREACHABLE(s2.toString() + "\nnot found in map of\n" + ir);
        }
        return new NormalStatement(node, x);
    }

    public static Map<SSAInstruction, Integer> computeInstructionIndices(IR ir) {
        HashMap<SSAInstruction, Integer> result = HashMapFactory.make();
        if (ir != null) {
            SSAInstruction[] instructions = ir.getInstructions();
            for (int i = 0; i < instructions.length; ++i) {
                SSAInstruction s2 = instructions[i];
                if (s2 == null) continue;
                result.put(s2, i);
            }
        }
        return result;
    }

    private static SSAInstruction statement2SSAInstruction(SSAInstruction[] instructions, Statement s2) {
        SSAInstruction statement = null;
        switch (s2.getKind()) {
            case NORMAL: {
                NormalStatement n = (NormalStatement)s2;
                statement = instructions[n.getInstructionIndex()];
                break;
            }
            case PHI: {
                PhiStatement p = (PhiStatement)s2;
                statement = p.getPhi();
                break;
            }
            case PI: {
                PiStatement ps = (PiStatement)s2;
                statement = ps.getPi();
                break;
            }
            case CATCH: {
                GetCaughtExceptionStatement g2 = (GetCaughtExceptionStatement)s2;
                statement = g2.getInstruction();
                break;
            }
            default: {
                Assertions.UNREACHABLE(s2.toString());
            }
        }
        return statement;
    }

    private void createNodes(Map<CGNode, OrdinalSet<PointerKey>> ref, IR ir) {
        if (ir != null) {
            this.createNormalStatements(ir, ref);
            this.createSpecialStatements(ir);
        }
        this.createCalleeParams();
        this.createReturnStatements();
        this.delegate.addNode(new MethodEntryStatement(this.node));
        this.delegate.addNode(new MethodExitStatement(this.node));
    }

    private void createReturnStatements() {
        ArrayList<Statement> list = new ArrayList<Statement>();
        if (!this.node.getMethod().getReturnType().equals(TypeReference.Void)) {
            NormalReturnCallee n = new NormalReturnCallee(this.node);
            this.delegate.addNode(n);
            list.add(n);
        }
        if (!this.dOptions.isIgnoreExceptions()) {
            ExceptionalReturnCallee e = new ExceptionalReturnCallee(this.node);
            this.delegate.addNode(e);
            list.add(e);
        }
        if (!this.dOptions.isIgnoreHeap()) {
            for (PointerKey p : this.mod.get(this.node)) {
                HeapStatement.HeapReturnCallee h2 = new HeapStatement.HeapReturnCallee(this.node, p);
                this.delegate.addNode(h2);
                list.add(h2);
            }
        }
        this.returnStatements = new Statement[list.size()];
        list.toArray(this.returnStatements);
    }

    private void createCalleeParams() {
        if (this.paramCalleeStatements == null) {
            ArrayList<Statement> list = new ArrayList<Statement>();
            int paramCount = this.node.getMethod().getNumberOfParameters();
            for (int i = 1; i <= paramCount; ++i) {
                ParamCallee s2 = new ParamCallee(this.node, i);
                this.delegate.addNode(s2);
                list.add(s2);
            }
            if (!this.dOptions.isIgnoreHeap()) {
                for (PointerKey p : this.ref.get(this.node)) {
                    HeapStatement.HeapParamCallee h2 = new HeapStatement.HeapParamCallee(this.node, p);
                    this.delegate.addNode(h2);
                    list.add(h2);
                }
            }
            this.paramCalleeStatements = new Statement[list.size()];
            list.toArray(this.paramCalleeStatements);
        }
    }

    private void createSpecialStatements(IR ir) {
        for (SSAInstruction s2 : Iterator2Iterable.make(ir.iterateAllInstructions())) {
            if (s2 instanceof SSAPhiInstruction) {
                this.delegate.addNode(new PhiStatement(this.node, (SSAPhiInstruction)s2));
                continue;
            }
            if (s2 instanceof SSAGetCaughtExceptionInstruction) {
                this.delegate.addNode(new GetCaughtExceptionStatement(this.node, (SSAGetCaughtExceptionInstruction)s2));
                continue;
            }
            if (!(s2 instanceof SSAPiInstruction)) continue;
            this.delegate.addNode(new PiStatement(this.node, (SSAPiInstruction)s2));
        }
    }

    private void createNormalStatements(IR ir, Map<CGNode, OrdinalSet<PointerKey>> ref) {
        SSAInstruction[] instructions = ir.getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            SSAInstruction s2 = instructions[i];
            if (s2 instanceof SSAGetCaughtExceptionInstruction || s2 == null) continue;
            NormalStatement statement = new NormalStatement(this.node, i);
            this.delegate.addNode(statement);
            if (!(s2 instanceof SSAAbstractInvokeInstruction)) continue;
            this.callSite2Statement.put(((SSAAbstractInvokeInstruction)s2).getCallSite(), statement);
            this.addParamPassingStatements(i, ref, ir);
        }
    }

    private void addParamPassingStatements(int callIndex, Map<CGNode, OrdinalSet<PointerKey>> ref, IR ir) {
        SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)ir.getInstructions()[callIndex];
        Set<Statement> params = MapUtil.findOrCreateSet(this.callerParamStatements, call.getCallSite());
        Set<Statement> rets = MapUtil.findOrCreateSet(this.callerReturnStatements, call.getCallSite());
        for (int j = 0; j < call.getNumberOfUses(); ++j) {
            ParamCaller st = new ParamCaller(this.node, callIndex, call.getUse(j));
            this.delegate.addNode(st);
            params.add(st);
        }
        if (!call.getDeclaredResultType().equals(TypeReference.Void)) {
            NormalReturnCaller st = new NormalReturnCaller(this.node, callIndex);
            this.delegate.addNode(st);
            rets.add(st);
        }
        if (!this.dOptions.isIgnoreExceptions()) {
            ExceptionalReturnCaller st = new ExceptionalReturnCaller(this.node, callIndex);
            this.delegate.addNode(st);
            rets.add(st);
        }
        if (!this.dOptions.isIgnoreHeap()) {
            OrdinalSet<PointerKey> uref = PDG.unionHeapLocations(this.cg, this.node, call, ref);
            for (PointerKey p : uref) {
                HeapStatement.HeapParamCaller st = new HeapStatement.HeapParamCaller(this.node, callIndex, p);
                this.delegate.addNode(st);
                params.add(st);
            }
            OrdinalSet<PointerKey> umod = PDG.unionHeapLocations(this.cg, this.node, call, this.mod);
            for (PointerKey p : umod) {
                HeapStatement.HeapReturnCaller st = new HeapStatement.HeapReturnCaller(this.node, callIndex, p);
                this.delegate.addNode(st);
                rets.add(st);
            }
        }
    }

    private static OrdinalSet<PointerKey> unionHeapLocations(CallGraph cg, CGNode n, SSAAbstractInvokeInstruction call, Map<CGNode, OrdinalSet<PointerKey>> loc) {
        BitVectorIntSet bv = new BitVectorIntSet();
        for (CGNode t : cg.getPossibleTargets(n, call.getCallSite())) {
            bv.addAll(loc.get(t).getBackingSet());
        }
        return new OrdinalSet<PointerKey>(bv, loc.get(n).getMapping());
    }

    public String toString() {
        this.populate();
        return "PDG for " + this.node + ":\n" + super.toString();
    }

    public Statement[] getParamCalleeStatements() {
        if (this.paramCalleeStatements == null) {
            this.createCalleeParams();
        }
        Statement[] result = new Statement[this.paramCalleeStatements.length];
        System.arraycopy(this.paramCalleeStatements, 0, result, 0, result.length);
        return result;
    }

    public Statement[] getReturnStatements() {
        this.populate();
        Statement[] result = new Statement[this.returnStatements.length];
        System.arraycopy(this.returnStatements, 0, result, 0, result.length);
        return result;
    }

    public CGNode getCallGraphNode() {
        return this.node;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            return this.node.equals(((PDG)obj).node);
        }
        return false;
    }

    public int hashCode() {
        return 103 * this.node.hashCode();
    }

    @Override
    public int getPredNodeCount(Statement N) throws UnimplementedError {
        this.populate();
        Assertions.UNREACHABLE();
        return this.delegate.getPredNodeCount(N);
    }

    @Override
    public Iterator<Statement> getPredNodes(Statement N) {
        this.populate();
        if (!this.dOptions.isIgnoreHeap()) {
            this.computeIncomingHeapDependencies(N);
        }
        return this.delegate.getPredNodes(N);
    }

    private void computeIncomingHeapDependencies(Statement N) {
        switch (N.getKind()) {
            case NORMAL: {
                NormalStatement st = (NormalStatement)N;
                if (this.ignoreAllocHeapDefs && st.getInstruction() instanceof SSANewInstruction) break;
                Set<PointerKey> ref = this.modRef.getRef(this.node, this.heapModel, this.pa, st.getInstruction(), this.exclusions);
                for (PointerKey pk : ref) {
                    this.createHeapDataDependenceEdges(pk);
                }
                break;
            }
            case HEAP_RET_CALLEE: 
            case HEAP_RET_CALLER: 
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: {
                HeapStatement h2 = (HeapStatement)N;
                this.createHeapDataDependenceEdges(h2.getLocation());
                break;
            }
        }
    }

    private void computeOutgoingHeapDependencies(Statement N) {
        switch (N.getKind()) {
            case NORMAL: {
                NormalStatement st = (NormalStatement)N;
                if (this.ignoreAllocHeapDefs && st.getInstruction() instanceof SSANewInstruction) break;
                Set<PointerKey> mod = this.modRef.getMod(this.node, this.heapModel, this.pa, st.getInstruction(), this.exclusions);
                for (PointerKey pk : mod) {
                    this.createHeapDataDependenceEdges(pk);
                }
                break;
            }
            case HEAP_RET_CALLEE: 
            case HEAP_RET_CALLER: 
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: {
                HeapStatement h2 = (HeapStatement)N;
                this.createHeapDataDependenceEdges(h2.getLocation());
                break;
            }
        }
    }

    @Override
    public int getSuccNodeCount(Statement N) throws UnimplementedError {
        this.populate();
        Assertions.UNREACHABLE();
        return this.delegate.getSuccNodeCount(N);
    }

    @Override
    public Iterator<Statement> getSuccNodes(Statement N) {
        this.populate();
        if (!this.dOptions.isIgnoreHeap()) {
            this.computeOutgoingHeapDependencies(N);
        }
        return this.delegate.getSuccNodes(N);
    }

    @Override
    public boolean hasEdge(Statement src, Statement dst) throws UnimplementedError {
        this.populate();
        return this.delegate.hasEdge(src, dst);
    }

    @Override
    public void removeNodeAndEdges(Statement N) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addNode(Statement n) {
        Assertions.UNREACHABLE();
    }

    @Override
    public boolean containsNode(Statement N) {
        this.populate();
        return this.delegate.containsNode(N);
    }

    @Override
    public int getNumberOfNodes() {
        this.populate();
        return this.delegate.getNumberOfNodes();
    }

    @Override
    public Iterator<Statement> iterator() {
        this.populate();
        return this.delegate.iterator();
    }

    @Override
    public Stream<Statement> stream() {
        this.populate();
        return this.delegate.stream();
    }

    @Override
    public void removeNode(Statement n) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addEdge(Statement src, Statement dst) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeAllIncidentEdges(Statement node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeEdge(Statement src, Statement dst) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeIncomingEdges(Statement node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeOutgoingEdges(Statement node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public int getMaxNumber() {
        this.populate();
        return this.delegate.getMaxNumber();
    }

    @Override
    public Statement getNode(int number) {
        this.populate();
        return (Statement)this.delegate.getNode(number);
    }

    @Override
    public int getNumber(Statement N) {
        this.populate();
        return this.delegate.getNumber(N);
    }

    @Override
    public Iterator<Statement> iterateNodes(IntSet s2) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getPredNodeNumbers(Statement node) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getSuccNodeNumbers(Statement node) {
        Assertions.UNREACHABLE();
        return null;
    }

    public boolean isControlDependend(Statement from, Statement to) {
        return this.delegate.hasEdge(from, to, Dependency.CONTROL_DEP);
    }

    private static class SetComplement
    extends SetOfClasses
    implements Serializable {
        private static final long serialVersionUID = -3256390509887654323L;
        private final SetOfClasses set;

        SetComplement(SetOfClasses set) {
            this.set = set;
        }

        static SetComplement complement(SetOfClasses set) {
            return new SetComplement(set);
        }

        @Override
        public void add(String klass) {
            Assertions.UNREACHABLE();
        }

        @Override
        public boolean contains(String klassName) {
            return !this.set.contains(klassName);
        }
    }

    private static class SingletonSet
    extends SetOfClasses
    implements Serializable {
        private static final long serialVersionUID = -3256390509887654324L;
        private final TypeReference t;

        SingletonSet(TypeReference t) {
            this.t = t;
        }

        @Override
        public void add(String klass) {
            Assertions.UNREACHABLE();
        }

        @Override
        public boolean contains(String klassName) {
            return this.t.getName().toString().substring(1).equals(klassName);
        }
    }

    public static enum Dependency {
        CONTROL_DEP,
        DATA_AND_CONTROL_DEP;

    }
}

