/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCaller;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.ISDG;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.MethodExitStatement;
import com.ibm.wala.ipa.slicer.NormalReturnCaller;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.PDG;
import com.ibm.wala.ipa.slicer.ParamCaller;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;
import java.util.stream.Stream;

class SDGSupergraph
implements ISupergraph<Statement, PDG<? extends InstanceKey>> {
    private final ISDG sdg;
    private final boolean backward;

    public SDGSupergraph(ISDG sdg, boolean backward) {
        this.sdg = sdg;
        this.backward = backward;
    }

    @Override
    public Graph<PDG<? extends InstanceKey>> getProcedureGraph() {
        Assertions.UNREACHABLE();
        return null;
    }

    public Object[] getEntry() {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public byte classifyEdge(Statement src, Statement dest) {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public Iterator<? extends Statement> getCallSites(Statement r, PDG<? extends InstanceKey> callee) {
        switch (r.getKind()) {
            case EXC_RET_CALLER: {
                ExceptionalReturnCaller n = (ExceptionalReturnCaller)r;
                SSAAbstractInvokeInstruction call = n.getInstruction();
                PDG<? extends InstanceKey> pdg = this.getProcOf(r);
                return pdg.getCallStatements(call).iterator();
            }
            case NORMAL_RET_CALLER: {
                NormalReturnCaller n = (NormalReturnCaller)r;
                SSAAbstractInvokeInstruction call = n.getInstruction();
                PDG<? extends InstanceKey> pdg = this.getProcOf(r);
                return pdg.getCallStatements(call).iterator();
            }
            case HEAP_RET_CALLER: {
                HeapStatement.HeapReturnCaller n = (HeapStatement.HeapReturnCaller)r;
                SSAAbstractInvokeInstruction call = n.getCall();
                PDG<? extends InstanceKey> pdg = this.getProcOf(r);
                return pdg.getCallStatements(call).iterator();
            }
        }
        Assertions.UNREACHABLE(r.getKind().toString());
        return null;
    }

    @Override
    public Iterator<? extends Statement> getCalledNodes(Statement call) {
        switch (call.getKind()) {
            case NORMAL: {
                return new FilterIterator<Statement>(this.getSuccNodes(call), this::isEntry);
            }
            case PARAM_CALLER: 
            case HEAP_PARAM_CALLER: {
                return this.getSuccNodes(call);
            }
        }
        Assertions.UNREACHABLE(call.getKind().toString());
        return null;
    }

    public Statement[] getEntriesForProcedure(PDG<? extends InstanceKey> procedure) {
        Statement[] normal = procedure.getParamCalleeStatements();
        Statement[] result = new Statement[normal.length + 1];
        result[0] = new MethodEntryStatement(procedure.getCallGraphNode());
        System.arraycopy(normal, 0, result, 1, normal.length);
        return result;
    }

    public Statement[] getExitsForProcedure(PDG<? extends InstanceKey> procedure) {
        Statement[] normal = procedure.getReturnStatements();
        Statement[] result = new Statement[normal.length + 1];
        result[0] = new MethodExitStatement(procedure.getCallGraphNode());
        System.arraycopy(normal, 0, result, 1, normal.length);
        return result;
    }

    @Override
    public Statement getLocalBlock(PDG<? extends InstanceKey> procedure, int i) {
        return procedure.getNode(i);
    }

    @Override
    public int getLocalBlockNumber(Statement n) {
        PDG<? extends InstanceKey> pdg = this.getProcOf(n);
        return pdg.getNumber(n);
    }

    @Override
    public Iterator<Statement> getNormalSuccessors(Statement call) {
        if (!this.backward) {
            return EmptyIterator.instance();
        }
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public int getNumberOfBlocks(PDG<? extends InstanceKey> procedure) {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public PDG<? extends InstanceKey> getProcOf(Statement n) {
        CGNode node = n.getNode();
        PDG<? extends InstanceKey> result = this.sdg.getPDG(node);
        if (result == null) {
            Assertions.UNREACHABLE("panic: " + n + ' ' + node);
        }
        return result;
    }

    @Override
    public Iterator<? extends Statement> getReturnSites(Statement call, PDG<? extends InstanceKey> callee) {
        switch (call.getKind()) {
            case PARAM_CALLER: {
                ParamCaller n = (ParamCaller)call;
                SSAAbstractInvokeInstruction st = n.getInstruction();
                PDG<? extends InstanceKey> pdg = this.getProcOf(call);
                return pdg.getCallerReturnStatements(st).iterator();
            }
            case HEAP_PARAM_CALLER: {
                HeapStatement.HeapParamCaller n = (HeapStatement.HeapParamCaller)call;
                SSAAbstractInvokeInstruction st = n.getCall();
                PDG<? extends InstanceKey> pdg = this.getProcOf(call);
                return pdg.getCallerReturnStatements(st).iterator();
            }
            case NORMAL: {
                NormalStatement n = (NormalStatement)call;
                SSAAbstractInvokeInstruction st = (SSAAbstractInvokeInstruction)n.getInstruction();
                PDG<? extends InstanceKey> pdg = this.getProcOf(call);
                return pdg.getCallerReturnStatements(st).iterator();
            }
        }
        Assertions.UNREACHABLE(call.getKind().toString());
        return null;
    }

    @Override
    public boolean isCall(Statement n) {
        switch (n.getKind()) {
            case EXC_RET_CALLER: 
            case NORMAL_RET_CALLER: 
            case HEAP_RET_CALLER: 
            case EXC_RET_CALLEE: 
            case HEAP_PARAM_CALLEE: 
            case NORMAL_RET_CALLEE: 
            case PARAM_CALLEE: 
            case PHI: 
            case HEAP_RET_CALLEE: 
            case METHOD_ENTRY: 
            case METHOD_EXIT: 
            case CATCH: 
            case PI: {
                return false;
            }
            case PARAM_CALLER: 
            case HEAP_PARAM_CALLER: {
                return true;
            }
            case NORMAL: {
                if (this.sdg.getCOptions().isIgnoreInterproc()) {
                    return false;
                }
                NormalStatement s2 = (NormalStatement)n;
                return s2.getInstruction() instanceof SSAAbstractInvokeInstruction;
            }
        }
        Assertions.UNREACHABLE((Object)((Object)n.getKind()) + " " + n.toString());
        return false;
    }

    @Override
    public boolean isEntry(Statement n) {
        switch (n.getKind()) {
            case HEAP_PARAM_CALLEE: 
            case PARAM_CALLEE: 
            case METHOD_ENTRY: {
                return true;
            }
            case EXC_RET_CALLER: 
            case NORMAL_RET_CALLER: 
            case HEAP_RET_CALLER: 
            case NORMAL: 
            case PARAM_CALLER: 
            case HEAP_PARAM_CALLER: 
            case EXC_RET_CALLEE: 
            case NORMAL_RET_CALLEE: 
            case PHI: 
            case HEAP_RET_CALLEE: 
            case CATCH: 
            case PI: {
                return false;
            }
        }
        Assertions.UNREACHABLE(n.toString());
        return false;
    }

    @Override
    public boolean isExit(Statement n) {
        switch (n.getKind()) {
            case EXC_RET_CALLER: 
            case NORMAL_RET_CALLER: 
            case HEAP_RET_CALLER: 
            case NORMAL: 
            case PARAM_CALLER: 
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: 
            case PARAM_CALLEE: 
            case PHI: 
            case METHOD_ENTRY: 
            case CATCH: 
            case PI: {
                return false;
            }
            case EXC_RET_CALLEE: 
            case NORMAL_RET_CALLEE: 
            case HEAP_RET_CALLEE: 
            case METHOD_EXIT: {
                return true;
            }
        }
        Assertions.UNREACHABLE(n.toString());
        return false;
    }

    @Override
    public boolean isReturn(Statement n) {
        switch (n.getKind()) {
            case EXC_RET_CALLER: 
            case NORMAL_RET_CALLER: 
            case HEAP_RET_CALLER: {
                return true;
            }
            case NORMAL: 
            case PARAM_CALLER: 
            case HEAP_PARAM_CALLER: 
            case EXC_RET_CALLEE: 
            case HEAP_PARAM_CALLEE: 
            case NORMAL_RET_CALLEE: 
            case PARAM_CALLEE: 
            case PHI: 
            case HEAP_RET_CALLEE: 
            case METHOD_ENTRY: 
            case CATCH: 
            case PI: {
                return false;
            }
        }
        Assertions.UNREACHABLE(n.getKind().toString());
        return false;
    }

    @Override
    public void removeNodeAndEdges(Statement N) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addNode(Statement n) {
        Assertions.UNREACHABLE();
    }

    @Override
    public boolean containsNode(Statement N) {
        return this.sdg.containsNode(N);
    }

    @Override
    public int getNumberOfNodes() {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.sdg.iterator();
    }

    @Override
    public Stream<Statement> stream() {
        return this.sdg.stream();
    }

    @Override
    public void removeNode(Statement n) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addEdge(Statement src, Statement dst) {
        Assertions.UNREACHABLE();
    }

    @Override
    public int getPredNodeCount(Statement N) {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public Iterator<Statement> getPredNodes(Statement N) {
        return this.sdg.getPredNodes(N);
    }

    @Override
    public int getSuccNodeCount(Statement N) {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public Iterator<Statement> getSuccNodes(Statement N) {
        return this.sdg.getSuccNodes(N);
    }

    @Override
    public boolean hasEdge(Statement src, Statement dst) {
        return this.sdg.hasEdge(src, dst);
    }

    @Override
    public void removeAllIncidentEdges(Statement node) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeEdge(Statement src, Statement dst) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeIncomingEdges(Statement node) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeOutgoingEdges(Statement node) {
        Assertions.UNREACHABLE();
    }

    @Override
    public int getMaxNumber() {
        return this.sdg.getMaxNumber();
    }

    @Override
    public Statement getNode(int number) {
        return (Statement)this.sdg.getNode(number);
    }

    @Override
    public int getNumber(Statement N) {
        return this.sdg.getNumber(N);
    }

    @Override
    public Iterator<Statement> iterateNodes(IntSet s2) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getPredNodeNumbers(Statement node) {
        return this.sdg.getPredNodeNumbers(node);
    }

    @Override
    public IntSet getSuccNodeNumbers(Statement node) {
        return this.sdg.getSuccNodeNumbers(node);
    }
}

