/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Collection;

public class SlicerUtil {
    private SlicerUtil() {
    }

    public static Statement findCallTo(CGNode n, String methodName) {
        IR ir = n.getIR();
        for (SSAInstruction s2 : Iterator2Iterable.make(ir.iterateAllInstructions())) {
            SSAAbstractInvokeInstruction call;
            if (!(s2 instanceof SSAAbstractInvokeInstruction) || !(call = (SSAAbstractInvokeInstruction)s2).getCallSite().getDeclaredTarget().getName().toString().equals(methodName)) continue;
            IntSet indices = ir.getCallInstructionIndices(call.getCallSite());
            Assertions.productionAssertion(indices.size() == 1, "expected 1 but got " + indices.size());
            return new NormalStatement(n, indices.intIterator().next());
        }
        Assertions.UNREACHABLE("failed to find call to " + methodName + " in " + n);
        return null;
    }

    public static Statement findFirstAllocation(CGNode n) {
        IR ir = n.getIR();
        for (int i = 0; i < ir.getInstructions().length; ++i) {
            SSAInstruction s2 = ir.getInstructions()[i];
            if (!(s2 instanceof SSANewInstruction)) continue;
            return new NormalStatement(n, i);
        }
        Assertions.UNREACHABLE("failed to find allocation in " + n);
        return null;
    }

    public static void dumpSlice(Collection<Statement> slice) {
        SlicerUtil.dumpSlice(slice, new PrintWriter(System.err));
    }

    public static void dumpSlice(Collection<Statement> slice, PrintWriter w) {
        w.println("SLICE:\n");
        int i = 1;
        for (Statement s2 : slice) {
            String line = i++ + "   " + s2;
            w.println(line);
            w.flush();
        }
    }

    public static void dumpSliceToFile(Collection<Statement> slice, String fileName) throws FileNotFoundException {
        File f = new File(fileName);
        FileOutputStream fo = new FileOutputStream(f);
        try (PrintWriter w = new PrintWriter(fo);){
            SlicerUtil.dumpSlice(slice, w);
        }
    }

    public static int countAllocations(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            NormalStatement ns;
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s2).getInstruction() instanceof SSANewInstruction)) continue;
            ++count;
        }
        return count;
    }

    public static int countApplicationAllocations(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            AnalysisScope scope;
            NormalStatement ns;
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s2).getInstruction() instanceof SSANewInstruction) || !(scope = s2.getNode().getClassHierarchy().getScope()).isApplicationLoader(s2.getNode().getMethod().getDeclaringClass().getClassLoader())) continue;
            ++count;
        }
        return count;
    }

    public static int countThrows(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            NormalStatement ns;
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s2).getInstruction() instanceof SSAAbstractThrowInstruction)) continue;
            ++count;
        }
        return count;
    }

    public static int countAloads(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            NormalStatement ns;
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s2).getInstruction() instanceof SSAArrayLoadInstruction)) continue;
            ++count;
        }
        return count;
    }

    public static int countNormals(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL)) continue;
            ++count;
        }
        return count;
    }

    public static int countApplicationNormals(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            AnalysisScope scope;
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL) || !(scope = s2.getNode().getClassHierarchy().getScope()).isApplicationLoader(s2.getNode().getMethod().getDeclaringClass().getClassLoader())) continue;
            ++count;
        }
        return count;
    }

    public static int countConditionals(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            NormalStatement ns;
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s2).getInstruction() instanceof SSAConditionalBranchInstruction)) continue;
            ++count;
        }
        return count;
    }

    public static int countInvokes(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            NormalStatement ns;
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s2).getInstruction() instanceof SSAAbstractInvokeInstruction)) continue;
            ++count;
        }
        return count;
    }

    public static int countPutfields(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            SSAPutInstruction p;
            NormalStatement ns;
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s2).getInstruction() instanceof SSAPutInstruction) || (p = (SSAPutInstruction)ns.getInstruction()).isStatic()) continue;
            ++count;
        }
        return count;
    }

    public static int countReturns(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            NormalStatement ns;
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s2).getInstruction() instanceof SSAReturnInstruction)) continue;
            ++count;
        }
        return count;
    }

    public static int countGetfields(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            SSAGetInstruction p;
            NormalStatement ns;
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s2).getInstruction() instanceof SSAGetInstruction) || (p = (SSAGetInstruction)ns.getInstruction()).isStatic()) continue;
            ++count;
        }
        return count;
    }

    public static int countPutstatics(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            SSAPutInstruction p;
            NormalStatement ns;
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s2).getInstruction() instanceof SSAPutInstruction) || !(p = (SSAPutInstruction)ns.getInstruction()).isStatic()) continue;
            ++count;
        }
        return count;
    }

    public static int countGetstatics(Collection<Statement> slice) {
        int count = 0;
        for (Statement s2 : slice) {
            SSAGetInstruction p;
            NormalStatement ns;
            if (!s2.getKind().equals((Object)Statement.Kind.NORMAL) || !((ns = (NormalStatement)s2).getInstruction() instanceof SSAGetInstruction) || !(p = (SSAGetInstruction)ns.getInstruction()).isStatic()) continue;
            ++count;
        }
        return count;
    }
}

