/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.strings.Atom;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class BypassSyntheticClassLoader
implements IClassLoader {
    private final ClassLoaderReference me;
    private final IClassLoader parent;
    private final IClassHierarchy cha;
    private final HashMap<TypeName, IClass> syntheticClasses = HashMapFactory.make();

    public BypassSyntheticClassLoader(ClassLoaderReference me, IClassLoader parent, SetOfClasses exclusions, IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("null cha");
        }
        this.me = me;
        this.cha = cha;
        this.parent = parent;
    }

    public String toString() {
        return this.me.getName().toString();
    }

    @Override
    public IClass lookupClass(TypeName className) {
        IClass pc = this.parent.lookupClass(className);
        if (pc == null) {
            IClass c = this.syntheticClasses.get(className);
            return c;
        }
        return pc;
    }

    public void registerClass(TypeName className, IClass theClass) {
        this.cha.addClass(theClass);
        this.syntheticClasses.put(className, theClass);
    }

    @Override
    public ClassLoaderReference getReference() {
        return this.me;
    }

    @Override
    public Iterator<IClass> iterateAllClasses() {
        return this.syntheticClasses.values().iterator();
    }

    @Override
    public int getNumberOfClasses() {
        return this.syntheticClasses.size();
    }

    @Override
    public Atom getName() {
        return this.me.getName();
    }

    @Override
    public Language getLanguage() {
        return this.parent.getLanguage();
    }

    @Override
    public int getNumberOfMethods() {
        return 0;
    }

    @Override
    public String getSourceFileName(IClass klass) {
        return null;
    }

    @Override
    public IClassLoader getParent() {
        return this.parent;
    }

    @Override
    public void init(List<Module> modules) throws IOException {
    }

    @Override
    public void removeAll(Collection<IClass> toRemove) {
        if (toRemove == null) {
            throw new IllegalArgumentException("toRemove is null");
        }
        for (IClass c : toRemove) {
            this.syntheticClasses.remove(c.getName());
        }
    }

    @Override
    public Reader getSource(IClass klass) {
        return null;
    }

    @Override
    public SSAInstructionFactory getInstructionFactory() {
        return this.getLanguage().instructionFactory();
    }

    @Override
    public Reader getSource(IMethod method, int offset) {
        return null;
    }

    @Override
    public String getSourceFileName(IMethod method, int offset) {
        return null;
    }
}

