/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MethodBypass {
    static final boolean DEBUG = false;
    private final Map<Object, MethodSummary> methodSummaries;
    private final Set<TypeReference> allocatable;
    private final IClassHierarchy cha;
    private final HashMap<MethodReference, SummarizedMethod> syntheticMethods = HashMapFactory.make();
    private final HashSet<MethodReference> considered = HashSetFactory.make();

    public MethodBypass(Map<Object, MethodSummary> methodSummaries, Set<TypeReference> allocatable, IClassHierarchy cha) {
        this.methodSummaries = methodSummaries;
        this.allocatable = allocatable;
        this.cha = cha;
    }

    private SyntheticMethod getBypass(MethodReference m3) {
        SyntheticMethod result = this.findOrCreateSyntheticMethod(m3);
        if (result != null) {
            return result;
        }
        m3 = this.resolveTarget(m3);
        return this.findOrCreateSyntheticMethod(m3);
    }

    private SyntheticMethod findOrCreateSyntheticMethod(MethodReference m3) {
        if (this.considered.contains(m3)) {
            return this.syntheticMethods.get(m3);
        }
        this.considered.add(m3);
        MethodSummary summ = this.findSummary(m3);
        if (summ != null) {
            TypeReference T = m3.getDeclaringClass();
            IClass c = this.cha.lookupClass(T);
            assert (c != null) : "null class for " + T;
            SummarizedMethod n = new SummarizedMethod(m3, summ, c);
            this.syntheticMethods.put(m3, n);
            return n;
        }
        return null;
    }

    private MethodSummary findSummary(MemberReference m3) {
        MethodSummary result = this.methodSummaries.get(m3);
        if (result != null) {
            return result;
        }
        TypeReference t = m3.getDeclaringClass();
        result = this.methodSummaries.get(t);
        if (result != null) {
            return result;
        }
        if (t.isArrayType()) {
            return null;
        }
        Atom p = MethodBypass.extractPackage(t);
        result = this.methodSummaries.get(p);
        if (result != null) {
            // empty if block
        }
        return result;
    }

    public SyntheticMethod getBypass(IMethod target) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        return this.getBypass(target.getReference());
    }

    private static Atom extractPackage(TypeReference type) {
        String s2 = type.getName().toString();
        int index = s2.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        s2 = s2.substring(0, index);
        return Atom.findOrCreateAsciiAtom(s2);
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    protected MethodReference resolveTarget(MethodReference target) {
        IMethod m3 = this.getClassHierarchy().resolveMethod(target);
        if (m3 != null) {
            target = m3.getReference();
        }
        return target;
    }

    public boolean isAllocatable(IClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        if (!klass.isAbstract() && !klass.isInterface()) {
            return true;
        }
        return this.allocatable.contains(klass.getReference());
    }
}

