/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.strings.Atom;
import java.util.Map;

public class SummarizedMethodWithNames
extends SummarizedMethod {
    private static final boolean DEBUG = false;
    private final MethodSummary summary;
    private final Map<Integer, Atom> localNames;

    public SummarizedMethodWithNames(MethodReference ref, MethodSummary summary, IClass declaringClass) {
        this(ref, summary, declaringClass, summary.getValueNames());
    }

    public SummarizedMethodWithNames(MethodReference ref, MethodSummary summary, IClass declaringClass, Map<Integer, Atom> localNames) throws NullPointerException {
        super(ref, summary, declaringClass);
        this.summary = summary;
        this.localNames = localNames;
    }

    public SummarizedMethodWithNames(MethodReference ref, VolatileMethodSummary summary, IClass declaringClass) throws NullPointerException {
        super(ref, summary.getMethodSummary(), declaringClass);
        this.summary = summary.getMethodSummary();
        this.localNames = summary.getLocalNames();
    }

    @Override
    public String getLocalVariableName(int bcIndex, int localNumber) {
        if (this.localNames.containsKey(localNumber)) {
            String name = this.localNames.get(localNumber).toString();
            return name;
        }
        return super.getLocalVariableName(bcIndex, localNumber);
    }

    @Override
    public boolean hasLocalVariableTable() {
        return true;
    }

    @Override
    public IR makeIR(Context context, SSAOptions options) {
        SSAInstruction[] instrs = this.getStatements(options);
        SyntheticIRWithNames ir = new SyntheticIRWithNames(this, Everywhere.EVERYWHERE, this.makeControlFlowGraph(instrs), instrs, options, this.summary.getConstants(), this.localNames);
        return ir;
    }

    public static class SyntheticIRWithNames
    extends SyntheticIR {
        private final IR.SSA2LocalMap localMap;

        public SyntheticIRWithNames(IMethod method, Context context, AbstractCFG<?, ?> cfg, SSAInstruction[] instructions, SSAOptions options, Map<Integer, ConstantValue> constants, Map<Integer, Atom> localNames) throws AssertionError {
            super(method, context, cfg, instructions, options, constants);
            this.localMap = new SyntheticSSA2LocalMap(localNames);
        }

        @Override
        public IR.SSA2LocalMap getLocalMap() {
            return this.localMap;
        }

        public static class SyntheticSSA2LocalMap
        implements IR.SSA2LocalMap {
            private final Map<Integer, Atom> localNames;

            public SyntheticSSA2LocalMap(Map<Integer, Atom> localNames) {
                this.localNames = localNames;
            }

            @Override
            public String[] getLocalNames(int index, int vn) {
                if (this.localNames != null && this.localNames.containsKey(vn)) {
                    return new String[]{this.localNames.get(vn).toString()};
                }
                return null;
            }
        }
    }
}

