/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAIndirectionData;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.debug.Assertions;
import java.util.Map;

public class SyntheticIR
extends IR {
    private static final boolean PARANOID = true;

    public SyntheticIR(IMethod method, Context context, AbstractCFG<?, ?> cfg, SSAInstruction[] instructions, SSAOptions options, Map<Integer, ConstantValue> constants) throws AssertionError {
        super(method, instructions, SyntheticIR.makeSymbolTable(method, instructions, constants, cfg), new SSACFG(method, cfg, instructions), options);
        SyntheticIR.repOK(instructions);
        this.setupLocationMap();
    }

    private static void repOK(SSAInstruction[] instructions) {
        for (SSAInstruction s2 : instructions) {
            if (s2 instanceof SSAPhiInstruction) {
                Assertions.UNREACHABLE();
            }
            if (!(s2 instanceof SSAPiInstruction)) continue;
            Assertions.UNREACHABLE();
        }
    }

    private static SymbolTable makeSymbolTable(IMethod method, SSAInstruction[] instructions, Map<Integer, ConstantValue> constants, AbstractCFG<?, ?> cfg) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        SymbolTable symbolTable = new SymbolTable(method.getNumberOfParameters());
        for (SSAInstruction s2 : instructions) {
            if (s2 == null) continue;
            SyntheticIR.updateForInstruction(constants, symbolTable, s2);
        }
        if (cfg instanceof InducedCFG) {
            InducedCFG icfg = (InducedCFG)cfg;
            for (SSAPhiInstruction phi : icfg.getAllPhiInstructions()) {
                SyntheticIR.updateForInstruction(constants, symbolTable, phi);
            }
        }
        return symbolTable;
    }

    private static void updateForInstruction(Map<Integer, ConstantValue> constants, SymbolTable symbolTable, SSAInstruction s2) {
        int j;
        for (j = 0; j < s2.getNumberOfDefs(); ++j) {
            symbolTable.ensureSymbol(s2.getDef(j));
        }
        for (j = 0; j < s2.getNumberOfUses(); ++j) {
            int vn = s2.getUse(j);
            symbolTable.ensureSymbol(vn);
            if (constants == null || !constants.containsKey(vn)) continue;
            symbolTable.setConstantValue(vn, constants.get(vn));
        }
    }

    @Override
    protected String instructionPosition(int instructionIndex) {
        return "";
    }

    @Override
    public IR.SSA2LocalMap getLocalMap() {
        return null;
    }

    protected SSAIndirectionData<SSAIndirectionData.Name> getIndirectionData() {
        return null;
    }
}

