/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.bench;

import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassReader;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;

public class InterfaceAnalyzer {
    static final HashMap<String, TypeStats> typeStats = new HashMap();
    static int methodUID = 0;

    public static void main(String[] args) throws Exception {
        OfflineInstrumenter instrumenter = new OfflineInstrumenter();
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(System.out));){
            ClassInstrumenter ci;
            args = instrumenter.parseStandardArgs(args);
            instrumenter.beginTraversal();
            while ((ci = instrumenter.nextClass()) != null) {
                InterfaceAnalyzer.doClass(ci.getReader());
            }
            instrumenter.close();
            w.write("Type\t# Total\t# Method\t# Public Method\t# Public Method as Foreign\n");
            for (Map.Entry<String, TypeStats> entry : typeStats.entrySet()) {
                TypeStats t = entry.getValue();
                w.write(entry.getKey() + '\t' + t.totalOccurrences + '\t' + t.methodOccurrences + '\t' + t.publicMethodOccurrences + '\t' + t.foreignPublicMethodOccurrences + '\n');
            }
        }
    }

    private static void doClass(ClassReader reader) throws Exception {
        if ((reader.getAccessFlags() & 0x200) != 0 && (reader.getAccessFlags() & 1) != 0) {
            String cType = Util.makeType(reader.getName());
            for (int m3 = 0; m3 < reader.getMethodCount(); ++m3) {
                int mUID;
                String sig = reader.getMethodType(m3);
                String[] params = Util.getParamsTypes(null, sig);
                int flags = reader.getMethodAccessFlags(m3);
                ++methodUID;
                for (String param : params) {
                    InterfaceAnalyzer.doType(flags, param, cType, mUID);
                }
                InterfaceAnalyzer.doType(flags, Util.getReturnType(sig), cType, mUID);
            }
        }
    }

    private static void doType(int flags, String type, String containerType, int mUID) {
        TypeStats t = typeStats.get(type);
        if (t == null) {
            t = new TypeStats();
            typeStats.put(type, t);
        }
        ++t.totalOccurrences;
        if (t.lastMUID != mUID) {
            ++t.methodOccurrences;
            if ((flags & 1) != 0) {
                ++t.publicMethodOccurrences;
                String elemType = type;
                while (Util.isArrayType(elemType)) {
                    elemType = elemType.substring(1);
                }
                if (!Util.isPrimitiveType(elemType) && !InterfaceAnalyzer.packagePart(elemType, 2).equals(InterfaceAnalyzer.packagePart(containerType, 2))) {
                    ++t.foreignPublicMethodOccurrences;
                }
            }
        }
        t.lastMUID = mUID;
    }

    private static String packagePart(String t, int count) {
        String c = Util.makeClass(t);
        int lastDot = -1;
        for (int i = 0; i < count; ++i) {
            int dot = c.indexOf(46, lastDot + 1);
            if (dot < 0) {
                return c;
            }
            lastDot = dot;
        }
        return c.substring(0, lastDot);
    }

    static final class TypeStats {
        int totalOccurrences;
        int methodOccurrences;
        int publicMethodOccurrences;
        int foreignPublicMethodOccurrences;
        int lastMUID;

        TypeStats() {
        }
    }
}

