/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.analysis;

import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchy;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyProvider;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class Analyzer {
    public static final String thisType = "THIS";
    public static final String topType = "TOP";
    protected final boolean isConstructor;
    protected final boolean isStatic;
    protected final String classType;
    protected final String signature;
    protected final IInstruction[] instructions;
    protected final ExceptionHandler[][] handlers;
    protected ClassHierarchyProvider hierarchy;
    protected int maxStack;
    protected int maxLocals;
    protected String[][] stacks;
    protected String[][] locals;
    protected int[] stackSizes;
    protected BitSet basicBlockStarts;
    protected int[][] backEdges;
    protected int[] instToBC;
    protected String[][] varTypes;
    protected static final String[] noStrings = new String[0];
    protected static final int[] noEdges = new int[0];

    public Analyzer(boolean isConstructor, boolean isStatic, String classType, String signature, IInstruction[] instructions, ExceptionHandler[][] handlers, int[] instToBC, String[][] vars) {
        if (instructions == null) {
            throw new IllegalArgumentException("null instructions");
        }
        if (handlers == null) {
            throw new IllegalArgumentException("null handlers");
        }
        for (IInstruction i : instructions) {
            if (i != null) continue;
            throw new IllegalArgumentException("null instruction is illegal");
        }
        this.classType = classType;
        this.isConstructor = isConstructor;
        this.isStatic = isStatic;
        this.signature = signature;
        this.instructions = instructions;
        this.handlers = handlers;
        this.instToBC = instToBC;
        this.varTypes = vars;
    }

    public final void setClassHierarchy(ClassHierarchyProvider h2) {
        this.hierarchy = h2;
    }

    private void addBackEdge(int from, int to) {
        int[] oldEdges = this.backEdges[from];
        if (oldEdges == null) {
            this.backEdges[from] = new int[]{to};
        } else if (oldEdges[oldEdges.length - 1] < 0) {
            int left = 1;
            int right = oldEdges.length - 1;
            while (true) {
                if (right - left < 2) {
                    if (oldEdges[left] < 0) break;
                    if (oldEdges[right] >= 0) {
                        throw new Error("Failed binary search");
                    }
                    left = right;
                    break;
                }
                int mid = (left + right) / 2;
                if (oldEdges[mid] < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            oldEdges[left] = to;
        } else {
            int[] newEdges = Arrays.copyOf(oldEdges, oldEdges.length * 2);
            newEdges[oldEdges.length] = to;
            for (int i = oldEdges.length + 1; i < newEdges.length; ++i) {
                newEdges[i] = -1;
            }
            this.backEdges[from] = newEdges;
        }
    }

    public final int[][] getBackEdges() {
        int i;
        if (this.backEdges != null) {
            return this.backEdges;
        }
        this.backEdges = new int[this.instructions.length][];
        for (i = 0; i < this.instructions.length; ++i) {
            ExceptionHandler[] hs;
            int[] targets;
            IInstruction instr = this.instructions[i];
            for (int target : targets = instr.getBranchTargets()) {
                this.addBackEdge(target, i);
            }
            for (ExceptionHandler element : hs = this.handlers[i]) {
                this.addBackEdge(element.getHandler(), i);
            }
        }
        for (i = 0; i < this.backEdges.length; ++i) {
            int[] back = this.backEdges[i];
            if (back == null) {
                this.backEdges[i] = noEdges;
                continue;
            }
            if (back[back.length - 1] >= 0) continue;
            int j = back.length;
            while (back[j - 1] < 0) {
                --j;
            }
            int[] newBack = new int[j];
            System.arraycopy(back, 0, newBack, 0, newBack.length);
            this.backEdges[i] = newBack;
        }
        return this.backEdges;
    }

    private String patchType(String t) {
        if (t == thisType) {
            return this.classType;
        }
        if (t != null && t.startsWith("#")) {
            return Analyzer.stripSharp(t);
        }
        return t;
    }

    public final boolean isSubtypeOf(String t1, String t2) {
        return ClassHierarchy.isSubtypeOf(this.hierarchy, this.patchType(t1), this.patchType(t2)) != 1;
    }

    private static boolean isPrimitive(String type) {
        return type != null && !type.startsWith("L") && !type.startsWith("[");
    }

    public final String findCommonSupertype(String t1, String t2) {
        if (String.valueOf(t1).equals(String.valueOf(t2))) {
            return t1;
        }
        if (String.valueOf(t1).equals("L;") || String.valueOf(t2).equals("L;")) {
            if (String.valueOf(t1).equals("L;")) {
                return t2;
            }
            return t1;
        }
        if (t1 == thisType || t2 == thisType || t1 == topType || t2 == topType) {
            return topType;
        }
        if (Analyzer.isPrimitive(t1) != Analyzer.isPrimitive(t2)) {
            return topType;
        }
        String x = ClassHierarchy.findCommonSupertype(this.hierarchy, this.patchType(t1), this.patchType(t2));
        return x;
    }

    public final BitSet getBasicBlockStarts() {
        if (this.basicBlockStarts != null) {
            return this.basicBlockStarts;
        }
        BitSet r = new BitSet(this.instructions.length);
        r.set(0);
        for (IInstruction iInstruction : this.instructions) {
            int[] targets;
            int[] nArray = targets = iInstruction.getBranchTargets();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int target = nArray[i];
                r.set(target);
            }
        }
        for (IInstruction iInstruction : this.handlers) {
            if (iInstruction == null) continue;
            for (IInstruction element : iInstruction) {
                r.set(((ExceptionHandler)((Object)element)).getHandler());
            }
        }
        this.basicBlockStarts = r;
        return r;
    }

    public final IInstruction[] getInstructions() {
        return this.instructions;
    }

    private void getReachableRecursive(int from, BitSet reachable, boolean followHandlers, BitSet mask) throws IllegalArgumentException {
        if (from < 0) {
            throw new IllegalArgumentException("from < 0");
        }
        while (true) {
            int[] targets;
            if (reachable.get(from) || mask != null && !mask.get(from)) {
                return;
            }
            reachable.set(from);
            IInstruction instr = this.instructions[from];
            for (int target : targets = instr.getBranchTargets()) {
                this.getReachableRecursive(target, reachable, followHandlers, mask);
            }
            if (followHandlers) {
                ExceptionHandler[] hs;
                for (ExceptionHandler element : hs = this.handlers[from]) {
                    this.getReachableRecursive(element.getHandler(), reachable, followHandlers, mask);
                }
            }
            if (!instr.isFallThrough()) break;
            ++from;
        }
    }

    public final BitSet getReachableFrom(int from) {
        return this.getReachableFrom(from, true, null);
    }

    public final void getReachableFromUpdate(int from, BitSet reachable, boolean followHandlers, BitSet mask) {
        if (reachable == null) {
            throw new IllegalArgumentException("reachable is null");
        }
        reachable.clear();
        this.getReachableRecursive(from, reachable, followHandlers, mask);
    }

    public final BitSet getReachableFrom(int from, boolean followHandlers, BitSet mask) {
        BitSet reachable = new BitSet();
        this.getReachableRecursive(from, reachable, followHandlers, mask);
        return reachable;
    }

    private void getReachingRecursive(int to, BitSet reaching, BitSet mask) {
        while (true) {
            int[] targets;
            if (reaching.get(to) || mask != null && !mask.get(to)) {
                return;
            }
            reaching.set(to);
            for (int target : targets = this.backEdges[to]) {
                this.getReachingRecursive(target, reaching, mask);
            }
            if (to <= 0 || !this.instructions[to - 1].isFallThrough()) break;
            --to;
        }
    }

    private void getReachingBase(int to, BitSet reaching, BitSet mask) {
        int[] targets;
        for (int target : targets = this.backEdges[to]) {
            this.getReachingRecursive(target, reaching, mask);
        }
        if (to > 0 && this.instructions[to - 1].isFallThrough()) {
            this.getReachingRecursive(to - 1, reaching, mask);
        }
    }

    public final void getReachingToUpdate(int to, BitSet reaching, BitSet mask) {
        if (reaching == null) {
            throw new IllegalArgumentException("reaching is null");
        }
        this.getBackEdges();
        reaching.clear();
        this.getReachingBase(to, reaching, mask);
    }

    final BitSet getReachingTo(int to, BitSet mask) {
        this.getBackEdges();
        BitSet reaching = new BitSet();
        this.getReachingBase(to, reaching, mask);
        return reaching;
    }

    final BitSet getReachingTo(int to) {
        return this.getReachingTo(to, null);
    }

    private void computeStackSizesAt(int[] stackSizes, int i, int size) throws FailureException {
        while (true) {
            ExceptionHandler[] hs;
            int[] targets;
            if (stackSizes[i] >= 0) {
                if (size != stackSizes[i]) {
                    throw new FailureException(i, "Stack size mismatch", null);
                }
                return;
            }
            stackSizes[i] = size;
            IInstruction instr = this.instructions[i];
            if (instr instanceof DupInstruction) {
                size += ((DupInstruction)instr).getSize();
            } else if (!(instr instanceof SwapInstruction)) {
                size -= instr.getPoppedCount();
                if (instr.getPushedWordSize() > 0) {
                    ++size;
                }
            }
            for (int target : targets = instr.getBranchTargets()) {
                this.computeStackSizesAt(stackSizes, target, size);
            }
            for (ExceptionHandler element : hs = this.handlers[i]) {
                this.computeStackSizesAt(stackSizes, element.getHandler(), 1);
            }
            if (!instr.isFallThrough()) {
                return;
            }
            ++i;
        }
    }

    private static String[] cutArray(String[] a, int len) {
        if (len == 0) {
            return noStrings;
        }
        String[] r = new String[len];
        System.arraycopy(a, 0, r, 0, len);
        return r;
    }

    private boolean mergeTypes(int i, String[] curStack, int curStackSize, String[] curLocals, int curLocalsSize, List<PathElement> path) throws FailureException {
        boolean a = this.mergeStackTypes(i, curStack, curStackSize, path);
        boolean b = this.mergeLocalTypes(i, curLocals, curLocalsSize);
        return a || b;
    }

    private static boolean longType(String type) {
        return "J".equals(type) || "D".equals(type);
    }

    private boolean mergeStackTypes(int i, String[] curStack, int curStackSize, List<PathElement> path) throws FailureException {
        boolean changed = false;
        if (this.stacks[i] == null) {
            this.stacks[i] = Analyzer.cutArray(curStack, curStackSize);
            changed = true;
        } else {
            String[] st = this.stacks[i];
            if (st.length != curStackSize) {
                throw new FailureException(i, "Stack size mismatch: " + st.length + ", " + curStackSize, path);
            }
            for (int j = 0; j < curStackSize; ++j) {
                String t = this.findCommonSupertype(st[j], curStack[j]);
                if (t == st[j]) continue;
                if (t == null) {
                    throw new FailureException(i, "Stack type mismatch at " + j + " (" + st[j] + " vs " + curStack[j] + ')', path);
                }
                st[j] = t;
                changed = true;
            }
        }
        return changed;
    }

    private boolean mergeLocalTypes(int i, String[] curLocals, int curLocalsSize) {
        boolean changed = false;
        if (this.locals[i] == null) {
            this.locals[i] = Analyzer.cutArray(curLocals, curLocalsSize);
            changed = true;
        } else {
            String[] ls = this.locals[i];
            int lj = 0;
            int cj = 0;
            while (lj < ls.length) {
                String t = this.findCommonSupertype(ls[lj], curLocals[cj]);
                if (t != ls[lj]) {
                    ls[lj] = t;
                    changed = true;
                }
                ++lj;
                ++cj;
            }
        }
        return changed;
    }

    public static String stripSharp(String type) {
        return type.substring(type.lastIndexOf(35) + 1);
    }

    private void computeTypes(int i, TypeVisitor visitor, BitSet makeTypesAt, List<PathElement> path) throws FailureException {
        boolean restart;
        final String[] curStack = new String[this.maxStack];
        final String[] curLocals = new String[this.maxLocals];
        block0: do {
            if (path != null) {
                path.add(new PathElement(i, this.stacks[i], this.locals[i]));
            }
            int curStackSize = this.stacks[i].length;
            System.arraycopy(this.stacks[i], 0, curStack, 0, curStackSize);
            final int[] curLocalsSize = new int[]{this.locals[i].length};
            System.arraycopy(this.locals[i], 0, curLocals, 0, curLocalsSize[0]);
            IInstruction.Visitor localsUpdate = new IInstruction.Visitor(){

                @Override
                public void visitInvoke(IInvokeInstruction instruction) {
                    if (instruction.getInvocationCode() == IInvokeInstruction.Dispatch.SPECIAL && instruction.getMethodName().equals("<init>")) {
                        int sz = Util.getParamsTypes(instruction.getClassType(), instruction.getMethodSignature()).length;
                        if (Analyzer.this.isConstructor && Analyzer.thisType.equals(curStack[sz - 1])) {
                            int i;
                            for (i = 0; i < curLocals.length; ++i) {
                                if (!Analyzer.thisType.equals(curLocals[i])) continue;
                                curLocals[i] = Analyzer.this.classType;
                            }
                            for (i = 0; i < curStack.length; ++i) {
                                if (!Analyzer.thisType.equals(curStack[i])) continue;
                                curStack[i] = Analyzer.this.classType;
                            }
                        }
                        if (curStack.length > sz && curStack[sz] != null && curStack[sz].startsWith("#")) {
                            curStack[sz] = Analyzer.stripSharp(curStack[sz]);
                        }
                    }
                }

                @Override
                public void visitLocalLoad(ILoadInstruction instruction) {
                    String t;
                    curStack[0] = t = curLocals[instruction.getVarIndex()];
                }

                @Override
                public void visitLocalStore(IStoreInstruction instruction) {
                    String t;
                    int index = instruction.getVarIndex();
                    curLocals[index] = t = curStack[0];
                    if (Analyzer.longType(t) && curLocals.length > index + 1) {
                        curLocals[index + 1] = null;
                    }
                    if (index >= curLocalsSize[0]) {
                        curLocalsSize[0] = index + (Analyzer.longType(t) && curLocals.length > index + 1 ? 2 : 1);
                    }
                }
            };
            restart = false;
            do {
                int[] targets;
                ExceptionHandler[] handler;
                IInstruction instr;
                int popped;
                if (curStackSize < (popped = (instr = this.instructions[i]).getPoppedCount())) {
                    throw new FailureException(i, "Stack underflow", path);
                }
                if (visitor != null) {
                    visitor.setState(i, path, curStack, curLocals);
                    instr.visit(visitor);
                    if (!visitor.shouldContinue()) {
                        return;
                    }
                }
                if (instr instanceof DupInstruction) {
                    DupInstruction d = (DupInstruction)instr;
                    int size = d.getSize();
                    System.arraycopy(curStack, popped, curStack, popped + size, curStackSize - popped);
                    System.arraycopy(curStack, 0, curStack, popped, size);
                    curStackSize += size;
                } else if (instr instanceof SwapInstruction) {
                    String s2 = curStack[0];
                    curStack[0] = curStack[1];
                    curStack[1] = s2;
                } else {
                    String pushed = instr.getPushedType(curStack);
                    if (instr instanceof NewInstruction && !pushed.startsWith("[")) {
                        pushed = "#" + this.instToBC[i] + '#' + pushed;
                    }
                    if (pushed != null) {
                        System.arraycopy(curStack, popped, curStack, 1, curStackSize - popped);
                        curStack[0] = Util.getStackType(pushed);
                        instr.visit(localsUpdate);
                        curStackSize -= popped - 1;
                    } else {
                        int local;
                        instr.visit(localsUpdate);
                        System.arraycopy(curStack, popped, curStack, 0, curStackSize - popped);
                        curStackSize -= popped;
                        if (this.varTypes != null && instr instanceof IStoreInstruction && "L;".equals(curLocals[local = ((IStoreInstruction)instr).getVarIndex()])) {
                            int[] nArray = new int[]{i, i + 1};
                            int n = nArray.length;
                            for (int j = 0; j < n; ++j) {
                                String declaredType;
                                int idx = nArray[j];
                                int bc = this.instToBC[idx];
                                if (bc == 667 && local == 16) {
                                    System.err.println("got here");
                                }
                                if (bc == -1 || this.varTypes == null || this.varTypes.length <= bc || this.varTypes[bc] == null || this.varTypes[bc].length <= local || this.varTypes[bc][local] == null) continue;
                                curLocals[local] = declaredType = this.varTypes[bc][local];
                            }
                        }
                    }
                }
                for (ExceptionHandler element : handler = this.handlers[i]) {
                    String[] catchStack;
                    int target = element.getHandler();
                    String cls = element.getCatchClass();
                    if (cls == null) {
                        cls = "Ljava/lang/Throwable;";
                    }
                    if (!this.mergeTypes(target, catchStack = new String[]{cls}, 1, curLocals, curLocalsSize[0], path)) continue;
                    this.computeTypes(target, visitor, makeTypesAt, path);
                }
                for (int target : targets = instr.getBranchTargets()) {
                    if (!this.mergeTypes(target, curStack, curStackSize, curLocals, curLocalsSize[0], path)) continue;
                    this.computeTypes(target, visitor, makeTypesAt, path);
                }
                if (!instr.isFallThrough()) continue block0;
            } while (!makeTypesAt.get(++i));
            if (this.mergeTypes(i, curStack, curStackSize, curLocals, curLocalsSize[0], path)) {
                restart = true;
                continue;
            }
            if (path != null) {
                path.remove(path.size() - 1);
            }
            return;
        } while (restart);
        if (path != null) {
            path.remove(path.size() - 1);
        }
    }

    public int[] getStackSizes() throws FailureException {
        if (this.stackSizes != null) {
            return this.stackSizes;
        }
        this.stackSizes = new int[this.instructions.length];
        Arrays.fill(this.stackSizes, -1);
        this.computeStackSizesAt(this.stackSizes, 0, 0);
        return this.stackSizes;
    }

    private void computeMaxLocals() {
        this.maxLocals = this.locals[0].length;
        for (IInstruction instr : this.instructions) {
            if (instr instanceof LoadInstruction) {
                this.maxLocals = Math.max(this.maxLocals, ((LoadInstruction)instr).getVarIndex() + 1);
                continue;
            }
            if (!(instr instanceof StoreInstruction)) continue;
            this.maxLocals = Math.max(this.maxLocals, ((StoreInstruction)instr).getVarIndex() + 1);
        }
    }

    protected final void initTypeInfo() throws FailureException {
        this.stacks = new String[this.instructions.length][];
        this.locals = new String[this.instructions.length][];
        String thisType = this.isConstructor ? thisType : this.classType;
        this.stacks[0] = noStrings;
        this.locals[0] = Util.getParamsTypesInLocals(this.isStatic ? null : thisType, this.signature);
        if (this.isConstructor) {
            for (int i = 0; i < this.locals[0].length; ++i) {
                if (!this.classType.equals(this.locals[0][i])) continue;
                this.locals[0][i] = thisType;
            }
        }
        int[] stackSizes = this.getStackSizes();
        this.maxStack = 0;
        for (int stackSize : stackSizes) {
            this.maxStack = Math.max(this.maxStack, stackSize);
        }
        this.computeMaxLocals();
    }

    public final void computeTypes(TypeVisitor v, BitSet makeTypesAt, boolean wantPath) throws FailureException {
        this.initTypeInfo();
        this.computeTypes(0, v, makeTypesAt, wantPath ? new ArrayList() : null);
    }

    public final String[][] getLocalTypes() {
        return this.locals;
    }

    public final String[][] getStackTypes() {
        return this.stacks;
    }

    protected Analyzer(MethodData info) {
        this(info.getName().equals("<init>"), info.getIsStatic(), info.getClassType(), info.getSignature(), info.getInstructions(), info.getHandlers(), info.getInstructionsToBytecodes(), null);
    }

    protected Analyzer(MethodData info, int[] instToBC, String[][] vars) {
        this(info.getName().equals("<init>"), info.getIsStatic(), info.getClassType(), info.getSignature(), info.getInstructions(), info.getHandlers(), instToBC, vars);
    }

    public static Analyzer createAnalyzer(MethodData info) {
        if (info == null) {
            throw new IllegalArgumentException("info is null");
        }
        return new Analyzer(info);
    }

    public static abstract class TypeVisitor
    extends IInstruction.Visitor {
        public abstract void setState(int var1, List<PathElement> var2, String[] var3, String[] var4);

        public abstract boolean shouldContinue();
    }

    public static final class PathElement {
        final int index;
        final String[] stack;
        final String[] locals;

        PathElement(int index, String[] stack, String[] locals) {
            this.stack = (String[])stack.clone();
            this.locals = (String[])locals.clone();
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String[] getLocals() {
            return this.locals;
        }

        public String[] getStack() {
            return this.stack;
        }
    }

    public static final class FailureException
    extends Exception {
        private static final long serialVersionUID = -7663520961403117526L;
        private final int offset;
        private final String reason;
        private List<PathElement> path;

        FailureException(int offset, String reason, List<PathElement> path) {
            super(reason + " at offset " + offset);
            this.offset = offset;
            this.reason = reason;
            this.path = path;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getReason() {
            return this.reason;
        }

        public List<PathElement> getPath() {
            return this.path;
        }

        void setPath(List<PathElement> path) {
            this.path = path;
        }

        public void printPath(Writer w) throws IOException {
            if (this.path != null) {
                for (PathElement elem : this.path) {
                    int j;
                    String[] stack = elem.stack;
                    String[] locals = elem.locals;
                    w.write("Offset " + elem.index + ": [");
                    for (j = 0; j < stack.length; ++j) {
                        if (j > 0) {
                            w.write(",");
                        }
                        w.write(stack[j]);
                    }
                    w.write("], [");
                    for (j = 0; j < locals.length; ++j) {
                        if (j > 0) {
                            w.write(",");
                        }
                        w.write(locals[j] == null ? "?" : locals[j]);
                    }
                    w.write("]\n");
                }
            }
        }
    }
}

