/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.analysis;

import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstanceofInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.ITypeTestInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.InvokeDynamicInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Analyzer;
import java.util.BitSet;
import java.util.List;

public final class Verifier
extends Analyzer {
    public Verifier(boolean isConstructor, boolean isStatic, String classType, String signature, IInstruction[] instructions, ExceptionHandler[][] handlers, int[] instToBC, String[][] vars) {
        super(isConstructor, isStatic, classType, signature, instructions, handlers, instToBC, vars);
    }

    public Verifier(MethodData info) throws NullPointerException {
        super(info);
    }

    public Verifier(MethodData info, int[] instToBC, String[][] vars) throws NullPointerException {
        super(info, instToBC, vars);
    }

    public void verify() throws Analyzer.FailureException {
        VerifyVisitor v = new VerifyVisitor();
        this.computeTypes(v, this.getBasicBlockStarts(), true);
        v.checkError();
    }

    public void verifyCollectAll() throws Analyzer.FailureException {
        VerifyVisitor v = new VerifyVisitor();
        BitSet all = new BitSet(this.instructions.length);
        all.set(0, this.instructions.length);
        this.computeTypes(v, all, true);
        v.checkError();
    }

    public void computeTypes() throws Analyzer.FailureException {
        this.computeTypes(null, this.getBasicBlockStarts(), false);
    }

    final class VerifyVisitor
    extends Analyzer.TypeVisitor {
        private int curIndex;
        private List<Analyzer.PathElement> curPath;
        private Analyzer.FailureException ex;
        private String[] curStack;
        private String[] curLocals;

        VerifyVisitor() {
        }

        @Override
        public void setState(int offset, List<Analyzer.PathElement> path, String[] curStack, String[] curLocals) {
            this.curIndex = offset;
            this.curPath = path;
            this.curStack = curStack;
            this.curLocals = curLocals;
        }

        @Override
        public boolean shouldContinue() {
            return this.ex == null;
        }

        void checkError() throws Analyzer.FailureException {
            if (this.ex != null) {
                throw this.ex;
            }
        }

        private void checkStackSubtype(int i, String t) {
            if (!Verifier.this.isSubtypeOf(this.curStack[i], Util.getStackType(t))) {
                this.ex = new Analyzer.FailureException(this.curIndex, "Expected type " + t + " at stack " + i + ", got " + this.curStack[i], this.curPath);
            }
        }

        private void checkArrayStackSubtype(int i, String t) {
            if (!t.equals("B") || !"[Z".equals(this.curStack[i])) {
                this.checkStackSubtype(i, Util.makeArray(t));
            }
        }

        @Override
        public void visitConstant(ConstantInstruction instruction) {
            instruction.getValue();
        }

        @Override
        public void visitGoto(GotoInstruction instruction) {
        }

        @Override
        public void visitLocalLoad(ILoadInstruction instruction) {
            String t = this.curLocals[instruction.getVarIndex()];
            if (t == null) {
                this.ex = new Analyzer.FailureException(this.curIndex, "Local variable " + instruction.getVarIndex() + " is not defined", this.curPath);
            }
            if (!Verifier.this.isSubtypeOf(t, instruction.getType())) {
                this.ex = new Analyzer.FailureException(this.curIndex, "Expected type " + instruction.getType() + " for local " + instruction.getVarIndex() + ", got " + t, this.curPath);
            }
        }

        @Override
        public void visitLocalStore(IStoreInstruction instruction) {
            this.checkStackSubtype(0, instruction.getType());
        }

        @Override
        public void visitArrayLoad(IArrayLoadInstruction instruction) {
            this.checkStackSubtype(0, "I");
            this.checkArrayStackSubtype(1, instruction.getType());
        }

        @Override
        public void visitArrayStore(IArrayStoreInstruction instruction) {
            this.checkStackSubtype(0, instruction.getType());
            this.checkStackSubtype(1, "I");
            this.checkArrayStackSubtype(2, instruction.getType());
        }

        @Override
        public void visitPop(PopInstruction instruction) {
        }

        @Override
        public void visitDup(DupInstruction instruction) {
        }

        @Override
        public void visitBinaryOp(IBinaryOpInstruction instruction) {
            this.checkStackSubtype(0, instruction.getType());
            this.checkStackSubtype(1, instruction.getType());
        }

        @Override
        public void visitUnaryOp(IUnaryOpInstruction instruction) {
            this.checkStackSubtype(0, instruction.getType());
        }

        @Override
        public void visitShift(IShiftInstruction instruction) {
            this.checkStackSubtype(0, "I");
            this.checkStackSubtype(1, instruction.getType());
        }

        @Override
        public void visitConversion(IConversionInstruction instruction) {
            this.checkStackSubtype(0, instruction.getFromType());
        }

        @Override
        public void visitComparison(IComparisonInstruction instruction) {
            this.checkStackSubtype(0, instruction.getType());
            this.checkStackSubtype(1, instruction.getType());
        }

        @Override
        public void visitConditionalBranch(IConditionalBranchInstruction instruction) {
            this.checkStackSubtype(0, instruction.getType());
            this.checkStackSubtype(1, instruction.getType());
        }

        @Override
        public void visitSwitch(SwitchInstruction instruction) {
            this.checkStackSubtype(0, "I");
        }

        @Override
        public void visitReturn(ReturnInstruction instruction) {
            if (instruction.getType() != "V") {
                this.checkStackSubtype(0, instruction.getType());
                this.checkStackSubtype(0, Util.getReturnType(Verifier.this.signature));
            }
        }

        @Override
        public void visitGet(IGetInstruction instruction) {
            String classType = instruction.getClassType();
            if (!instruction.isStatic()) {
                this.checkStackSubtype(0, classType);
            }
        }

        @Override
        public void visitPut(IPutInstruction instruction) {
            String classType = instruction.getClassType();
            String type = instruction.getFieldType();
            this.checkStackSubtype(0, type);
            if (!instruction.isStatic()) {
                this.checkStackSubtype(1, classType);
            }
        }

        @Override
        public void visitInvoke(IInvokeInstruction instruction) {
            if (instruction instanceof InvokeDynamicInstruction) {
                return;
            }
            String classType = instruction.getClassType();
            String signature = instruction.getMethodSignature();
            String thisClass = instruction.getInvocationCode() == IInvokeInstruction.Dispatch.STATIC ? null : classType;
            String[] params = Util.getParamsTypes(thisClass, signature);
            for (int i = 0; i < params.length; ++i) {
                this.checkStackSubtype(i, params[params.length - 1 - i]);
            }
        }

        @Override
        public void visitNew(NewInstruction instruction) {
            for (int i = 0; i < instruction.getArrayBoundsCount(); ++i) {
                this.checkStackSubtype(i, "I");
            }
            instruction.getType();
        }

        @Override
        public void visitArrayLength(ArrayLengthInstruction instruction) {
            if (!this.curStack[0].equals("L;") && !Util.isArrayType(this.curStack[0])) {
                this.ex = new Analyzer.FailureException(this.curIndex, "Expected array type at stack 0, got " + this.curStack[0], this.curPath);
            }
        }

        @Override
        public void visitThrow(ThrowInstruction instruction) {
            this.checkStackSubtype(0, "Ljava/lang/Throwable;");
        }

        @Override
        public void visitMonitor(MonitorInstruction instruction) {
            this.checkStackSubtype(0, "Ljava/lang/Object;");
        }

        @Override
        public void visitCheckCast(ITypeTestInstruction instruction) {
            this.checkStackSubtype(0, "Ljava/lang/Object;");
            instruction.getTypes();
        }

        @Override
        public void visitInstanceof(IInstanceofInstruction instruction) {
            this.checkStackSubtype(0, "Ljava/lang/Object;");
            instruction.getType();
        }
    }
}

