/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT;

import com.ibm.wala.shrikeBT.Compiler;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import java.util.Random;

public final class CTCompiler
extends Compiler {
    private final ClassWriter cw;
    private final Random random = new Random();

    private CTCompiler(ClassWriter cw, MethodData md) {
        super(md);
        this.cw = cw;
    }

    @Override
    protected int allocateConstantPoolInteger(int v) {
        return this.cw.addCPInt(v);
    }

    @Override
    protected int allocateConstantPoolFloat(float v) {
        return this.cw.addCPFloat(v);
    }

    @Override
    protected int allocateConstantPoolLong(long v) {
        return this.cw.addCPLong(v);
    }

    @Override
    protected int allocateConstantPoolDouble(double v) {
        return this.cw.addCPDouble(v);
    }

    @Override
    protected int allocateConstantPoolString(String v) {
        return this.cw.addCPString(v);
    }

    @Override
    protected int allocateConstantPoolClassType(String c) {
        return this.cw.addCPClass(CTCompiler.convertTypeToClass(c));
    }

    @Override
    protected int allocateConstantPoolMethodType(String c) {
        return this.cw.addCPMethodType(c);
    }

    @Override
    protected int allocateConstantPoolMethodHandle(ConstantPoolParser.ReferenceToken c) {
        return this.cw.addCPMethodHandle(c);
    }

    @Override
    protected int allocateConstantPoolInvokeDynamic(BootstrapMethodsReader.BootstrapMethod b, String name, String type) {
        return this.cw.addCPInvokeDynamic(b, name, type);
    }

    public static String convertTypeToClass(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (s2.length() > 0 && s2.charAt(0) == 'L') {
            return s2.substring(1, s2.length() - 1);
        }
        return s2;
    }

    public static CTCompiler make(ClassWriter cw, MethodData md) {
        if (md == null) {
            throw new IllegalArgumentException("md is null");
        }
        return new CTCompiler(cw, md);
    }

    @Override
    protected int allocateConstantPoolField(String c, String name, String type) {
        return this.cw.addCPFieldRef(CTCompiler.convertTypeToClass(c), name, type);
    }

    @Override
    protected int allocateConstantPoolMethod(String c, String name, String sig) {
        return this.cw.addCPMethodRef(CTCompiler.convertTypeToClass(c), name, sig);
    }

    @Override
    protected int allocateConstantPoolInterfaceMethod(String c, String name, String sig) {
        return this.cw.addCPInterfaceMethodRef(CTCompiler.convertTypeToClass(c), name, sig);
    }

    @Override
    protected String createHelperMethod(boolean isStatic, String sig) {
        long r = Math.abs(this.random.nextLong());
        String name = "_helper_" + r;
        return name;
    }
}

