/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.tools;

import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MethodEditor;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.info.LocalAllocator;
import java.util.Arrays;
import java.util.BitSet;

@Deprecated
public final class MethodOptimizer {
    private final MethodData data;
    private IInstruction[] instructions;
    private ExceptionHandler[][] handlers;
    private final MethodEditor editor;
    private int[][] uniqueStackDefLocations;
    private int[] uniqueStackUseLocations;
    private int[] stackSizes;
    private int[][] backEdges;
    static final int[] noEdges = new int[0];

    public MethodOptimizer(MethodData d, MethodEditor e) {
        if (d == null) {
            throw new IllegalArgumentException("null d");
        }
        this.data = d;
        this.editor = e;
    }

    public MethodOptimizer(MethodData d) {
        this(d, new MethodEditor(d));
    }

    public int findUniqueStackDef(int instr, int stack) throws UnoptimizableCodeException {
        this.instructions = this.editor.getInstructions();
        this.handlers = this.editor.getHandlers();
        this.checkConsistentStackSizes();
        this.buildBackEdges();
        this.buildStackDefMap();
        return this.uniqueStackDefLocations[instr][stack];
    }

    public void optimize() throws UnoptimizableCodeException {
        boolean changed;
        do {
            this.instructions = this.editor.getInstructions();
            this.handlers = this.editor.getHandlers();
            this.checkConsistentStackSizes();
            this.buildBackEdges();
            this.editor.beginPass();
            this.buildStackDefMap();
            this.pushBackLocalStores();
            this.forwardDups();
            changed = this.editor.applyPatches();
            this.editor.endPass();
        } while (changed);
    }

    private void buildBackEdges() {
        ExceptionHandler[] exceptionHandlerArray;
        Object[] hs;
        int n;
        int[] targets;
        int i;
        int[] backEdgeCount = new int[this.instructions.length];
        for (i = 0; i < this.instructions.length; ++i) {
            int target;
            int[] nArray = targets = this.instructions[i].getBranchTargets();
            int n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                int n3 = target = nArray[n];
                backEdgeCount[n3] = backEdgeCount[n3] + 1;
            }
            exceptionHandlerArray = hs = this.handlers[i];
            n = exceptionHandlerArray.length;
            for (target = 0; target < n; ++target) {
                ExceptionHandler h2 = exceptionHandlerArray[target];
                int n4 = h2.getHandler();
                backEdgeCount[n4] = backEdgeCount[n4] + 1;
            }
        }
        this.backEdges = new int[this.instructions.length][];
        for (i = 0; i < this.backEdges.length; ++i) {
            this.backEdges[i] = backEdgeCount[i] > 0 ? new int[backEdgeCount[i]] : noEdges;
        }
        Arrays.fill(backEdgeCount, 0);
        for (i = 0; i < this.instructions.length; ++i) {
            targets = this.instructions[i].getBranchTargets();
            hs = targets;
            int n5 = hs.length;
            for (n = 0; n < n5; ++n) {
                ExceptionHandler target2;
                ExceptionHandler target = target2 = hs[n];
                this.backEdges[target][backEdgeCount[target]] = i;
                ExceptionHandler exceptionHandler = target;
                backEdgeCount[exceptionHandler] = backEdgeCount[exceptionHandler] + 1;
            }
            exceptionHandlerArray = hs = this.handlers[i];
            n = exceptionHandlerArray.length;
            for (int j = 0; j < n; ++j) {
                ExceptionHandler element = exceptionHandlerArray[j];
                int target = element.getHandler();
                this.backEdges[target][backEdgeCount[target]] = i;
                int n6 = target;
                backEdgeCount[n6] = backEdgeCount[n6] + 1;
            }
        }
    }

    private int checkConsistentStackSizes() throws UnoptimizableCodeException {
        this.stackSizes = new int[this.instructions.length];
        Arrays.fill(this.stackSizes, -1);
        this.checkStackSizesAt(0, 0);
        int result = 0;
        for (int stackSize : this.stackSizes) {
            result = Math.max(result, stackSize);
        }
        return result;
    }

    private void checkStackSizesAt(int instruction, int stackSize) throws UnoptimizableCodeException {
        while (true) {
            ExceptionHandler[] hs;
            int[] targets;
            if (instruction < 0 || instruction >= this.instructions.length) {
                throw new UnoptimizableCodeException("Code exits in an illegal way");
            }
            if (this.stackSizes[instruction] != -1) {
                if (this.stackSizes[instruction] != stackSize) {
                    throw new UnoptimizableCodeException("Mismatched stack sizes at " + instruction + ": " + stackSize + " and " + this.stackSizes[instruction]);
                }
                return;
            }
            this.stackSizes[instruction] = stackSize;
            IInstruction instr = this.instructions[instruction];
            if ((stackSize -= instr.getPoppedCount()) < 0) {
                throw new UnoptimizableCodeException("Stack underflow at " + instruction);
            }
            if (instr instanceof DupInstruction) {
                DupInstruction d = (DupInstruction)instr;
                stackSize += d.getSize() + d.getPoppedCount();
            } else if (instr.getPushedType(null) != null) {
                ++stackSize;
            }
            for (int target : targets = instr.getBranchTargets()) {
                this.checkStackSizesAt(target, stackSize);
            }
            for (ExceptionHandler element : hs = this.handlers[instruction]) {
                this.checkStackSizesAt(element.getHandler(), 1);
            }
            if (!instr.isFallThrough()) {
                return;
            }
            ++instruction;
        }
    }

    private static boolean instructionKillsVar(IInstruction instr, int v) {
        if (instr instanceof StoreInstruction) {
            StoreInstruction st = (StoreInstruction)instr;
            return st.getVarIndex() == v || Util.getWordSize(st.getType()) == 2 && st.getVarIndex() + 1 == v;
        }
        return false;
    }

    private void forwardDups() {
        for (int i = 0; i < this.instructions.length; ++i) {
            IInstruction instr = this.instructions[i];
            if (!(instr instanceof DupInstruction) || ((DupInstruction)instr).getDelta() != 0 || this.uniqueStackDefLocations[i][0] < 0 || !(this.instructions[this.uniqueStackDefLocations[i][0]] instanceof LoadInstruction)) continue;
            int source = this.uniqueStackDefLocations[i][0];
            final LoadInstruction li = (LoadInstruction)this.instructions[source];
            for (int j = 0; j < this.instructions.length; ++j) {
                int[] locs = this.uniqueStackDefLocations[j];
                if (locs[0] != i) continue;
                BitSet path = this.getInstructionsOnPath(source, j);
                boolean killed = false;
                int v = li.getVarIndex();
                int k = 0;
                while (j < this.instructions.length && !killed) {
                    if (path.get(k) && MethodOptimizer.instructionKillsVar(this.instructions[k], v)) {
                        killed = true;
                    }
                    ++k;
                }
                if (killed) continue;
                this.editor.insertBefore(j, new MethodEditor.Patch(){

                    @Override
                    public void emitTo(MethodEditor.Output w) {
                        w.emit(PopInstruction.make(1));
                        w.emit(li);
                    }
                });
            }
        }
    }

    private void pushBackLocalStores() {
        for (int i = 0; i < this.instructions.length; ++i) {
            IInstruction instr = this.instructions[i];
            if (!(instr instanceof StoreInstruction) || this.uniqueStackDefLocations[i][0] < 0 || this.uniqueStackDefLocations[i][0] == i - 1 || this.uniqueStackUseLocations[this.uniqueStackDefLocations[i][0]] != i) continue;
            final StoreInstruction s2 = (StoreInstruction)instr;
            int source = this.uniqueStackDefLocations[i][0];
            BitSet path = this.getInstructionsOnPath(source, i);
            boolean killed = false;
            int v = s2.getVarIndex();
            for (int j = 0; j < this.instructions.length && !killed; ++j) {
                if (!path.get(j) || !MethodOptimizer.instructionKillsVar(this.instructions[j], v)) continue;
                killed = true;
            }
            if (killed) {
                final String type = s2.getType();
                final int newVar = LocalAllocator.allocate(this.data, type);
                this.editor.insertAfter(source, new MethodEditor.Patch(){

                    @Override
                    public void emitTo(MethodEditor.Output w) {
                        w.emit(StoreInstruction.make(type, newVar));
                    }
                });
                this.editor.insertBefore(i, new MethodEditor.Patch(){

                    @Override
                    public void emitTo(MethodEditor.Output w) {
                        w.emit(LoadInstruction.make(type, newVar));
                    }
                });
                continue;
            }
            this.editor.replaceWith(i, new MethodEditor.Patch(){

                @Override
                public void emitTo(MethodEditor.Output w) {
                }
            });
            this.editor.insertAfter(source, new MethodEditor.Patch(){

                @Override
                public void emitTo(MethodEditor.Output w) {
                    w.emit(s2);
                }
            });
        }
    }

    private void buildStackDefMap() {
        int j;
        int i;
        int[][] abstractStacks = new int[this.instructions.length][];
        for (i = 0; i < this.instructions.length; ++i) {
            abstractStacks[i] = new int[this.stackSizes[i]];
            Arrays.fill(abstractStacks[i], -2);
        }
        for (i = 0; i < this.instructions.length; ++i) {
            if (this.instructions[i] instanceof DupInstruction) {
                DupInstruction d = (DupInstruction)this.instructions[i];
                for (j = 0; j < 2 * d.getSize() + d.getDelta(); ++j) {
                    this.followStackDef(abstractStacks, i, i + 1, this.stackSizes[i + 1] - 1 - j);
                }
                continue;
            }
            if (this.instructions[i].getPushedType(null) == null) continue;
            this.followStackDef(abstractStacks, i, i + 1, this.stackSizes[i + 1] - 1);
        }
        this.uniqueStackDefLocations = new int[this.instructions.length][];
        for (i = 0; i < this.instructions.length; ++i) {
            this.uniqueStackDefLocations[i] = new int[this.instructions[i].getPoppedCount()];
            int popped = this.instructions[i].getPoppedCount();
            System.arraycopy(abstractStacks[i], this.stackSizes[i] - popped, this.uniqueStackDefLocations[i], 0, popped);
        }
        this.uniqueStackUseLocations = new int[this.instructions.length];
        Arrays.fill(this.uniqueStackUseLocations, -2);
        for (i = 0; i < this.instructions.length; ++i) {
            abstractStacks[i] = new int[this.stackSizes[i]];
            Arrays.fill(abstractStacks[i], -2);
        }
        for (i = 0; i < this.instructions.length; ++i) {
            int count = this.instructions[i].getPoppedCount();
            if (count == 1) {
                this.followStackUse(abstractStacks, i, i, this.stackSizes[i] - 1);
                continue;
            }
            if (count <= 1) continue;
            for (j = 0; j < count; ++j) {
                this.followStackUse(abstractStacks, -1, i, this.stackSizes[i] - 1 - j);
            }
        }
        for (i = 0; i < this.instructions.length; ++i) {
            if (this.instructions[i].getPushedType(null) == null) continue;
            this.uniqueStackUseLocations[i] = abstractStacks[i + 1][this.stackSizes[i + 1] - 1];
        }
    }

    private void followStackDef(int[][] abstractDefStacks, int def, int instruction, int stackPointer) {
        int[] stack;
        while (stackPointer < (stack = abstractDefStacks[instruction]).length) {
            ExceptionHandler[] hs;
            int[] targets;
            if (stack[stackPointer] == -2) {
                stack[stackPointer] = def;
            } else {
                if (stack[stackPointer] == def) {
                    return;
                }
                if (stack[stackPointer] == -1) {
                    return;
                }
                stack[stackPointer] = -1;
                def = -1;
            }
            for (int target : targets = this.instructions[instruction].getBranchTargets()) {
                this.followStackDef(abstractDefStacks, def, target, stackPointer);
            }
            for (ExceptionHandler element : hs = this.handlers[instruction]) {
                this.followStackDef(abstractDefStacks, -1, element.getHandler(), 0);
            }
            if (!this.instructions[instruction].isFallThrough()) {
                return;
            }
            ++instruction;
        }
        return;
    }

    private void followStackUse(int[][] abstractUseStacks, int use, int instruction, int stackPointer) {
        int[] stack;
        while (stackPointer < (stack = abstractUseStacks[instruction]).length) {
            int[] back;
            if (stack[stackPointer] == -2) {
                stack[stackPointer] = use;
            } else {
                if (stack[stackPointer] == use || stack[stackPointer] == -1) {
                    return;
                }
                stack[stackPointer] = -1;
                use = -1;
            }
            for (int element : back = this.backEdges[instruction]) {
                this.followStackUse(abstractUseStacks, use, element, stackPointer);
            }
            if (instruction == 0 || !this.instructions[instruction - 1].isFallThrough()) {
                return;
            }
            --instruction;
        }
        return;
    }

    private BitSet getInstructionsOnPath(int from, int to) {
        BitSet reachable = new BitSet();
        this.getReachableInstructions(reachable, from, to);
        BitSet reaching = new BitSet();
        this.getReachingInstructions(reaching, from, to);
        reachable.and(reaching);
        return reachable;
    }

    private void getReachableInstructions(BitSet bits, int from, int to) {
        while (from != to) {
            int[] targets;
            bits.set(from);
            for (int target : targets = this.instructions[from].getBranchTargets()) {
                this.getReachableInstructions(bits, target, to);
            }
            if (!this.instructions[from].isFallThrough()) {
                return;
            }
            ++from;
        }
        return;
    }

    private void getReachingInstructions(BitSet bits, int from, int to) {
        while (to != from) {
            int[] targets;
            bits.set(to);
            for (int target : targets = this.backEdges[to]) {
                this.getReachingInstructions(bits, from, target);
            }
            if (to == 0 || !this.instructions[to - 1].isFallThrough()) {
                return;
            }
            --to;
        }
        return;
    }

    public static class UnoptimizableCodeException
    extends Exception {
        private static final long serialVersionUID = 2543170335674010642L;

        public UnoptimizableCodeException(String s2) {
            super(s2);
        }
    }
}

