/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.tools;

import com.ibm.wala.shrikeBT.analysis.ClassHierarchyProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public abstract class OfflineInstrumenterBase {
    private int inputIndex;
    private final HashSet<String> entryNames = new HashSet();
    private final ArrayList<Input> inputs = new ArrayList();
    private final BitSet ignoringInputs = new BitSet();
    private File outputFile;
    private boolean passUnmodifiedClasses = false;
    private JarOutputStream outputJar;
    private JarFile cachedJar;
    private File cachedJarFile;
    private ManifestBuilder manifestBuilder;
    protected ClassHierarchyProvider cha;
    private static byte[] cachedBuf;

    public void setManifestBuilder(ManifestBuilder mb) {
        this.manifestBuilder = mb;
    }

    private JarFile openCachedJar(File file) throws IOException {
        if (this.cachedJarFile == null || !this.cachedJarFile.equals(file)) {
            if (this.cachedJar != null) {
                this.cachedJar.close();
            }
            this.cachedJarFile = file;
            this.cachedJar = new JarFile(file, false);
        }
        return this.cachedJar;
    }

    protected OfflineInstrumenterBase() {
    }

    public void setClassHierarchyProvider(ClassHierarchyProvider cha) {
        this.cha = cha;
    }

    public final void setOutputJar(File f) {
        this.outputFile = f;
    }

    public final void setPassUnmodifiedClasses(boolean pass) {
        this.passUnmodifiedClasses = pass;
    }

    public final void addInputJar(File f) throws IOException {
        try (JarFile jf = new JarFile(f, false);){
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                this.inputs.add(new JarInput(f, name));
            }
        }
    }

    public final void addInputJarEntry(File f, String name) {
        this.inputs.add(new JarInput(f, name));
    }

    public final void addInputClass(File baseDirectory, File f) {
        this.inputs.add(new ClassInput(baseDirectory, f));
    }

    public final void addInputDirectory(File baseDirectory, File d) throws IOException, IllegalArgumentException {
        if (d == null) {
            throw new IllegalArgumentException("d is null");
        }
        File[] fs = d.listFiles(f -> f.isDirectory() || f.getName().endsWith(".class"));
        if (fs == null) {
            throw new IllegalArgumentException("bad directory " + d.getAbsolutePath());
        }
        for (File f2 : fs) {
            if (f2.isDirectory()) {
                this.addInputDirectory(baseDirectory, f2);
                continue;
            }
            this.addInputClass(baseDirectory, f2);
        }
    }

    public final boolean addInputElement(File baseDirectory, String a) throws IOException {
        if (a == null) {
            throw new IllegalArgumentException("a is null");
        }
        try {
            int poundIndex = a.indexOf(35);
            if (poundIndex > 0) {
                this.addInputJarEntry(new File(a.substring(0, poundIndex)), a.substring(poundIndex + 1));
                return true;
            }
            File f = new File(a);
            if (f.isDirectory()) {
                this.addInputDirectory(baseDirectory, f);
                return true;
            }
            if (f.exists()) {
                if (a.endsWith(".class")) {
                    this.addInputClass(baseDirectory, f);
                    return true;
                }
                if (a.endsWith(".jar") || a.endsWith(".zip")) {
                    this.addInputJar(new File(a));
                    return true;
                }
            }
        }
        catch (IOException ex) {
            throw new IOException("Error reading input element '" + a + "': " + ex.getMessage());
        }
        return false;
    }

    public final String[] parseStandardArgs(String[] args) throws IllegalArgumentException, IOException {
        if (args == null) {
            throw new IllegalArgumentException("args == null");
        }
        ArrayList<String> leftover = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a == null) {
                throw new IllegalArgumentException("args[" + i + "] is null");
            }
            if (a.equals("-o") && i + 1 < args.length) {
                this.setOutputJar(new File(args[i + 1]));
                ++i;
                continue;
            }
            if (!a.startsWith("-")) {
                if (this.addInputElement(new File(a), a)) {
                    continue;
                }
            } else if (a.startsWith("--")) {
                leftover.addAll(Arrays.asList(args).subList(i, args.length));
                break;
            }
            leftover.add(a);
        }
        String[] r = new String[leftover.size()];
        leftover.toArray(r);
        return r;
    }

    public final int getNumInputClasses() {
        return this.inputs.size();
    }

    public final void beginTraversal() {
        this.inputIndex = 0;
    }

    protected abstract Object makeClassFromStream(String var1, BufferedInputStream var2) throws IOException;

    protected abstract String getClassName(Object var1);

    protected abstract void writeClassTo(Object var1, Object var2, OutputStream var3) throws IOException;

    protected final Object internalNextClass() throws IOException {
        Input in;
        do {
            if (this.inputIndex >= this.inputs.size()) {
                return null;
            }
            in = this.inputs.get(this.inputIndex);
            ++this.inputIndex;
        } while (this.ignoringInputs.get(this.inputIndex - 1) || !in.isClass());
        try (BufferedInputStream s2 = new BufferedInputStream(in.open());){
            Object r = this.makeClassFromStream(in.getInputName(), s2);
            String name = this.getClassName(r);
            in.setClassName(name);
            Object object = r;
            return object;
        }
    }

    private static String toEntryName(String className) {
        return className.replace('.', '/') + ".class";
    }

    public final String getLastClassResourceName() {
        if (this.inputIndex < 1) {
            return null;
        }
        Input in = this.inputs.get(this.inputIndex - 1);
        return in.toString();
    }

    public final File getOutputFile() {
        return this.outputFile;
    }

    protected final boolean internalOutputModifiedClass(Object cf, String name, Object mods) throws IOException {
        this.makeOutputJar();
        if (this.entryNames.contains(name)) {
            return false;
        }
        this.putNextEntry(new ZipEntry(name));
        BufferedOutputStream s2 = new BufferedOutputStream(this.outputJar);
        this.writeClassTo(cf, mods, s2);
        s2.flush();
        this.outputJar.closeEntry();
        return true;
    }

    public final void setJARComment(String comment) throws IOException, IllegalStateException {
        this.makeOutputJar();
        this.outputJar.setComment(comment);
    }

    final void makeOutputJar() throws IOException, IllegalStateException {
        if (this.outputJar == null) {
            if (this.outputFile == null) {
                throw new IllegalStateException("Output file was not set");
            }
            FileOutputStream out = new FileOutputStream(this.outputFile);
            this.outputJar = new JarOutputStream(out);
        }
    }

    public final void setIgnore() throws IllegalArgumentException {
        if (this.inputIndex == 0) {
            throw new IllegalArgumentException("Must get a class before ignoring it");
        }
        this.ignoringInputs.set(this.inputIndex - 1);
    }

    private static synchronized byte[] makeBuf() {
        if (cachedBuf != null) {
            byte[] r = cachedBuf;
            cachedBuf = null;
            return r;
        }
        return new byte[60000];
    }

    private static synchronized void releaseBuf(byte[] buf) {
        cachedBuf = buf;
    }

    public static void copyStream(InputStream in, OutputStream out) throws IllegalArgumentException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("in == null");
        }
        byte[] buf = OfflineInstrumenterBase.makeBuf();
        try {
            while (true) {
                int read;
                if ((read = in.read(buf)) < 0) {
                    return;
                }
                out.write(buf, 0, read);
            }
        }
        finally {
            OfflineInstrumenterBase.releaseBuf(buf);
        }
    }

    public final OutputStream addOutputJarEntry(ZipEntry ze) throws IOException, IllegalStateException {
        if (this.outputJar == null) {
            throw new IllegalStateException("output jar is null");
        }
        this.putNextEntry(ze);
        return this.outputJar;
    }

    public final void endOutputJarEntry() throws IOException, IllegalStateException {
        if (this.outputJar == null) {
            throw new IllegalStateException("output jar is null");
        }
        this.outputJar.closeEntry();
    }

    public final void writeUnmodifiedClasses() throws IOException, IllegalStateException {
        this.passUnmodifiedClasses = false;
        this.makeOutputJar();
        for (Input in : this.inputs) {
            Throwable throwable;
            Object s2;
            if (!in.isClass()) {
                if (in instanceof JarInput) {
                    JarInput jin = (JarInput)in;
                    ZipEntry entry = jin.getEntry();
                    s2 = jin.open();
                    throwable = null;
                    try {
                        ZipEntry newEntry = new ZipEntry(entry.getName());
                        newEntry.setComment(entry.getComment());
                        newEntry.setExtra(entry.getExtra());
                        newEntry.setTime(entry.getTime());
                        this.putNextEntry(newEntry);
                        OfflineInstrumenterBase.copyStream((InputStream)s2, this.outputJar);
                        this.outputJar.closeEntry();
                        continue;
                    }
                    catch (Throwable newEntry) {
                        throwable = newEntry;
                        throw newEntry;
                    }
                    finally {
                        if (s2 == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)s2).close();
                            }
                            catch (Throwable newEntry) {
                                throwable.addSuppressed(newEntry);
                            }
                            continue;
                        }
                        ((InputStream)s2).close();
                        continue;
                    }
                }
                throw new Error("Unknown non-class input: " + in);
            }
            String name = in.getClassName();
            if (name == null) {
                BufferedInputStream s3 = new BufferedInputStream(in.open(), 65536);
                s2 = null;
                try {
                    Object cl = this.makeClassFromStream(in.getInputName(), s3);
                    String entryName = OfflineInstrumenterBase.toEntryName(this.getClassName(cl));
                    if (this.entryNames.contains(entryName)) continue;
                    this.putNextEntry(new ZipEntry(entryName));
                    BufferedOutputStream clOut = new BufferedOutputStream(this.outputJar);
                    this.writeClassTo(cl, null, clOut);
                    clOut.flush();
                    this.outputJar.closeEntry();
                    continue;
                }
                catch (Throwable throwable2) {
                    s2 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s3 == null) continue;
                    if (s2 != null) {
                        try {
                            s3.close();
                        }
                        catch (Throwable throwable3) {
                            ((Throwable)s2).addSuppressed(throwable3);
                        }
                        continue;
                    }
                    s3.close();
                    continue;
                }
            }
            String entryName = OfflineInstrumenterBase.toEntryName(name);
            if (this.entryNames.contains(entryName)) continue;
            s2 = new BufferedInputStream(in.open());
            throwable = null;
            try {
                this.putNextEntry(new ZipEntry(entryName));
                BufferedOutputStream clOut = new BufferedOutputStream(this.outputJar);
                OfflineInstrumenterBase.copyStream((InputStream)s2, clOut);
                clOut.flush();
                this.outputJar.closeEntry();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (s2 == null) continue;
                if (throwable != null) {
                    try {
                        ((BufferedInputStream)s2).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                ((BufferedInputStream)s2).close();
            }
        }
    }

    public final void close() throws IOException, IllegalStateException {
        if (this.passUnmodifiedClasses) {
            this.writeUnmodifiedClasses();
        }
        if (this.outputJar != null) {
            this.outputJar.close();
        }
        if (this.cachedJar != null) {
            this.cachedJar.close();
        }
    }

    private void putNextEntry(ZipEntry newEntry) throws IOException, IllegalStateException {
        if (this.outputJar == null) {
            throw new IllegalStateException();
        }
        this.outputJar.putNextEntry(newEntry);
        this.entryNames.add(newEntry.getName());
        if (this.manifestBuilder != null) {
            this.manifestBuilder.addEntry(newEntry);
        }
    }

    static final class ClassInput
    extends Input {
        private final File file;
        private final File baseDirectory;

        public ClassInput(File baseDirectory, File f) {
            this.file = f;
            this.baseDirectory = baseDirectory;
        }

        @Override
        public InputStream open() throws IOException {
            return new FileInputStream(this.file);
        }

        public String toString() {
            return this.file.getPath();
        }

        @Override
        public String getInputName() {
            int base = this.baseDirectory.getPath().length() + 1;
            return this.file.getPath().substring(base);
        }
    }

    final class JarInput
    extends Input {
        private final File file;
        private final String name;

        public JarInput(File f, String je) {
            this.file = f;
            this.name = je;
        }

        @Override
        public InputStream open() throws IOException {
            JarFile cachedJar = OfflineInstrumenterBase.this.openCachedJar(this.file);
            return cachedJar.getInputStream(cachedJar.getEntry(this.name));
        }

        public String toString() {
            return this.file.getPath() + '#' + this.name;
        }

        @Override
        public boolean isClass() {
            return this.name.endsWith(".class");
        }

        @Override
        public String getInputName() {
            return this.name;
        }

        public ZipEntry getEntry() throws IOException {
            JarFile cachedJar = OfflineInstrumenterBase.this.openCachedJar(this.file);
            return cachedJar.getEntry(this.name);
        }
    }

    static abstract class Input {
        private String className;

        Input() {
        }

        public final void setClassName(String c) {
            this.className = c.intern();
        }

        public final String getClassName() {
            return this.className;
        }

        public abstract String getInputName();

        public abstract InputStream open() throws IOException;

        public boolean isClass() {
            return true;
        }
    }

    public static interface ManifestBuilder {
        public void addEntry(ZipEntry var1);
    }
}

