/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AttributeReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public final class CodeReader
extends AttributeReader {
    private final int codeLen;
    private final int exnTableLen;

    public CodeReader(ClassReader.AttrIterator iter) throws InvalidClassFileException {
        super(iter, "Code");
        int offset = this.attr + 6;
        this.checkSize(offset, 8);
        this.codeLen = this.cr.getInt(offset + 4);
        this.checkSize(offset += 8, this.codeLen + 2);
        this.exnTableLen = this.cr.getUShort(offset += this.codeLen);
        this.checkSize(offset += 2, this.exnTableLen * 8 + 2);
        int attrCount = this.cr.getUShort(offset += this.exnTableLen * 8);
        offset += 2;
        for (int i = 0; i < attrCount; ++i) {
            this.checkSize(offset, 6);
            int len = this.cr.getInt(offset + 2);
            this.checkSize(offset += 6, len);
            offset += len;
        }
    }

    public int getMaxStack() {
        return this.cr.getUShort(this.attr + 6);
    }

    public int getMaxLocals() {
        return this.cr.getUShort(this.attr + 8);
    }

    public int getBytecodeLength() {
        return this.codeLen;
    }

    public byte[] getBytecode() {
        byte[] r = new byte[this.codeLen];
        System.arraycopy(this.cr.getBytes(), this.attr + 14, r, 0, r.length);
        return r;
    }

    public int[] getRawHandlers() {
        int[] r = new int[this.exnTableLen * 4];
        int offset = this.attr + 14 + this.codeLen + 2;
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.cr.getUShort(offset);
            offset += 2;
        }
        return r;
    }

    public void initAttributeIterator(ClassReader.AttrIterator iter) {
        if (iter == null) {
            throw new IllegalArgumentException("iter is null");
        }
        iter.init(this.cr, this.attr + 14 + this.codeLen + 2 + this.exnTableLen * 8);
    }
}

