/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;

public final class CodeWriter
extends ClassWriter.Element {
    private final int attrID;
    private int maxLocals = -1;
    private int maxStack = -1;
    private byte[] code;
    private int[] exnHandlers;
    private ClassWriter.Element[] attributes;

    public CodeWriter(ClassWriter w) {
        if (w == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = w.addCPUtf8("Code");
    }

    private void verify() {
        if (this.maxStack < 0) {
            throw new IllegalArgumentException("maxStack not set");
        }
        if (this.maxLocals < 0) {
            throw new IllegalArgumentException("maxLocals not set");
        }
        if (this.code == null) {
            throw new IllegalArgumentException("No bytecodes set");
        }
    }

    public int getCodeLength() throws IllegalStateException {
        if (this.code == null) {
            throw new IllegalStateException("code not initialized");
        }
        return this.code.length;
    }

    @Override
    public int getSize() throws IllegalArgumentException {
        this.verify();
        int size = 14 + this.code.length + 2 + (this.exnHandlers == null ? 0 : this.exnHandlers.length) * 2 + 2;
        if (this.attributes != null) {
            for (ClassWriter.Element attribute : this.attributes) {
                size += attribute.getSize();
            }
        }
        return size;
    }

    @Override
    public int copyInto(byte[] buf, int offset) throws IllegalArgumentException {
        this.verify();
        int start = offset;
        ClassWriter.setUShort(buf, offset, this.attrID);
        ClassWriter.setUShort(buf, offset + 6, this.maxStack);
        ClassWriter.setUShort(buf, offset + 8, this.maxLocals);
        ClassWriter.setInt(buf, offset + 10, this.code.length);
        System.arraycopy(this.code, 0, buf, offset += 14, this.code.length);
        ClassWriter.setUShort(buf, offset += this.code.length, (this.exnHandlers == null ? 0 : this.exnHandlers.length) / 4);
        offset += 2;
        if (this.exnHandlers != null) {
            for (int exnHandler : this.exnHandlers) {
                ClassWriter.setUShort(buf, offset, exnHandler);
                offset += 2;
            }
        }
        ClassWriter.setUShort(buf, offset, this.attributes == null ? 0 : this.attributes.length);
        offset += 2;
        if (this.attributes != null) {
            for (ClassWriter.Element attribute : this.attributes) {
                offset = attribute.copyInto(buf, offset);
            }
        }
        ClassWriter.setInt(buf, start + 2, offset - start - 6);
        return offset;
    }

    public void setCode(byte[] code) throws IllegalArgumentException {
        if (code == null) {
            throw new IllegalArgumentException("code is null");
        }
        if (code.length > 65535) {
            throw new IllegalArgumentException("Code array is too long: " + code.length);
        }
        if (code.length == 0) {
            throw new IllegalArgumentException("Code array is empty");
        }
        this.code = code;
    }

    public void setRawHandlers(int[] exnHandlers) {
        if (exnHandlers == null) {
            throw new IllegalArgumentException("exnHandlers is null");
        }
        if (exnHandlers.length % 4 != 0) {
            throw new IllegalArgumentException("Exception handlers array has bad length: " + exnHandlers.length);
        }
        if (exnHandlers.length / 4 > 65535) {
            throw new IllegalArgumentException("Too many exception handlers: " + exnHandlers.length / 4);
        }
        for (int i = 0; i < exnHandlers.length; ++i) {
            int v = exnHandlers[i];
            if (v >= 0 && v <= 65535) continue;
            throw new IllegalArgumentException("Invalid exception handler entry at " + i);
        }
        this.exnHandlers = exnHandlers;
    }

    public void setMaxLocals(int maxLocals) {
        this.maxLocals = maxLocals;
    }

    public void setMaxStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public void setAttributes(ClassWriter.Element[] attributes) {
        this.attributes = attributes;
    }
}

