/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.ExceptionsReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.SignatureReader;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TypeAnnotationsReader
extends AnnotationsReader {
    private final ExceptionsReader exceptionReader;
    private final CodeReader codeReader;
    private final SignatureReader signatureReader;
    private final TypeAnnotationLocation location;
    public static final List<Pair<TypePathKind, Integer>> TYPEPATH_EMPTY = Collections.emptyList();

    protected TypeAnnotationsReader(ClassReader.AttrIterator iter, String label, ExceptionsReader exceptionReader, CodeReader codeReader, SignatureReader signatureReader, TypeAnnotationLocation location) throws InvalidClassFileException {
        super(iter, label);
        this.exceptionReader = exceptionReader;
        this.codeReader = codeReader;
        this.signatureReader = signatureReader;
        this.location = location;
    }

    public static TypeAnnotationsReader getTypeAnnotationReaderAtClassfile(ClassReader.AttrIterator iter, String label, SignatureReader signatureReader) throws InvalidClassFileException {
        return new TypeAnnotationsReader(iter, label, null, null, signatureReader, TypeAnnotationLocation.ClassFile);
    }

    public static TypeAnnotationsReader getTypeAnnotationReaderAtMethodInfo(ClassReader.AttrIterator iter, String label, ExceptionsReader exceptionReader, SignatureReader signatureReader) throws InvalidClassFileException {
        return new TypeAnnotationsReader(iter, label, exceptionReader, null, signatureReader, TypeAnnotationLocation.method_info);
    }

    public static TypeAnnotationsReader getTypeAnnotationReaderAtFieldInfo(ClassReader.AttrIterator iter, String label) throws InvalidClassFileException {
        return new TypeAnnotationsReader(iter, label, null, null, null, TypeAnnotationLocation.field_info);
    }

    public static TypeAnnotationsReader getTypeAnnotationReaderAtCode(ClassReader.AttrIterator iter, String label, CodeReader codeReader) throws InvalidClassFileException {
        return new TypeAnnotationsReader(iter, label, null, codeReader, null, TypeAnnotationLocation.Code);
    }

    public TypeAnnotationAttribute[] getAllTypeAnnotations() throws InvalidClassFileException {
        TypeAnnotationAttribute[] result = new TypeAnnotationAttribute[this.getAnnotationCount()];
        int offset = this.beginOffset + 8;
        for (int i = 0; i < result.length; ++i) {
            Pair<TypeAnnotationAttribute, Integer> attributeAndSize = this.getTypeAttributeAndSize(offset);
            result[i] = (TypeAnnotationAttribute)attributeAndSize.fst;
            offset += ((Integer)attributeAndSize.snd).intValue();
        }
        return result;
    }

    private Pair<TypeAnnotationAttribute, Integer> getTypeAttributeAndSize(int begin) throws InvalidClassFileException {
        TargetType target_type = TargetType.fromValue(this.cr.getUnsignedByte(begin));
        if (target_type == null) {
            throw new InvalidClassFileException(begin, "Unknown target_type: " + this.cr.getUnsignedByte(begin));
        }
        if (target_type.location != this.location) {
            throw new InvalidClassFileException(begin, (Object)((Object)target_type) + " annotation found while reading " + (Object)((Object)this.location) + " annotations. Only valid at " + (Object)((Object)target_type.location));
        }
        Pair<TypeAnnotationTarget, Integer> pAnnotationTargetAndSize = this.getTypeAnnotationTargetAndSize(begin + 1, target_type.target_info);
        int type_path_offset = begin + 1 + (Integer)pAnnotationTargetAndSize.snd;
        this.checkSize(type_path_offset, 1);
        int path_length = this.cr.getUnsignedByte(type_path_offset);
        this.checkSize(type_path_offset + 1, 2 * path_length);
        ArrayList<Pair<TypePathKind, Integer>> type_path = new ArrayList<Pair<TypePathKind, Integer>>(path_length);
        int current_path_element = type_path_offset + 1;
        for (int i = 0; i < path_length; ++i) {
            TypePathKind type_path_kind = TypePathKind.fromValue(this.cr.getUnsignedByte(current_path_element));
            int type_argument_index = this.cr.getUnsignedByte(current_path_element + 1);
            type_path.add(i, Pair.make(type_path_kind, type_argument_index));
            current_path_element += 2;
        }
        int annotation_begin = type_path_offset + 1 + 2 * path_length;
        Pair<AnnotationsReader.AnnotationAttribute, Integer> pAttributeAndSize = this.getAttributeAndSize(annotation_begin);
        return Pair.make(new TypeAnnotationAttribute((TypeAnnotationTarget)pAnnotationTargetAndSize.fst, (AnnotationsReader.AnnotationAttribute)pAttributeAndSize.fst, type_path, target_type), 1 + (Integer)pAnnotationTargetAndSize.snd + 1 + 2 * path_length + (Integer)pAttributeAndSize.snd);
    }

    private Pair<TypeAnnotationTarget, Integer> getTypeAnnotationTargetAndSize(int begin, TargetInfo target_info) throws InvalidClassFileException {
        switch (target_info) {
            case type_parameter_target: {
                this.checkSize(begin, 1);
                return Pair.make(new TypeParameterTarget(this.cr.getUnsignedByte(begin)), 1);
            }
            case supertype_target: {
                this.checkSize(begin, 2);
                int interfaceIndex = this.cr.getUShort(begin);
                String superType = interfaceIndex == 65535 ? this.cr.getSuperName() : this.cr.getInterfaceName(interfaceIndex);
                return Pair.make(new SuperTypeTarget(superType), 2);
            }
            case type_parameter_bound_target: {
                this.checkSize(begin, 2);
                return Pair.make(new TypeParameterBoundTarget(this.cr.getUnsignedByte(begin), this.cr.getUnsignedByte(begin + 1), this.signatureReader.getSignature()), 2);
            }
            case empty_target: {
                return Pair.make(new EmptyTarget(), 0);
            }
            case formal_parameter_target: {
                this.checkSize(begin, 1);
                return Pair.make(new FormalParameterTarget(this.cr.getUnsignedByte(begin)), 1);
            }
            case throws_target: {
                assert (this.exceptionReader != null);
                this.checkSize(begin, 2);
                int throwsIndex = this.cr.getUShort(begin);
                return Pair.make(new ThrowsTarget(this.exceptionReader.getClasses()[throwsIndex]), 2);
            }
            case localvar_target: {
                this.checkSize(begin, 2);
                int table_length = this.cr.getUShort(begin);
                int offset = begin + 2;
                this.checkSize(offset, 6 * table_length);
                int[] start_pc = new int[table_length];
                int[] length = new int[table_length];
                int[] index = new int[table_length];
                for (int i = 0; i < table_length; ++i) {
                    start_pc[i] = this.cr.getUShort(offset + 6 * i);
                    length[i] = this.cr.getUShort(offset + 2 + 6 * i);
                    index[i] = this.cr.getUShort(offset + 4 + 6 * i);
                }
                return Pair.make(new LocalVarTarget(start_pc, length, index), 2 + 6 * table_length);
            }
            case catch_target: {
                assert (this.codeReader != null);
                this.checkSize(begin, 2);
                int exception_table_index = this.cr.getUShort(begin);
                int[] rawHandler = new int[4];
                System.arraycopy(this.codeReader.getRawHandlers(), exception_table_index * 4, rawHandler, 0, 4);
                String catchType = rawHandler[3] == 0 ? CatchTarget.ALL_EXCEPTIONS : this.cr.getCP().getCPClass(rawHandler[3]);
                return Pair.make(new CatchTarget(rawHandler, catchType), 2);
            }
            case offset_target: {
                this.checkSize(begin, 2);
                int offset = this.cr.getUShort(begin);
                return Pair.make(new OffsetTarget(offset), 2);
            }
            case type_argument_target: {
                this.checkSize(begin, 3);
                int offset = this.cr.getUShort(begin);
                int type_argument_index = this.cr.getUnsignedByte(begin);
                return Pair.make(new TypeArgumentTarget(offset, type_argument_index), 3);
            }
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public static boolean isKnownAnnotation(String name) {
        for (AnnotationType t : AnnotationType.values()) {
            if (!t.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static TypeAnnotationsReader getReaderForAnnotationAtClassfile(AnnotationType type, ClassReader.AttrIterator iter, SignatureReader signatureReader) {
        return TypeAnnotationsReader.advanceIter(type, iter, () -> TypeAnnotationsReader.getTypeAnnotationReaderAtClassfile(iter, type.toString(), signatureReader));
    }

    public static TypeAnnotationsReader getReaderForAnnotationAtMethodInfo(AnnotationType type, ClassReader.AttrIterator iter, ExceptionsReader exceptionReader, SignatureReader signatureReader) {
        return TypeAnnotationsReader.advanceIter(type, iter, () -> TypeAnnotationsReader.getTypeAnnotationReaderAtMethodInfo(iter, type.toString(), exceptionReader, signatureReader));
    }

    public static TypeAnnotationsReader getReaderForAnnotationAtFieldInfo(AnnotationType type, ClassReader.AttrIterator iter) {
        return TypeAnnotationsReader.advanceIter(type, iter, () -> TypeAnnotationsReader.getTypeAnnotationReaderAtFieldInfo(iter, type.toString()));
    }

    public static TypeAnnotationsReader getReaderForAnnotationAtCode(AnnotationType type, ClassReader.AttrIterator iter, CodeReader codereader) {
        return TypeAnnotationsReader.advanceIter(type, iter, () -> TypeAnnotationsReader.getTypeAnnotationReaderAtCode(iter, type.toString(), codereader));
    }

    private static TypeAnnotationsReader advanceIter(AnnotationType type, ClassReader.AttrIterator iter, Action newReader) {
        String attrName = type.toString();
        try {
            while (iter.isValid()) {
                if (iter.getName().equals(attrName)) {
                    return newReader.apply();
                }
                iter.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return null;
    }

    private static interface Action {
        public TypeAnnotationsReader apply() throws InvalidClassFileException;
    }

    public static class TypeAnnotationAttribute {
        public final TypeAnnotationTarget annotationTarget;
        public final AnnotationsReader.AnnotationAttribute annotationAttribute;
        public final List<Pair<TypePathKind, Integer>> typePath;
        public final TargetType targetType;

        public TypeAnnotationAttribute(TypeAnnotationTarget annotationTarget, AnnotationsReader.AnnotationAttribute annotationAttribute, List<Pair<TypePathKind, Integer>> typePath, TargetType targetType) {
            this.annotationTarget = annotationTarget;
            this.annotationAttribute = annotationAttribute;
            this.typePath = Collections.unmodifiableList(typePath);
            this.targetType = targetType;
        }
    }

    public static enum TypePathKind {
        DEEPER_IN_ARRAY(0),
        DEEPER_IN_NESTED(1),
        WILDCARD_BOUND(2),
        TYPE_ARGUMENT(3);

        private final int type_path_kind;
        private static final Map<Integer, TypePathKind> fromValue;

        private TypePathKind(int type_path_kind) {
            this.type_path_kind = type_path_kind;
        }

        public static TypePathKind fromValue(int value) {
            return fromValue.get(value);
        }

        static {
            TypePathKind[] typePathKinds = TypePathKind.values();
            fromValue = HashMapFactory.make(typePathKinds.length);
            for (TypePathKind typePathKind : typePathKinds) {
                fromValue.put(typePathKind.type_path_kind, typePathKind);
            }
        }
    }

    public static enum AnnotationType {
        RuntimeInvisibleTypeAnnotations,
        RuntimeVisibleTypeAnnotations;

    }

    public static class TypeArgumentTarget
    extends TypeAnnotationTarget {
        private final int offset;
        private final int type_argument_index;

        public TypeArgumentTarget(int offset, int type_argument_index) {
            super(TargetInfo.type_argument_target);
            this.offset = offset;
            this.type_argument_index = type_argument_index;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getTypeArgumentIndex() {
            return this.type_argument_index;
        }

        @Override
        public <R> R acceptVisitor(TypeAnnotationTargetVisitor<R> visitor) {
            return visitor.visitTypeArgumentTarget(this);
        }
    }

    public static class OffsetTarget
    extends TypeAnnotationTarget {
        private final int offset;

        public OffsetTarget(int offset) {
            super(TargetInfo.offset_target);
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        @Override
        public <R> R acceptVisitor(TypeAnnotationTargetVisitor<R> visitor) {
            return visitor.visitOffsetTarget(this);
        }
    }

    public static class CatchTarget
    extends TypeAnnotationTarget {
        private final int[] rawHandler;
        private final String catchType;
        public static final String ALL_EXCEPTIONS = null;

        public CatchTarget(int[] rawHandler, String catchType) {
            super(TargetInfo.catch_target);
            this.rawHandler = rawHandler;
            this.catchType = catchType;
        }

        public int[] getRawHandler() {
            return Arrays.copyOf(this.rawHandler, this.rawHandler.length);
        }

        @Override
        public <R> R acceptVisitor(TypeAnnotationTargetVisitor<R> visitor) {
            return visitor.visitCatchTarget(this);
        }

        public String getCatchType() {
            return this.catchType;
        }

        public int getStartPC() {
            return this.rawHandler[0];
        }

        public int getEndPC() {
            return this.rawHandler[1];
        }

        public int getCatchPC() {
            return this.rawHandler[2];
        }
    }

    public static class LocalVarTarget
    extends TypeAnnotationTarget {
        private final int[] start_pc;
        private final int[] length;
        private final int[] index;

        public LocalVarTarget(int[] start_pc, int[] length, int[] index) {
            super(TargetInfo.localvar_target);
            if (start_pc.length != length.length || length.length != index.length) {
                throw new IllegalArgumentException();
            }
            this.start_pc = Arrays.copyOf(start_pc, start_pc.length);
            this.length = Arrays.copyOf(length, length.length);
            this.index = Arrays.copyOf(index, index.length);
        }

        public int getNrOfRanges() {
            return this.start_pc.length;
        }

        public int getStartPc(int range) {
            return this.start_pc[range];
        }

        public int getLength(int range) {
            return this.length[range];
        }

        public int getIndex(int range) {
            return this.index[range];
        }

        @Override
        public <R> R acceptVisitor(TypeAnnotationTargetVisitor<R> visitor) {
            return visitor.visitLocalVarTarget(this);
        }
    }

    public static class ThrowsTarget
    extends TypeAnnotationTarget {
        private final String throwType;

        public ThrowsTarget(String throwType) {
            super(TargetInfo.supertype_target);
            this.throwType = throwType;
        }

        public String getThrowType() {
            return this.throwType;
        }

        @Override
        public <R> R acceptVisitor(TypeAnnotationTargetVisitor<R> visitor) {
            return visitor.visitThrowsTarget(this);
        }
    }

    public static class FormalParameterTarget
    extends TypeAnnotationTarget {
        private final int formal_parameter_index;

        public FormalParameterTarget(int index) {
            super(TargetInfo.formal_parameter_target);
            this.formal_parameter_index = index;
        }

        public int getIndex() {
            return this.formal_parameter_index;
        }

        @Override
        public <R> R acceptVisitor(TypeAnnotationTargetVisitor<R> visitor) {
            return visitor.visitFormalParameterTarget(this);
        }
    }

    public static class EmptyTarget
    extends TypeAnnotationTarget {
        public EmptyTarget() {
            super(TargetInfo.empty_target);
        }

        @Override
        public <R> R acceptVisitor(TypeAnnotationTargetVisitor<R> visitor) {
            return visitor.visitEmptyTarget(this);
        }
    }

    public static class TypeParameterBoundTarget
    extends TypeAnnotationTarget {
        private final int type_parameter_index;
        private final int bound_index;
        private final String boundSignature;

        public TypeParameterBoundTarget(int type_parameter_index, int bound_index, String boundSignature) {
            super(TargetInfo.type_parameter_bound_target);
            this.type_parameter_index = type_parameter_index;
            this.bound_index = bound_index;
            this.boundSignature = boundSignature;
        }

        public int getParameterIndex() {
            return this.type_parameter_index;
        }

        public int getBoundIndex() {
            return this.bound_index;
        }

        @Override
        public <R> R acceptVisitor(TypeAnnotationTargetVisitor<R> visitor) {
            return visitor.visitTypeParameterBoundTarget(this);
        }

        public String getBoundSignature() {
            return this.boundSignature;
        }
    }

    public static class SuperTypeTarget
    extends TypeAnnotationTarget {
        private final String superType;

        public SuperTypeTarget(String superType) {
            super(TargetInfo.supertype_target);
            this.superType = superType;
        }

        public String getSuperType() {
            return this.superType;
        }

        @Override
        public <R> R acceptVisitor(TypeAnnotationTargetVisitor<R> visitor) {
            return visitor.visitSuperTypeTarget(this);
        }
    }

    public static class TypeParameterTarget
    extends TypeAnnotationTarget {
        private final int type_parameter_index;

        public TypeParameterTarget(int type_parameter_index) {
            super(TargetInfo.type_parameter_target);
            this.type_parameter_index = type_parameter_index;
        }

        public int getIndex() {
            return this.type_parameter_index;
        }

        @Override
        public <R> R acceptVisitor(TypeAnnotationTargetVisitor<R> visitor) {
            return visitor.visitTypeParameterTarget(this);
        }
    }

    public static interface TypeAnnotationTargetVisitor<R> {
        public R visitTypeParameterTarget(TypeParameterTarget var1);

        public R visitSuperTypeTarget(SuperTypeTarget var1);

        public R visitTypeParameterBoundTarget(TypeParameterBoundTarget var1);

        public R visitEmptyTarget(EmptyTarget var1);

        public R visitFormalParameterTarget(FormalParameterTarget var1);

        public R visitThrowsTarget(ThrowsTarget var1);

        public R visitLocalVarTarget(LocalVarTarget var1);

        public R visitCatchTarget(CatchTarget var1);

        public R visitOffsetTarget(OffsetTarget var1);

        public R visitTypeArgumentTarget(TypeArgumentTarget var1);
    }

    public static abstract class TypeAnnotationTarget {
        private final TargetInfo targetInfo;

        protected TypeAnnotationTarget(TargetInfo targetInfo) {
            this.targetInfo = targetInfo;
        }

        public TargetInfo getTargetInfo() {
            return this.targetInfo;
        }

        public abstract <R> R acceptVisitor(TypeAnnotationTargetVisitor<R> var1);
    }

    public static enum TargetType {
        CLASS_TYPE_PARAMETER(0, TargetInfo.type_parameter_target, TypeAnnotationLocation.ClassFile),
        METHOD_TYPE_PARAMETER(1, TargetInfo.type_parameter_target, TypeAnnotationLocation.method_info),
        CLASS_EXTENDS(16, TargetInfo.supertype_target, TypeAnnotationLocation.ClassFile),
        CLASS_TYPE_PARAMETER_BOUND(17, TargetInfo.type_parameter_bound_target, TypeAnnotationLocation.ClassFile),
        METHOD_TYPE_PARAMETER_BOUND(18, TargetInfo.type_parameter_bound_target, TypeAnnotationLocation.method_info),
        FIELD(19, TargetInfo.empty_target, TypeAnnotationLocation.field_info),
        METHOD_RETURN(20, TargetInfo.empty_target, TypeAnnotationLocation.method_info),
        METHOD_RECEIVER(21, TargetInfo.empty_target, TypeAnnotationLocation.method_info),
        METHOD_FORMAL_PARAMETER(22, TargetInfo.formal_parameter_target, TypeAnnotationLocation.method_info),
        THROWS(23, TargetInfo.throws_target, TypeAnnotationLocation.method_info),
        LOCAL_VARIABLE(64, TargetInfo.localvar_target, TypeAnnotationLocation.Code),
        RESOURCE_VARIABLE(65, TargetInfo.localvar_target, TypeAnnotationLocation.Code),
        EXCEPTION_PARAMETER(66, TargetInfo.catch_target, TypeAnnotationLocation.Code),
        INSTANCEOF(67, TargetInfo.offset_target, TypeAnnotationLocation.Code),
        NEW(68, TargetInfo.offset_target, TypeAnnotationLocation.Code),
        CONSTRUCTOR_REFERENCE(69, TargetInfo.offset_target, TypeAnnotationLocation.Code),
        METHOD_REFERENCE(70, TargetInfo.offset_target, TypeAnnotationLocation.Code),
        CAST(71, TargetInfo.type_argument_target, TypeAnnotationLocation.Code),
        CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT(72, TargetInfo.type_argument_target, TypeAnnotationLocation.Code),
        METHOD_INVOCATION_TYPE_ARGUMENT(73, TargetInfo.type_argument_target, TypeAnnotationLocation.Code),
        CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT(74, TargetInfo.type_argument_target, TypeAnnotationLocation.Code),
        METHOD_REFERENCE_TYPE_ARGUMENT(75, TargetInfo.type_argument_target, TypeAnnotationLocation.Code);

        private static final Map<Integer, TargetType> fromValue;
        public final int target_type;
        public final TargetInfo target_info;
        public final TypeAnnotationLocation location;

        public static TargetType fromValue(int value) {
            return fromValue.get(value);
        }

        private TargetType(int target_type, TargetInfo target_info, TypeAnnotationLocation location) {
            if (0 > target_type || target_type > 127) {
                throw new IllegalArgumentException("Code may break for target_type that does not fit in a Java (signed!) byte");
            }
            this.target_type = target_type;
            this.target_info = target_info;
            this.location = location;
        }

        static {
            TargetType[] targetTypes = TargetType.values();
            fromValue = HashMapFactory.make(targetTypes.length);
            for (TargetType targetType : targetTypes) {
                fromValue.put(targetType.target_type, targetType);
            }
        }
    }

    public static enum TargetInfo {
        type_parameter_target,
        supertype_target,
        type_parameter_bound_target,
        empty_target,
        formal_parameter_target,
        throws_target,
        localvar_target,
        catch_target,
        offset_target,
        type_argument_target;

    }

    public static enum TypeAnnotationLocation {
        ClassFile,
        method_info,
        field_info,
        Code;

    }
}

