/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.sourcepos;

import com.ibm.wala.sourcepos.InvalidPositionException;

public final class Position {
    private static final int NOPOS = 0;
    private static final int LINE_SHIFT = 10;
    private static final int COLUMN_MASK = 1023;
    private final int position;

    Position() {
        this.position = 0;
    }

    Position(int position) throws InvalidPositionException {
        this.position = position;
        if (!this.isUndefined() && this.getLine() == 0) {
            throw new InvalidPositionException(InvalidPositionException.Cause.LINE_NUMBER_ZERO);
        }
        if (!this.isUndefined() && this.getColumn() == 0) {
            throw new InvalidPositionException(InvalidPositionException.Cause.COLUMN_NUMBER_ZERO);
        }
    }

    Position(int line, int column) throws InvalidPositionException {
        if (line < 0 || line >= 0x400000) {
            throw new InvalidPositionException(InvalidPositionException.Cause.LINE_NUMBER_OUT_OF_RANGE);
        }
        if (column < 0 || column > 1023) {
            throw new InvalidPositionException(InvalidPositionException.Cause.COLUMN_NUMBER_OUT_OF_RANGE);
        }
        if (line == 0 && column != 0) {
            throw new InvalidPositionException(InvalidPositionException.Cause.LINE_NUMBER_ZERO);
        }
        if (line != 0 && column == 0) {
            throw new InvalidPositionException(InvalidPositionException.Cause.COLUMN_NUMBER_ZERO);
        }
        this.position = (line << 10) + column;
    }

    public final int getLine() {
        return this.position >>> 10;
    }

    public final int getColumn() {
        return this.position & 0x3FF;
    }

    public final boolean isUndefined() {
        return this.position == 0;
    }

    boolean isBefore(Position p) {
        return p != null && !this.isUndefined() && !p.isUndefined() && this.toLong() < p.toLong();
    }

    private long toLong() {
        return (long)this.position & 0xFFFFFFFFL;
    }

    int toUnsignedInt() {
        return this.position;
    }

    public String toString() {
        return this.getLine() + ":" + this.getColumn();
    }
}

