/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.IAuxiliaryCache;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.ref.CacheReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class AuxiliaryCache
implements IAuxiliaryCache {
    private HashMap<Pair<IMethod, Context>, Map<SSAOptions, Object>> dictionary = HashMapFactory.make();
    private static final int RESET_THRESHOLD = 2000;
    private int nItems = 0;

    @Override
    public synchronized void wipe() {
        this.dictionary = HashMapFactory.make();
        this.nItems = 0;
    }

    private void reset() {
        HashMap<Pair<IMethod, Context>, Map<SSAOptions, Object>> oldDictionary = this.dictionary;
        this.dictionary = HashMapFactory.make();
        this.nItems = 0;
        for (Map.Entry e : oldDictionary.entrySet()) {
            Map m3 = (Map)e.getValue();
            HashSet toRemove = HashSetFactory.make();
            for (Map.Entry e2 : m3.entrySet()) {
                Object key = e2.getKey();
                Object val = e2.getValue();
                if (CacheReference.get(val) != null) continue;
                toRemove.add(key);
            }
            for (Map.Entry object : toRemove) {
                m3.remove(object);
            }
            if (m3.size() <= 0) continue;
            this.dictionary.put((Pair<IMethod, Context>)e.getKey(), m3);
        }
    }

    @Override
    public synchronized Object find(IMethod m3, Context c, SSAOptions options) {
        Pair<IMethod, Context> p = Pair.make(m3, c);
        Map<SSAOptions, Object> methodMap = MapUtil.findOrCreateMap(this.dictionary, p);
        Object ref = methodMap.get(options);
        if (ref == null || CacheReference.get(ref) == null) {
            return null;
        }
        return CacheReference.get(ref);
    }

    @Override
    public synchronized void cache(IMethod m3, Context c, SSAOptions options, Object aux) {
        ++this.nItems;
        if (this.nItems > 2000) {
            this.reset();
        }
        Pair<IMethod, Context> p = Pair.make(m3, c);
        Map<SSAOptions, Object> methodMap = MapUtil.findOrCreateMap(this.dictionary, p);
        Object ref = CacheReference.make(aux);
        methodMap.put(options, ref);
    }

    @Override
    public void invalidate(IMethod method, Context c) {
        this.dictionary.remove(Pair.make(method, c));
    }
}

