/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.ArrayList;
import java.util.Iterator;

public class DefUse {
    static final boolean DEBUG = false;
    private final SSAInstruction[] defs;
    private final MutableIntSet[] uses;
    protected final ArrayList<SSAInstruction> allInstructions = new ArrayList();
    private final IR ir;

    public DefUse(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        this.ir = ir;
        this.initAllInstructions();
        this.defs = new SSAInstruction[this.getMaxValueNumber() + 1];
        this.uses = new MutableIntSet[this.getMaxValueNumber() + 1];
        Iterator<SSAInstruction> it = this.allInstructions.iterator();
        for (int i = 0; i < this.allInstructions.size(); ++i) {
            int j;
            SSAInstruction s2 = it.next();
            if (s2 == null) continue;
            for (j = 0; j < this.getNumberOfDefs(s2); ++j) {
                this.defs[this.getDef((SSAInstruction)s2, (int)j)] = s2;
            }
            for (j = 0; j < this.getNumberOfUses(s2); ++j) {
                int use = this.getUse(s2, j);
                try {
                    if (use == -1) continue;
                    if (this.uses[use] == null) {
                        this.uses[use] = IntSetUtil.make();
                    }
                    this.uses[use].add(i);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    assert (false) : "unexpected value number " + use;
                    continue;
                }
            }
        }
    }

    protected int getMaxValueNumber() {
        return this.ir.getSymbolTable().getMaxValueNumber();
    }

    protected void initAllInstructions() {
        for (SSAInstruction inst : Iterator2Iterable.make(this.ir.iterateAllInstructions())) {
            this.allInstructions.add(inst);
        }
    }

    protected int getDef(SSAInstruction s2, int i) {
        return s2.getDef(i);
    }

    protected int getUse(SSAInstruction s2, int i) {
        return s2.getUse(i);
    }

    protected int getNumberOfDefs(SSAInstruction s2) {
        return s2.getNumberOfDefs();
    }

    protected int getNumberOfUses(SSAInstruction s2) {
        return s2.getNumberOfUses();
    }

    public SSAInstruction getDef(int v) {
        return v < this.defs.length ? this.defs[v] : null;
    }

    public Iterator<SSAInstruction> getUses(int v) {
        if (this.uses[v] == null) {
            return EmptyIterator.instance();
        }
        return new UseIterator(this.uses[v]);
    }

    public int getNumberOfUses(int v) {
        return this.uses[v] == null ? 0 : this.uses[v].size();
    }

    public boolean isUnused(int v) {
        MutableIntSet usesSet = this.uses[v];
        assert (usesSet == null || !usesSet.isEmpty());
        return usesSet == null;
    }

    private class UseIterator
    implements Iterator<SSAInstruction> {
        final IntIterator it;

        UseIterator(IntSet uses) {
            this.it = uses.intIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public SSAInstruction next() {
            return DefUse.this.allInstructions.get(this.it.next());
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }
}

