/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;

public abstract class SSAAbstractInvokeInstruction
extends SSAInstruction {
    protected final int exception;
    protected final CallSiteReference site;

    protected SSAAbstractInvokeInstruction(int iindex, int exception, CallSiteReference site) {
        super(iindex);
        this.exception = exception;
        this.site = site;
    }

    public CallSiteReference getCallSite() {
        return this.site;
    }

    public boolean isStatic() {
        return this.getCallSite().isStatic();
    }

    public boolean isDispatch() {
        return this.getCallSite().isDispatch();
    }

    public boolean isSpecial() {
        return this.getCallSite().isSpecial();
    }

    public int getReceiver() {
        assert (this.site.getInvocationCode() != IInvokeInstruction.Dispatch.STATIC) : this.toString();
        return this.getUse(0);
    }

    public int getProgramCounter() {
        return this.site.getProgramCounter();
    }

    @Override
    public int getNumberOfDefs() {
        return this.getNumberOfReturnValues() + 1;
    }

    @Override
    public int getDef(int i) {
        if (this.getNumberOfReturnValues() == 0) {
            assert (i == 0);
            return this.exception;
        }
        switch (i) {
            case 0: {
                return this.getReturnValue(0);
            }
            case 1: {
                return this.exception;
            }
        }
        return this.getReturnValue(i - 1);
    }

    public int getException() {
        return this.exception;
    }

    @Override
    public boolean hasDef() {
        return this.getNumberOfReturnValues() > 0;
    }

    @Override
    public int getDef() {
        return this.getReturnValue(0);
    }

    public abstract int getNumberOfPositionalParameters();

    public abstract int getNumberOfReturnValues();

    public abstract int getReturnValue(int var1);

    public TypeReference getDeclaredResultType() {
        return this.site.getDeclaredTarget().getReturnType();
    }

    public MethodReference getDeclaredTarget() {
        return this.site.getDeclaredTarget();
    }

    public IInvokeInstruction.IDispatch getInvocationCode() {
        return this.site.getInvocationCode();
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        String code = this.site.getInvocationString();
        StringBuilder s2 = new StringBuilder();
        if (this.hasDef()) {
            s2.append(this.getValueString(symbolTable, this.getDef())).append(" = ");
        }
        s2.append("invoke").append(code);
        s2.append(' ');
        s2.append(this.site.getDeclaredTarget().toString());
        if (this.getNumberOfPositionalParameters() > 0) {
            s2.append(' ').append(this.getValueString(symbolTable, this.getUse(0)));
            for (int i = 1; i < this.getNumberOfPositionalParameters(); ++i) {
                s2.append(',').append(this.getValueString(symbolTable, this.getUse(i)));
            }
        }
        s2.append(" @");
        s2.append(this.site.getProgramCounter());
        if (this.exception == -1) {
            s2.append(" exception: NOT MODELED");
        } else {
            s2.append(" exception:").append(this.getValueString(symbolTable, this.exception));
        }
        return s2.toString();
    }
}

