/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public abstract class SSAArrayLengthInstruction
extends SSAInstruction {
    private final int result;
    private final int arrayref;

    protected SSAArrayLengthInstruction(int iindex, int result, int arrayref) {
        super(iindex);
        this.result = result;
        this.arrayref = arrayref;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) throws IllegalArgumentException {
        if (defs != null && defs.length != 1) {
            throw new IllegalArgumentException();
        }
        if (uses != null && uses.length != 1) {
            throw new IllegalArgumentException();
        }
        return insts.ArrayLengthInstruction(this.iIndex(), defs == null ? this.result : defs[0], uses == null ? this.arrayref : uses[0]);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return this.getValueString(symbolTable, this.result) + " = arraylength " + this.getValueString(symbolTable, this.arrayref);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitArrayLength(this);
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef(int i) {
        if (i != 0) {
            throw new IllegalArgumentException("invalid i " + i);
        }
        return this.result;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    public int getArrayRef() {
        return this.arrayref;
    }

    @Override
    public int getNumberOfUses() {
        return 1;
    }

    @Override
    public int getUse(int j) {
        if (j != 0) {
            throw new IllegalArgumentException("invalid j: " + j);
        }
        return this.arrayref;
    }

    @Override
    public int hashCode() {
        return this.arrayref * 7573 + this.result * 563;
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }
}

