/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.analysis.stackMachine.AbstractIntStackMachine;
import com.ibm.wala.cfg.ShrikeCFG;
import com.ibm.wala.classLoader.BytecodeLanguage;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstanceofInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.ILoadIndirectInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IStoreIndirectInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.ITypeTestInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.IndirectionData;
import com.ibm.wala.shrikeBT.InvokeDynamicInstruction;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.PhiValue;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPiNodePolicy;
import com.ibm.wala.ssa.ShrikeIndirectionData;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.dominators.Dominators;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.shrike.ShrikeUtil;
import java.util.Arrays;

public class SSABuilder
extends AbstractIntStackMachine {
    private final IBytecodeMethod<?> method;
    private final SymbolTable symbolTable;
    private final SSA2LocalMap localMap;
    private final SSAInstructionFactory insts;
    private final IndirectionData bytecodeIndirections;
    private final ShrikeIndirectionData ssaIndirections;

    public static SSABuilder make(IBytecodeMethod<?> method, SSACFG cfg, ShrikeCFG scfg, SSAInstruction[] instructions, SymbolTable symbolTable, boolean buildLocalMap, SSAPiNodePolicy piNodePolicy) throws IllegalArgumentException {
        if (scfg == null) {
            throw new IllegalArgumentException("scfg == null");
        }
        return new SSABuilder(method, cfg, scfg, instructions, symbolTable, buildLocalMap, piNodePolicy);
    }

    private SSABuilder(IBytecodeMethod<?> method, SSACFG cfg, ShrikeCFG scfg, SSAInstruction[] instructions, SymbolTable symbolTable, boolean buildLocalMap, SSAPiNodePolicy piNodePolicy) {
        super(scfg);
        this.localMap = buildLocalMap ? new SSA2LocalMap(scfg, instructions.length, cfg.getNumberOfNodes()) : null;
        this.init(new SymbolTableMeeter(symbolTable, cfg, scfg), new SymbolicPropagator(scfg, instructions, symbolTable, this.localMap, cfg, piNodePolicy));
        this.method = method;
        this.symbolTable = symbolTable;
        this.insts = method.getDeclaringClass().getClassLoader().getInstructionFactory();
        this.bytecodeIndirections = method.getIndirectionData();
        this.ssaIndirections = new ShrikeIndirectionData(instructions.length);
        assert (cfg != null) : "Null CFG";
    }

    @Override
    protected void initializeVariables() {
        AbstractIntStackMachine.MachineState entryState = this.getEntryState();
        int parameterNumber = 0;
        int local = -1;
        for (int i = 0; i < this.method.getNumberOfParameters(); ++i) {
            ++local;
            TypeReference t = this.method.getParameterType(i);
            if (t == null) continue;
            int symbol = this.symbolTable.getParameter(parameterNumber++);
            entryState.setLocal(local, symbol);
            if (!t.equals(TypeReference.Double) && !t.equals(TypeReference.Long)) continue;
            ++local;
        }
        entryState.push(this.symbolTable.newSymbol());
    }

    public void build() {
        this.solve();
        if (this.localMap != null) {
            this.localMap.finishLocalMap(this);
        }
    }

    public SSA2LocalMap getLocalMap() {
        return this.localMap;
    }

    public ShrikeIndirectionData getIndirectionData() {
        return this.ssaIndirections;
    }

    private static class SSA2LocalMap
    implements IR.SSA2LocalMap {
        private final ShrikeCFG shrikeCFG;
        private final IntPair[] localStoreMap;
        private final int[][] block2LocalState;

        SSA2LocalMap(ShrikeCFG shrikeCfg, int nInstructions, int nBlocks) {
            this.shrikeCFG = shrikeCfg;
            this.localStoreMap = new IntPair[nInstructions];
            this.block2LocalState = new int[nBlocks][];
        }

        void startRange(int pc, int localNumber, int valueNumber) {
            this.localStoreMap[pc] = new IntPair(valueNumber, localNumber);
        }

        private void finishLocalMap(SSABuilder builder) {
            for (ShrikeCFG.BasicBlock bb : this.shrikeCFG) {
                AbstractIntStackMachine.MachineState S = builder.getIn(bb);
                int number = bb.getNumber();
                this.block2LocalState[number] = S.getLocals();
            }
        }

        @Override
        public String[] getLocalNames(int index, int vn) {
            try {
                if (!this.shrikeCFG.getMethod().hasLocalVariableTable()) {
                    return null;
                }
                int[] localNumbers = this.findLocalsForValueNumber(index, vn);
                if (localNumbers == null) {
                    return null;
                }
                IMethod m3 = this.shrikeCFG.getMethod();
                String[] result = new String[localNumbers.length];
                for (int i = 0; i < localNumbers.length; ++i) {
                    result[i] = m3.getLocalVariableName(m3.getBytecodeIndex(index), localNumbers[i]);
                }
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
                return null;
            }
        }

        public int[] allocateNewLocalsArray(int maxLocals) {
            int[] result = new int[maxLocals];
            for (int i = 0; i < maxLocals; ++i) {
                result[i] = -1;
            }
            return result;
        }

        private int[] setLocal(int[] locals, int localNumber, int valueNumber) {
            if (locals == null) {
                locals = this.allocateNewLocalsArray(localNumber + 1);
            } else if (locals.length <= localNumber) {
                int[] newLocals = this.allocateNewLocalsArray(2 * Math.max(locals.length, localNumber) + 1);
                System.arraycopy(locals, 0, newLocals, 0, locals.length);
                locals = newLocals;
            }
            locals[localNumber] = valueNumber;
            return locals;
        }

        private int[] findLocalsForValueNumber(int pc, int vn) {
            if (vn < 0) {
                return null;
            }
            ShrikeCFG.BasicBlock bb = this.shrikeCFG.getBlockForInstruction(pc);
            int firstInstruction = bb.getFirstInstructionIndex();
            int[] locals = this.block2LocalState[bb.getNumber()];
            for (int i = firstInstruction; i <= pc; ++i) {
                if (this.localStoreMap[i] == null) continue;
                IntPair p = this.localStoreMap[i];
                locals = this.setLocal(locals, p.getY(), p.getX());
            }
            return locals == null ? null : SSA2LocalMap.extractIndices(locals, vn);
        }

        private static int[] extractIndices(int[] x, int y) {
            assert (x != null);
            int count = 0;
            for (int element : x) {
                if (element != y) continue;
                ++count;
            }
            if (count == 0) {
                return null;
            }
            int[] result = new int[count];
            int j = 0;
            for (int i = 0; i < x.length; ++i) {
                if (x[i] != y) continue;
                result[j++] = i;
            }
            return result;
        }
    }

    private class SymbolicPropagator
    extends AbstractIntStackMachine.BasicStackFlowProvider {
        final SSAInstruction[] instructions;
        final SymbolTable symbolTable;
        final ShrikeCFG shrikeCFG;
        final SSACFG cfg;
        final ClassLoaderReference loader;
        private SSAInstruction[] creators;
        final SSA2LocalMap localMap;
        final SSAPiNodePolicy piNodePolicy;

        public SymbolicPropagator(ShrikeCFG shrikeCFG, SSAInstruction[] instructions, SymbolTable symbolTable, SSA2LocalMap localMap, SSACFG cfg, SSAPiNodePolicy piNodePolicy) {
            super(shrikeCFG);
            this.piNodePolicy = piNodePolicy;
            this.cfg = cfg;
            this.creators = new SSAInstruction[0];
            this.shrikeCFG = shrikeCFG;
            this.instructions = instructions;
            this.symbolTable = symbolTable;
            this.loader = shrikeCFG.getMethod().getDeclaringClass().getClassLoader().getReference();
            this.localMap = localMap;
            this.init(new NodeVisitor(), new EdgeVisitor());
        }

        @Override
        public boolean needsEdgeFlow() {
            return this.piNodePolicy != null;
        }

        private void emitInstruction(SSAInstruction s2) {
            if (s2 != null) {
                this.instructions[this.getCurrentInstructionIndex()] = s2;
                for (int i = 0; i < s2.getNumberOfDefs(); ++i) {
                    if (this.creators.length < s2.getDef(i) + 1) {
                        this.creators = Arrays.copyOf(this.creators, 2 * s2.getDef(i));
                    }
                    assert (s2.getDef(i) != -1) : "invalid def " + i + " for " + s2;
                    this.creators[s2.getDef((int)i)] = s2;
                }
            }
        }

        private SSAInstruction getCurrentInstruction() {
            return this.instructions[this.getCurrentInstructionIndex()];
        }

        private int reuseOrCreateDef() {
            if (this.getCurrentInstruction() == null) {
                return this.symbolTable.newSymbol();
            }
            return this.getCurrentInstruction().getDef();
        }

        private int reuseOrCreateException() {
            if (this.getCurrentInstruction() != null) assert (this.getCurrentInstruction() instanceof SSAInvokeInstruction);
            if (this.getCurrentInstruction() == null) {
                return this.symbolTable.newSymbol();
            }
            SSAInvokeInstruction s2 = (SSAInvokeInstruction)this.getCurrentInstruction();
            return s2.getException();
        }

        private void reuseOrCreatePi(SSAInstruction piCause, int ref) {
            int n = this.getCurrentInstructionIndex();
            SSACFG.BasicBlock bb = this.cfg.getBlockForInstruction(n);
            ShrikeCFG.BasicBlock path = this.getCurrentSuccessor();
            int outNum = this.shrikeCFG.getNumber(path);
            SSAPiInstruction pi = bb.getPiForRefAndPath(ref, path);
            if (pi == null) {
                pi = SSABuilder.this.insts.PiInstruction(-1, this.symbolTable.newSymbol(), ref, bb.getNumber(), outNum, piCause);
                bb.addPiForRefAndPath(ref, path, pi);
            }
            this.workingState.replaceValue(ref, pi.getDef());
        }

        private void maybeInsertPi(SSAAbstractInvokeInstruction call) {
            Pair<Integer, SSAInstruction> pi;
            if (this.piNodePolicy != null && (pi = this.piNodePolicy.getPi(call, this.symbolTable)) != null) {
                this.reuseOrCreatePi((SSAInstruction)pi.snd, (Integer)pi.fst);
            }
        }

        private void maybeInsertPi(SSAConditionalBranchInstruction cond) {
            if (this.piNodePolicy != null) {
                for (Pair<Integer, SSAInstruction> pi : this.piNodePolicy.getPis(cond, this.getDef(cond.getUse(0)), this.getDef(cond.getUse(1)), this.symbolTable)) {
                    if (pi == null) continue;
                    this.reuseOrCreatePi((SSAInstruction)pi.snd, (Integer)pi.fst);
                }
            }
        }

        private SSAInstruction getDef(int vn) {
            if (vn < this.creators.length) {
                return this.creators[vn];
            }
            return null;
        }

        @Override
        public IInstruction[] getInstructions() {
            try {
                return (IInstruction[])this.shrikeCFG.getMethod().getInstructions();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
                return null;
            }
        }

        class EdgeVisitor
        extends IInstruction.Visitor {
            EdgeVisitor() {
            }

            @Override
            public void visitInvoke(IInvokeInstruction instruction) {
                SymbolicPropagator.this.maybeInsertPi((SSAAbstractInvokeInstruction)SymbolicPropagator.this.getCurrentInstruction());
            }

            @Override
            public void visitConditionalBranch(IConditionalBranchInstruction instruction) {
                SymbolicPropagator.this.maybeInsertPi((SSAConditionalBranchInstruction)SymbolicPropagator.this.getCurrentInstruction());
            }
        }

        class NodeVisitor
        extends AbstractIntStackMachine.BasicStackFlowProvider.BasicStackMachineVisitor {
            private Dominators<ISSABasicBlock> dom = null;

            NodeVisitor() {
            }

            @Override
            public void visitArrayLength(ArrayLengthInstruction instruction) {
                int arrayRef = SymbolicPropagator.this.workingState.pop();
                int length = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(length);
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ArrayLengthInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), length, arrayRef));
            }

            @Override
            public void visitArrayLoad(IArrayLoadInstruction instruction) {
                int index = SymbolicPropagator.this.workingState.pop();
                int arrayRef = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                if (instruction.isAddressOf()) {
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.AddressOfInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, arrayRef, index, t));
                } else {
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ArrayLoadInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, arrayRef, index, t));
                }
            }

            @Override
            public void visitArrayStore(IArrayStoreInstruction instruction) {
                int value = SymbolicPropagator.this.workingState.pop();
                int index = SymbolicPropagator.this.workingState.pop();
                int arrayRef = SymbolicPropagator.this.workingState.pop();
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ArrayStoreInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), arrayRef, index, value, t));
            }

            @Override
            public void visitBinaryOp(IBinaryOpInstruction instruction) {
                int val2 = SymbolicPropagator.this.workingState.pop();
                int val1 = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                boolean isFloat = instruction.getType().equals("D") || instruction.getType().equals("F");
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.BinaryOpInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getOperator(), instruction.throwsExceptionOnOverflow(), instruction.isUnsigned(), result, val1, val2, !isFloat));
            }

            @Override
            public void visitCheckCast(ITypeTestInstruction instruction) {
                int val = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                if (!instruction.firstClassTypes()) {
                    String[] typeNames = instruction.getTypes();
                    TypeReference[] t = new TypeReference[typeNames.length];
                    for (int i = 0; i < typeNames.length; ++i) {
                        t[i] = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, typeNames[i]);
                    }
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.CheckCastInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, val, t, instruction.isPEI()));
                }
            }

            @Override
            public void visitComparison(IComparisonInstruction instruction) {
                int val2 = SymbolicPropagator.this.workingState.pop();
                int val1 = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ComparisonInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getOperator(), result, val1, val2));
            }

            @Override
            public void visitConditionalBranch(IConditionalBranchInstruction instruction) {
                int val2 = SymbolicPropagator.this.workingState.pop();
                int val1 = SymbolicPropagator.this.workingState.pop();
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ConditionalBranchInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getOperator(), t, val1, val2, instruction.getTarget()));
            }

            @Override
            public void visitConstant(ConstantInstruction instruction) {
                Language l = SymbolicPropagator.this.cfg.getMethod().getDeclaringClass().getClassLoader().getLanguage();
                TypeReference type = l.getConstantType(instruction.getValue());
                int symbol = 0;
                if (l.isNullType(type)) {
                    symbol = SymbolicPropagator.this.symbolTable.getNullConstant();
                } else if (l.isIntType(type)) {
                    Integer value = (Integer)instruction.getValue();
                    symbol = SymbolicPropagator.this.symbolTable.getConstant(value);
                } else if (l.isLongType(type)) {
                    Long value = (Long)instruction.getValue();
                    symbol = SymbolicPropagator.this.symbolTable.getConstant(value);
                } else if (l.isFloatType(type)) {
                    Float value = (Float)instruction.getValue();
                    symbol = SymbolicPropagator.this.symbolTable.getConstant(value.floatValue());
                } else if (l.isDoubleType(type)) {
                    Double value = (Double)instruction.getValue();
                    symbol = SymbolicPropagator.this.symbolTable.getConstant(value);
                } else if (l.isStringType(type)) {
                    String value = (String)instruction.getValue();
                    symbol = SymbolicPropagator.this.symbolTable.getConstant(value);
                } else if (l.isMetadataType(type)) {
                    Object rval = l.getMetadataToken(instruction.getValue());
                    symbol = SymbolicPropagator.this.reuseOrCreateDef();
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.LoadMetadataInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), symbol, type, rval));
                } else {
                    Assertions.UNREACHABLE("unexpected " + type);
                }
                SymbolicPropagator.this.workingState.push(symbol);
            }

            @Override
            public void visitConversion(IConversionInstruction instruction) {
                int val = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                TypeReference fromType = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getFromType());
                TypeReference toType = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getToType());
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ConversionInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, val, fromType, toType, instruction.throwsExceptionOnOverflow()));
            }

            @Override
            public void visitGet(IGetInstruction instruction) {
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                FieldReference f = FieldReference.findOrCreate(SymbolicPropagator.this.loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
                if (instruction.isAddressOf()) {
                    int ref = instruction.isStatic() ? -1 : SymbolicPropagator.this.workingState.pop();
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.AddressOfInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, ref, f, f.getFieldType()));
                } else if (instruction.isStatic()) {
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.GetInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, f));
                } else {
                    int ref = SymbolicPropagator.this.workingState.pop();
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.GetInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, ref, f));
                }
                assert (result != -1);
                SymbolicPropagator.this.workingState.push(result);
            }

            @Override
            public void visitGoto(GotoInstruction instruction) {
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.GotoInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getLabel()));
            }

            @Override
            public void visitInstanceof(IInstanceofInstruction instruction) {
                int ref = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.InstanceofInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, ref, t));
            }

            @Override
            public void visitInvoke(IInvokeInstruction instruction) {
                this.doIndirectReads(SSABuilder.this.bytecodeIndirections.indirectlyReadLocals(SymbolicPropagator.this.getCurrentInstructionIndex()));
                int n = instruction.getPoppedCount();
                int[] params = new int[n];
                for (int i = n - 1; i >= 0; --i) {
                    params[i] = SymbolicPropagator.this.workingState.pop();
                }
                Language lang = SymbolicPropagator.this.shrikeCFG.getMethod().getDeclaringClass().getClassLoader().getLanguage();
                MethodReference m3 = ((BytecodeLanguage)lang).getInvokeMethodReference(SymbolicPropagator.this.loader, instruction);
                IInvokeInstruction.IDispatch code = instruction.getInvocationCode();
                CallSiteReference site = CallSiteReference.make(SymbolicPropagator.this.getCurrentProgramCounter(), m3, code);
                int exc = SymbolicPropagator.this.reuseOrCreateException();
                BootstrapMethodsReader.BootstrapMethod bootstrap = null;
                if (instruction instanceof InvokeDynamicInstruction) {
                    bootstrap = ((InvokeDynamicInstruction)instruction).getBootstrap();
                }
                if (instruction.getPushedWordSize() > 0) {
                    int result = SymbolicPropagator.this.reuseOrCreateDef();
                    SymbolicPropagator.this.workingState.push(result);
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.InvokeInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, params, exc, site, bootstrap));
                } else {
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.InvokeInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), params, exc, site, bootstrap));
                }
                this.doIndirectWrites(SSABuilder.this.bytecodeIndirections.indirectlyWrittenLocals(SymbolicPropagator.this.getCurrentInstructionIndex()), -1);
            }

            @Override
            public void visitLocalLoad(ILoadInstruction instruction) {
                if (instruction.isAddressOf()) {
                    int result = SymbolicPropagator.this.reuseOrCreateDef();
                    int t = SymbolicPropagator.this.workingState.getLocal(instruction.getVarIndex());
                    if (t == -1) {
                        this.doIndirectWrites(new int[]{instruction.getVarIndex()}, -1);
                        t = SymbolicPropagator.this.workingState.getLocal(instruction.getVarIndex());
                    }
                    TypeReference type = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.AddressOfInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, t, type));
                    SymbolicPropagator.this.workingState.push(result);
                } else {
                    super.visitLocalLoad(instruction);
                }
            }

            @Override
            public void visitLocalStore(IStoreInstruction instruction) {
                if (SymbolicPropagator.this.localMap != null) {
                    SymbolicPropagator.this.localMap.startRange(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getVarIndex(), SymbolicPropagator.this.workingState.peek());
                }
                super.visitLocalStore(instruction);
            }

            @Override
            public void visitMonitor(MonitorInstruction instruction) {
                int ref = SymbolicPropagator.this.workingState.pop();
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.MonitorInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), ref, instruction.isEnter()));
            }

            @Override
            public void visitNew(NewInstruction instruction) {
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                NewSiteReference ref = NewSiteReference.make(SymbolicPropagator.this.getCurrentProgramCounter(), t);
                if (t.isArrayType()) {
                    int[] sizes = new int[instruction.getArrayBoundsCount()];
                    for (int i = 0; i < instruction.getArrayBoundsCount(); ++i) {
                        sizes[instruction.getArrayBoundsCount() - 1 - i] = SymbolicPropagator.this.workingState.pop();
                    }
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.NewInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, ref, sizes));
                } else {
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.NewInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, ref));
                    this.popN(instruction);
                }
                SymbolicPropagator.this.workingState.push(result);
            }

            @Override
            public void visitPut(IPutInstruction instruction) {
                int value = SymbolicPropagator.this.workingState.pop();
                if (instruction.isStatic()) {
                    FieldReference f = FieldReference.findOrCreate(SymbolicPropagator.this.loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.PutInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), value, f));
                } else {
                    int ref = SymbolicPropagator.this.workingState.pop();
                    FieldReference f = FieldReference.findOrCreate(SymbolicPropagator.this.loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.PutInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), ref, value, f));
                }
            }

            @Override
            public void visitReturn(ReturnInstruction instruction) {
                if (instruction.getPoppedCount() == 1) {
                    int result = SymbolicPropagator.this.workingState.pop();
                    TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ReturnInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, t.isPrimitiveType()));
                } else {
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ReturnInstruction(SymbolicPropagator.this.getCurrentInstructionIndex()));
                }
            }

            @Override
            public void visitShift(IShiftInstruction instruction) {
                int val2 = SymbolicPropagator.this.workingState.pop();
                int val1 = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.BinaryOpInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getOperator(), false, instruction.isUnsigned(), result, val1, val2, true));
            }

            @Override
            public void visitSwitch(SwitchInstruction instruction) {
                int val = SymbolicPropagator.this.workingState.pop();
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.SwitchInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), val, instruction.getDefaultLabel(), instruction.getCasesAndLabels()));
            }

            private int findRethrowException() {
                int index = SymbolicPropagator.this.getCurrentInstructionIndex();
                SSACFG.BasicBlock bb = SymbolicPropagator.this.cfg.getBlockForInstruction(index);
                if (bb.isCatchBlock()) {
                    SSACFG.ExceptionHandlerBasicBlock newBB = (SSACFG.ExceptionHandlerBasicBlock)bb;
                    SSAGetCaughtExceptionInstruction s2 = newBB.getCatchInstruction();
                    return s2.getDef();
                }
                if (this.dom == null) {
                    this.dom = Dominators.make(SymbolicPropagator.this.cfg, SymbolicPropagator.this.cfg.entry());
                }
                ISSABasicBlock x = bb;
                while (x != null) {
                    if (x.isCatchBlock()) {
                        SSACFG.ExceptionHandlerBasicBlock newBB = (SSACFG.ExceptionHandlerBasicBlock)x;
                        SSAGetCaughtExceptionInstruction s3 = newBB.getCatchInstruction();
                        return s3.getDef();
                    }
                    x = this.dom.getIdom(x);
                }
                return -1;
            }

            @Override
            public void visitThrow(ThrowInstruction instruction) {
                if (instruction.isRethrow()) {
                    SymbolicPropagator.this.workingState.clearStack();
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ThrowInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), this.findRethrowException()));
                } else {
                    int exception = SymbolicPropagator.this.workingState.pop();
                    SymbolicPropagator.this.workingState.clearStack();
                    SymbolicPropagator.this.workingState.push(exception);
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ThrowInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), exception));
                }
            }

            @Override
            public void visitUnaryOp(IUnaryOpInstruction instruction) {
                int val = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.UnaryOpInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getOperator(), result, val));
            }

            private void doIndirectReads(int[] locals) {
                for (int local : locals) {
                    SSABuilder.this.ssaIndirections.setUse(SymbolicPropagator.this.getCurrentInstructionIndex(), new ShrikeIndirectionData.ShrikeLocalName(local), SymbolicPropagator.this.workingState.getLocal(local));
                }
            }

            @Override
            public void visitLoadIndirect(ILoadIndirectInstruction instruction) {
                int addressVal = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                this.doIndirectReads(SSABuilder.this.bytecodeIndirections.indirectlyReadLocals(SymbolicPropagator.this.getCurrentInstructionIndex()));
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getPushedType(null));
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.LoadIndirectInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, t, addressVal));
                SymbolicPropagator.this.workingState.push(result);
            }

            private void doIndirectWrites(int[] locals, int rval) {
                for (int local : locals) {
                    ShrikeIndirectionData.ShrikeLocalName name = new ShrikeIndirectionData.ShrikeLocalName(local);
                    int idx = SymbolicPropagator.this.getCurrentInstructionIndex();
                    if (SSABuilder.this.ssaIndirections.getDef(idx, name) == -1) {
                        SSABuilder.this.ssaIndirections.setDef(idx, name, rval == -1 ? SymbolicPropagator.this.symbolTable.newSymbol() : rval);
                    }
                    SymbolicPropagator.this.workingState.setLocal(local, SSABuilder.this.ssaIndirections.getDef(idx, name));
                }
            }

            @Override
            public void visitStoreIndirect(IStoreIndirectInstruction instruction) {
                int val = SymbolicPropagator.this.workingState.pop();
                int addressVal = SymbolicPropagator.this.workingState.pop();
                this.doIndirectWrites(SSABuilder.this.bytecodeIndirections.indirectlyWrittenLocals(SymbolicPropagator.this.getCurrentInstructionIndex()), val);
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.StoreIndirectInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), addressVal, val, t));
            }
        }
    }

    private class SymbolTableMeeter
    implements AbstractIntStackMachine.Meeter {
        final SSACFG cfg;
        final SymbolTable symbolTable;
        final ShrikeCFG shrikeCFG;

        SymbolTableMeeter(SymbolTable symbolTable, SSACFG cfg, ShrikeCFG shrikeCFG) {
            this.cfg = cfg;
            this.symbolTable = symbolTable;
            this.shrikeCFG = shrikeCFG;
        }

        @Override
        public int meetStack(int slot, int[] rhs, ShrikeCFG.BasicBlock bb) {
            int result;
            assert (bb != null) : "null basic block";
            if (bb.isExitBlock()) {
                return -1;
            }
            if (this.allTheSame(rhs)) {
                for (int rh : rhs) {
                    if (rh == -1) continue;
                    return rh;
                }
                return -1;
            }
            SSACFG.BasicBlock newBB = this.cfg.getNode(this.shrikeCFG.getNumber(bb));
            SSAPhiInstruction phi = newBB.getPhiForStackSlot(slot);
            if (phi == null) {
                result = this.symbolTable.newPhi(rhs);
                PhiValue v = this.symbolTable.getPhiValue(result);
                phi = v.getPhiInstruction();
                newBB.addPhiForStackSlot(slot, phi);
            } else {
                result = phi.getDef();
                phi.setValues((int[])rhs.clone());
            }
            return result;
        }

        @Override
        public int meetLocal(int n, int[] rhs, ShrikeCFG.BasicBlock bb) {
            int result;
            if (this.allTheSame(rhs)) {
                for (int rh : rhs) {
                    if (rh == -1) continue;
                    return rh;
                }
                return -1;
            }
            SSACFG.BasicBlock newBB = this.cfg.getNode(this.shrikeCFG.getNumber(bb));
            if (bb.isExitBlock()) {
                return -1;
            }
            SSAPhiInstruction phi = newBB.getPhiForLocal(n);
            if (phi == null) {
                result = this.symbolTable.newPhi(rhs);
                PhiValue v = this.symbolTable.getPhiValue(result);
                phi = v.getPhiInstruction();
                newBB.addPhiForLocal(n, phi);
            } else {
                result = phi.getDef();
                phi.setValues((int[])rhs.clone());
            }
            return result;
        }

        private boolean allTheSame(int[] rhs) {
            int x = -1;
            int i = 0;
            for (i = 0; i < rhs.length; ++i) {
                if (rhs[i] == -1) continue;
                x = rhs[i];
                break;
            }
            ++i;
            while (i < rhs.length) {
                if (rhs[i] != x && rhs[i] != -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public int meetStackAtCatchBlock(ShrikeCFG.BasicBlock bb) {
            int exceptionValue;
            int bbNumber = this.shrikeCFG.getNumber(bb);
            SSACFG.ExceptionHandlerBasicBlock newBB = (SSACFG.ExceptionHandlerBasicBlock)this.cfg.getNode(bbNumber);
            SSAGetCaughtExceptionInstruction s2 = newBB.getCatchInstruction();
            if (s2 == null) {
                exceptionValue = this.symbolTable.newSymbol();
                s2 = SSABuilder.this.insts.GetCaughtExceptionInstruction(-1, bbNumber, exceptionValue);
                newBB.setCatchInstruction(s2);
            } else {
                exceptionValue = s2.getException();
            }
            return exceptionValue;
        }
    }
}

