/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public abstract class SSACheckCastInstruction
extends SSAInstruction {
    private final int result;
    private final int val;
    private final TypeReference[] declaredResultTypes;
    private final boolean isPEI;

    protected SSACheckCastInstruction(int iindex, int result, int val, TypeReference[] types, boolean isPEI) {
        super(iindex);
        assert (val != -1);
        this.result = result;
        this.val = val;
        this.declaredResultTypes = types;
        this.isPEI = isPEI;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (defs != null && defs.length == 0) {
            throw new IllegalArgumentException("(defs != null) and (defs.length == 0)");
        }
        if (uses != null && uses.length == 0) {
            throw new IllegalArgumentException("(uses != null) and (uses.length == 0)");
        }
        return insts.CheckCastInstruction(this.iIndex(), defs == null ? this.result : defs[0], uses == null ? this.val : uses[0], this.declaredResultTypes, this.isPEI);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        StringBuilder v = new StringBuilder(this.getValueString(symbolTable, this.result)).append(" = checkcast");
        for (TypeReference t : this.declaredResultTypes) {
            v.append(' ').append(t);
        }
        v.append(this.getValueString(symbolTable, this.val));
        return v.toString();
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitCheckCast(this);
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public int getDef(int i) {
        assert (i == 0);
        return this.result;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    @Override
    public int getNumberOfUses() {
        return 1;
    }

    @Override
    public int getUse(int j) {
        assert (j == 0);
        return this.val;
    }

    @Deprecated
    public TypeReference getDeclaredResultType() {
        assert (this.declaredResultTypes.length == 1);
        return this.declaredResultTypes[0];
    }

    public TypeReference[] getDeclaredResultTypes() {
        return this.declaredResultTypes;
    }

    public int getResult() {
        return this.result;
    }

    public int getVal() {
        return this.val;
    }

    @Override
    public int hashCode() {
        return this.result * 7529 + this.val;
    }

    @Override
    public boolean isPEI() {
        return this.isPEI;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder(super.toString());
        for (TypeReference t : this.declaredResultTypes) {
            s2.append(' ').append(t);
        }
        return s2.toString();
    }
}

