/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public class SSAComparisonInstruction
extends SSAInstruction {
    private final int result;
    private final int val1;
    private final int val2;
    private final IComparisonInstruction.Operator operator;

    public SSAComparisonInstruction(int iindex, IComparisonInstruction.Operator operator, int result, int val1, int val2) {
        super(iindex);
        this.operator = operator;
        this.result = result;
        this.val1 = val1;
        this.val2 = val2;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) throws IllegalArgumentException {
        if (uses != null && uses.length != 2) {
            throw new IllegalArgumentException("expected 2 uses or null, but got " + uses.length);
        }
        return insts.ComparisonInstruction(this.iIndex(), this.operator, defs == null || defs.length == 0 ? this.result : defs[0], uses == null ? this.val1 : uses[0], uses == null ? this.val2 : uses[1]);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return this.getValueString(symbolTable, this.result) + " = compare " + this.getValueString(symbolTable, this.val1) + ',' + this.getValueString(symbolTable, this.val2) + " opcode=" + (Object)((Object)this.operator);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitComparison(this);
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public int getDef(int i) {
        assert (i == 0);
        return this.result;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    @Override
    public int getNumberOfUses() {
        return 2;
    }

    @Override
    public int getUse(int j) {
        assert (j <= 1);
        return j == 0 ? this.val1 : this.val2;
    }

    @Override
    public int hashCode() {
        return 6311 * this.result ^ 2371 * this.val1 + this.val2;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    public IComparisonInstruction.Operator getOperator() {
        return this.operator;
    }
}

