/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.annotations;

import com.ibm.wala.classLoader.FieldImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

public class Annotations {
    public static final TypeName INTERNAL = TypeName.findOrCreateClassName("com/ibm/wala/annotations", "Internal");
    public static final TypeName NONNULL = TypeName.findOrCreateClassName("com/ibm/wala/annotations", "NonNull");

    public static boolean hasAnnotation(IMethod m3, TypeName type) {
        if (m3 instanceof ShrikeCTMethod) {
            Collection<Annotation> annotations = null;
            try {
                annotations = ((ShrikeCTMethod)m3).getRuntimeInvisibleAnnotations();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            for (Annotation a : annotations) {
                if (!a.getType().getName().equals(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAnnotation(IClass c, TypeName type) {
        if (c instanceof ShrikeClass) {
            Collection<Annotation> annotations = null;
            try {
                annotations = ((ShrikeClass)c).getRuntimeInvisibleAnnotations();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            for (Annotation a : annotations) {
                if (!a.getType().getName().equals(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAnnotation(IField field, TypeName type) {
        FieldImpl f;
        Collection<Annotation> annotations;
        if (field instanceof FieldImpl && (annotations = (f = (FieldImpl)field).getAnnotations()) != null) {
            for (Annotation a : annotations) {
                if (!a.getType().getName().equals(type)) continue;
                return true;
            }
        }
        return false;
    }
}

