/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.annotations;

import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.TypeAnnotationsReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TypeAnnotation {
    private final Annotation annotation;
    private final List<Pair<TypeAnnotationsReader.TypePathKind, Integer>> typePath;
    private final TypeAnnotationTarget typeAnnotationTarget;
    private final TypeAnnotationsReader.TargetType targetType;

    private TypeAnnotation(Annotation annotation, List<Pair<TypeAnnotationsReader.TypePathKind, Integer>> typePath, TypeAnnotationTarget typeAnnotationTarget, TypeAnnotationsReader.TargetType targetType) {
        this.annotation = annotation;
        this.typePath = Collections.unmodifiableList(typePath);
        this.typeAnnotationTarget = typeAnnotationTarget;
        this.targetType = targetType;
    }

    public String toString() {
        return "TypeAnnotation{ annotation = " + this.annotation + ", path = " + this.typePath + ", target = " + this.typeAnnotationTarget + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotation == null ? 0 : this.annotation.hashCode());
        result = 31 * result + (this.typeAnnotationTarget == null ? 0 : this.typeAnnotationTarget.hashCode());
        result = 31 * result + (this.typePath == null ? 0 : this.typePath.hashCode());
        result = 31 * result + (this.targetType == null ? 0 : this.targetType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeAnnotation other = (TypeAnnotation)obj;
        if (this.annotation == null ? other.annotation != null : !this.annotation.equals(other.annotation)) {
            return false;
        }
        if (this.typeAnnotationTarget == null ? other.typeAnnotationTarget != null : !this.typeAnnotationTarget.equals(other.typeAnnotationTarget)) {
            return false;
        }
        if (this.typePath == null ? other.typePath != null : !this.typePath.equals(other.typePath)) {
            return false;
        }
        return !(this.targetType == null ? other.targetType != null : !this.targetType.equals((Object)other.targetType));
    }

    public static Collection<TypeAnnotation> getTypeAnnotationsFromReader(TypeAnnotationsReader r, TypeAnnotationTargetConverter converter, ClassLoaderReference clRef) throws InvalidClassFileException {
        if (r != null) {
            TypeAnnotationsReader.TypeAnnotationAttribute[] allTypeAnnotations = r.getAllTypeAnnotations();
            ArrayList<TypeAnnotation> result = new ArrayList<TypeAnnotation>(allTypeAnnotations.length);
            for (TypeAnnotationsReader.TypeAnnotationAttribute tatt : allTypeAnnotations) {
                Collection<Annotation> annotations = Annotation.convertToAnnotations(clRef, new AnnotationsReader.AnnotationAttribute[]{tatt.annotationAttribute});
                assert (annotations.size() == 1);
                Annotation annotation = annotations.iterator().next();
                result.add(new TypeAnnotation(annotation, tatt.typePath, tatt.annotationTarget.acceptVisitor(converter), tatt.targetType));
            }
            return result;
        }
        return Collections.emptySet();
    }

    public static TypeAnnotation make(Annotation annotation, List<Pair<TypeAnnotationsReader.TypePathKind, Integer>> typePath, TypeAnnotationTarget typeAnnotationTarget, TypeAnnotationsReader.TargetType targetType) {
        return new TypeAnnotation(annotation, typePath, typeAnnotationTarget, targetType);
    }

    public static TypeAnnotation make(Annotation annotation, TypeAnnotationTarget typeAnnotationTarget, TypeAnnotationsReader.TargetType targetType) {
        return new TypeAnnotation(annotation, TypeAnnotationsReader.TYPEPATH_EMPTY, typeAnnotationTarget, targetType);
    }

    private static TypeReference fromString(ClassLoaderReference clRef, String typeName) {
        return TypeReference.findOrCreate(clRef, 'L' + typeName.replaceAll(";", ""));
    }

    private static boolean mayAppearIn(TypeAnnotationsReader.TargetInfo info, TypeAnnotationsReader.TypeAnnotationLocation location) {
        for (TypeAnnotationsReader.TargetType targetType : TypeAnnotationsReader.TargetType.values()) {
            if (targetType.target_info != info || targetType.location != location) continue;
            return true;
        }
        return false;
    }

    public static TypeAnnotationTargetConverter targetConverterAtCode(final ClassLoaderReference clRef, final IBytecodeMethod<?> method) {
        return new TypeAnnotationTargetConverter(){

            @Override
            public TypeAnnotationTarget visitTypeParameterTarget(TypeAnnotationsReader.TypeParameterTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.Code));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitSuperTypeTarget(TypeAnnotationsReader.SuperTypeTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.Code));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitTypeParameterBoundTarget(TypeAnnotationsReader.TypeParameterBoundTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.Code));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitEmptyTarget(TypeAnnotationsReader.EmptyTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.Code));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitFormalParameterTarget(TypeAnnotationsReader.FormalParameterTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.Code));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitThrowsTarget(TypeAnnotationsReader.ThrowsTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.Code));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitLocalVarTarget(TypeAnnotationsReader.LocalVarTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.Code));
                if (target.getNrOfRanges() == 0) {
                    return new LocalVarTarget(-1, null);
                }
                int varIndex = target.getIndex(0);
                String name = method.getLocalVariableName(target.getStartPc(0), target.getIndex(0));
                if (name == null) {
                    return new LocalVarTarget(varIndex, null);
                }
                for (int i = 0; i < target.getNrOfRanges(); ++i) {
                    if (target.getIndex(i) != varIndex) {
                        throw new IllegalArgumentException();
                    }
                    if (method.getLocalVariableName(target.getStartPc(0), target.getIndex(0)).equals(name)) continue;
                    throw new IllegalArgumentException();
                }
                return new LocalVarTarget(varIndex, name);
            }

            @Override
            public TypeAnnotationTarget visitCatchTarget(TypeAnnotationsReader.CatchTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.Code));
                TypeReference catchType = target.getCatchType() == TypeAnnotationsReader.CatchTarget.ALL_EXCEPTIONS ? CatchTarget.ALL_EXCEPTIONS : TypeAnnotation.fromString(clRef, target.getCatchType());
                try {
                    int catchIIndex = method.getInstructionIndex(target.getCatchPC());
                    return new CatchTarget(catchIIndex, catchType);
                }
                catch (InvalidClassFileException e) {
                    return new CatchTarget(-1, catchType);
                }
            }

            @Override
            public TypeAnnotationTarget visitOffsetTarget(TypeAnnotationsReader.OffsetTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.Code));
                try {
                    int iindex = method.getInstructionIndex(target.getOffset());
                    return new OffsetTarget(iindex);
                }
                catch (InvalidClassFileException e) {
                    return new OffsetTarget(-1);
                }
            }

            @Override
            public TypeAnnotationTarget visitTypeArgumentTarget(TypeAnnotationsReader.TypeArgumentTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.Code));
                try {
                    int iindex = method.getInstructionIndex(target.getOffset());
                    return new TypeArgumentTarget(iindex, target.getTypeArgumentIndex());
                }
                catch (InvalidClassFileException e) {
                    return new TypeArgumentTarget(-1, target.getTypeArgumentIndex());
                }
            }
        };
    }

    public static TypeAnnotationTargetConverter targetConverterAtMethodInfo(final ClassLoaderReference clRef) {
        return new TypeAnnotationTargetConverter(){

            @Override
            public TypeAnnotationTarget visitTypeParameterTarget(TypeAnnotationsReader.TypeParameterTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.method_info));
                return new TypeParameterTarget(target.getIndex());
            }

            @Override
            public TypeAnnotationTarget visitSuperTypeTarget(TypeAnnotationsReader.SuperTypeTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.method_info));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitTypeParameterBoundTarget(TypeAnnotationsReader.TypeParameterBoundTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.method_info));
                return new TypeParameterBoundTarget(target.getParameterIndex(), target.getBoundIndex());
            }

            @Override
            public TypeAnnotationTarget visitEmptyTarget(TypeAnnotationsReader.EmptyTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.method_info));
                return new EmptyTarget();
            }

            @Override
            public TypeAnnotationTarget visitFormalParameterTarget(TypeAnnotationsReader.FormalParameterTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.method_info));
                return new FormalParameterTarget(target.getIndex());
            }

            @Override
            public TypeAnnotationTarget visitThrowsTarget(TypeAnnotationsReader.ThrowsTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.method_info));
                return new ThrowsTarget(TypeAnnotation.fromString(clRef, target.getThrowType()));
            }

            @Override
            public TypeAnnotationTarget visitLocalVarTarget(TypeAnnotationsReader.LocalVarTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.method_info));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitCatchTarget(TypeAnnotationsReader.CatchTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.method_info));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitOffsetTarget(TypeAnnotationsReader.OffsetTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.method_info));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitTypeArgumentTarget(TypeAnnotationsReader.TypeArgumentTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.method_info));
                throw new UnsupportedOperationException();
            }
        };
    }

    public static TypeAnnotationTargetConverter targetConverterAtClassFile(final ClassLoaderReference clRef) {
        return new TypeAnnotationTargetConverter(){

            @Override
            public TypeAnnotationTarget visitTypeParameterTarget(TypeAnnotationsReader.TypeParameterTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.ClassFile));
                return new TypeParameterTarget(target.getIndex());
            }

            @Override
            public TypeAnnotationTarget visitSuperTypeTarget(TypeAnnotationsReader.SuperTypeTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.ClassFile));
                return new SuperTypeTarget(TypeAnnotation.fromString(clRef, target.getSuperType()));
            }

            @Override
            public TypeAnnotationTarget visitTypeParameterBoundTarget(TypeAnnotationsReader.TypeParameterBoundTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.ClassFile));
                return new TypeParameterBoundTarget(target.getParameterIndex(), target.getBoundIndex());
            }

            @Override
            public TypeAnnotationTarget visitEmptyTarget(TypeAnnotationsReader.EmptyTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.ClassFile));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitFormalParameterTarget(TypeAnnotationsReader.FormalParameterTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.ClassFile));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitThrowsTarget(TypeAnnotationsReader.ThrowsTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.ClassFile));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitLocalVarTarget(TypeAnnotationsReader.LocalVarTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.ClassFile));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitCatchTarget(TypeAnnotationsReader.CatchTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.ClassFile));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitOffsetTarget(TypeAnnotationsReader.OffsetTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.ClassFile));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitTypeArgumentTarget(TypeAnnotationsReader.TypeArgumentTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.ClassFile));
                throw new UnsupportedOperationException();
            }
        };
    }

    public static TypeAnnotationTargetConverter targetConverterAtFieldInfo() {
        return new TypeAnnotationTargetConverter(){

            @Override
            public TypeAnnotationTarget visitTypeParameterTarget(TypeAnnotationsReader.TypeParameterTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.field_info));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitSuperTypeTarget(TypeAnnotationsReader.SuperTypeTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.field_info));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitTypeParameterBoundTarget(TypeAnnotationsReader.TypeParameterBoundTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.field_info));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitEmptyTarget(TypeAnnotationsReader.EmptyTarget target) {
                assert (TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.field_info));
                return new EmptyTarget();
            }

            @Override
            public TypeAnnotationTarget visitFormalParameterTarget(TypeAnnotationsReader.FormalParameterTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.field_info));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitThrowsTarget(TypeAnnotationsReader.ThrowsTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.field_info));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitLocalVarTarget(TypeAnnotationsReader.LocalVarTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.field_info));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitCatchTarget(TypeAnnotationsReader.CatchTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.field_info));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitOffsetTarget(TypeAnnotationsReader.OffsetTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.field_info));
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeAnnotationTarget visitTypeArgumentTarget(TypeAnnotationsReader.TypeArgumentTarget target) {
                assert (!TypeAnnotation.mayAppearIn(target.getTargetInfo(), TypeAnnotationsReader.TypeAnnotationLocation.field_info));
                throw new UnsupportedOperationException();
            }
        };
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public List<Pair<TypeAnnotationsReader.TypePathKind, Integer>> getTypePath() {
        return this.typePath;
    }

    public TypeAnnotationTarget getTypeAnnotationTarget() {
        return this.typeAnnotationTarget;
    }

    public TypeAnnotationsReader.TargetType getTargetType() {
        return this.targetType;
    }

    public static interface TypeAnnotationTargetConverter
    extends TypeAnnotationsReader.TypeAnnotationTargetVisitor<TypeAnnotationTarget> {
    }

    public static class TypeArgumentTarget
    extends TypeAnnotationTarget {
        private final int iindex;
        private final int type_argument_index;

        public TypeArgumentTarget(int iindex, int type_argument_index) {
            this.iindex = iindex;
            this.type_argument_index = type_argument_index;
        }

        public int getOffset() {
            return this.iindex;
        }

        public int getTypeArgumentIndex() {
            return this.type_argument_index;
        }

        public String toString() {
            return "TypeArgumentTarget{ iindex = " + this.iindex + ", type_argument_index = " + this.type_argument_index + '}';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.iindex;
            result = 31 * result + this.type_argument_index;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeArgumentTarget other = (TypeArgumentTarget)obj;
            if (this.iindex != other.iindex) {
                return false;
            }
            return this.type_argument_index == other.type_argument_index;
        }
    }

    public static class OffsetTarget
    extends TypeAnnotationTarget {
        private final int iindex;

        public OffsetTarget(int iindex) {
            this.iindex = iindex;
        }

        public int getIIndex() {
            return this.iindex;
        }

        public String toString() {
            return "OffsetTarget{ iindex = " + this.iindex + '}';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.iindex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OffsetTarget other = (OffsetTarget)obj;
            return this.iindex == other.iindex;
        }
    }

    public static class CatchTarget
    extends TypeAnnotationTarget {
        private final int catchIIndex;
        private final TypeReference catchType;
        public static final TypeReference ALL_EXCEPTIONS = null;

        public CatchTarget(int catchIIndex, TypeReference catchType) {
            this.catchIIndex = catchIIndex;
            this.catchType = catchType;
        }

        public TypeReference getCatchType() {
            return this.catchType;
        }

        public int getCatchIIndex() {
            return this.catchIIndex;
        }

        public String toString() {
            return "CatchTarget{ catchIIndex = " + this.catchIIndex + ", catchType = " + this.catchType + '}';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.catchIIndex;
            result = 31 * result + (this.catchType == null ? 0 : this.catchType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CatchTarget other = (CatchTarget)obj;
            if (this.catchIIndex != other.catchIIndex) {
                return false;
            }
            return !(this.catchType == null ? other.catchType != null : !this.catchType.equals(other.catchType));
        }
    }

    public static class LocalVarTarget
    extends TypeAnnotationTarget {
        private final int varIindex;
        private final String name;

        public LocalVarTarget(int varIindex, String name) {
            this.varIindex = varIindex;
            this.name = name;
        }

        public String toString() {
            return "LocalVarTarget{ varIindex = " + this.varIindex + ", name = " + this.name + '}';
        }

        public int getIndex() {
            return this.varIindex;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.varIindex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocalVarTarget other = (LocalVarTarget)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.varIindex == other.varIindex;
        }
    }

    public static class ThrowsTarget
    extends TypeAnnotationTarget {
        private final TypeReference throwType;

        public ThrowsTarget(TypeReference throwType) {
            this.throwType = throwType;
        }

        public TypeReference getThrowType() {
            return this.throwType;
        }

        public String toString() {
            return "ThrowsTarget{ throwType = " + this.throwType + '}';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.throwType == null ? 0 : this.throwType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ThrowsTarget other = (ThrowsTarget)obj;
            return !(this.throwType == null ? other.throwType != null : !this.throwType.equals(other.throwType));
        }
    }

    public static class FormalParameterTarget
    extends TypeAnnotationTarget {
        private final int formal_parameter_index;

        public FormalParameterTarget(int index) {
            this.formal_parameter_index = index;
        }

        public int getIndex() {
            return this.formal_parameter_index;
        }

        public String toString() {
            return "FormalParameterTarget{ formal_parameter_index = " + this.formal_parameter_index + '}';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.formal_parameter_index;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FormalParameterTarget other = (FormalParameterTarget)obj;
            return this.formal_parameter_index == other.formal_parameter_index;
        }
    }

    public static class EmptyTarget
    extends TypeAnnotationTarget {
        public String toString() {
            return "EmptyTarget";
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }
    }

    public static class TypeParameterBoundTarget
    extends TypeAnnotationTarget {
        private final int type_parameter_index;
        private final int bound_index;

        public TypeParameterBoundTarget(int type_parameter_index, int bound_index) {
            this.type_parameter_index = type_parameter_index;
            this.bound_index = bound_index;
        }

        public String toString() {
            return "TypeParameterBoundTarget{ type_parameter_index = " + this.type_parameter_index + ", bound_index = " + this.bound_index + '}';
        }

        public int getParameterIndex() {
            return this.type_parameter_index;
        }

        public int getBoundIndex() {
            return this.bound_index;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.bound_index;
            result = 31 * result + this.type_parameter_index;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeParameterBoundTarget other = (TypeParameterBoundTarget)obj;
            if (this.bound_index != other.bound_index) {
                return false;
            }
            return this.type_parameter_index == other.type_parameter_index;
        }
    }

    public static class SuperTypeTarget
    extends TypeAnnotationTarget {
        private final TypeReference superType;

        public SuperTypeTarget(TypeReference superType) {
            this.superType = superType;
        }

        public TypeReference getSuperType() {
            return this.superType;
        }

        public String toString() {
            return "SuperTypeTarget{ superType = " + this.superType + '}';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.superType == null ? 0 : this.superType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SuperTypeTarget other = (SuperTypeTarget)obj;
            return !(this.superType == null ? other.superType != null : !this.superType.equals(other.superType));
        }
    }

    public static class TypeParameterTarget
    extends TypeAnnotationTarget {
        private final int type_parameter_index;

        public TypeParameterTarget(int type_parameter_index) {
            this.type_parameter_index = type_parameter_index;
        }

        public int getIndex() {
            return this.type_parameter_index;
        }

        public String toString() {
            return "TypeParameterTarget{ type_parameter_index = " + this.type_parameter_index + '}';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.type_parameter_index;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeParameterTarget other = (TypeParameterTarget)obj;
            return this.type_parameter_index == other.type_parameter_index;
        }
    }

    public static abstract class TypeAnnotationTarget {
        public static final int INSTRUCTION_INDEX_UNAVAILABLE = -1;
    }
}

