/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.generics.Signature;
import com.ibm.wala.types.generics.TypeSignature;
import java.util.ArrayList;
import java.util.LinkedList;

public class FormalTypeParameter
extends Signature {
    private final String id;
    private final TypeSignature classBound;
    private final TypeSignature[] interfaceBounds;

    private FormalTypeParameter(String s2) throws IllegalArgumentException {
        super(s2);
        this.id = FormalTypeParameter.parseForId(s2);
        this.classBound = FormalTypeParameter.parseForClassBound(s2);
        this.interfaceBounds = FormalTypeParameter.parseForInterfaceBounds(s2);
    }

    private static TypeSignature parseForClassBound(String s2) {
        int start = s2.indexOf(58);
        if (start == s2.length() - 1) {
            return null;
        }
        int end = s2.indexOf(58, start + 1);
        if (end == start + 1) {
            return null;
        }
        if (end == -1) {
            return TypeSignature.make(s2.substring(start + 1));
        }
        return TypeSignature.make(s2.substring(start + 1, end));
    }

    private static TypeSignature[] parseForInterfaceBounds(String s2) {
        LinkedList<TypeSignature> list = new LinkedList<TypeSignature>();
        int start = s2.indexOf(58);
        if (start == s2.length() - 1) {
            return null;
        }
        start = s2.indexOf(58, start + 1);
        while (start != -1) {
            int end = s2.indexOf(58, start + 1);
            if (end == -1) {
                list.add(TypeSignature.make(s2.substring(start + 1)));
            } else {
                list.add(TypeSignature.make(s2.substring(start + 1, end)));
            }
            start = s2.indexOf(58, start + 1);
        }
        TypeSignature[] result = new TypeSignature[list.size()];
        return list.toArray(result);
    }

    private static String parseForId(String s2) throws IllegalArgumentException {
        if (s2.indexOf(58) == -1) {
            throw new IllegalArgumentException(s2);
        }
        return s2.substring(0, s2.indexOf(58));
    }

    public static FormalTypeParameter make(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("string is null");
        }
        return new FormalTypeParameter(string);
    }

    public TypeSignature getClassBound() {
        return this.classBound;
    }

    public String getIdentifier() {
        return this.id;
    }

    static int formalTypeParameterEnds(String s2, int begin) {
        int result = begin;
        while (s2.charAt(result) != ':') {
            ++result;
        }
        do {
            assert (s2.charAt(result) == ':');
            switch (s2.charAt(++result)) {
                case 'L': {
                    int depth = 0;
                    while (s2.charAt(result) != ';' || depth > 0) {
                        if (s2.charAt(result) == '<') {
                            ++depth;
                        }
                        if (s2.charAt(result) == '>') {
                            --depth;
                        }
                        ++result;
                    }
                    ++result;
                    break;
                }
                case ':': {
                    break;
                }
                default: {
                    assert (false) : "bad type signature list " + s2 + ' ' + (result - 1);
                    {
                        break;
                    }
                }
            }
        } while (s2.charAt(result) == ':');
        return result;
    }

    static String[] parseForFormalTypeParameters(String s2) {
        ArrayList<String> sigs = new ArrayList<String>(10);
        int beginToken = 1;
        while (s2.charAt(beginToken) != '>') {
            int endToken = FormalTypeParameter.formalTypeParameterEnds(s2, beginToken);
            sigs.add(s2.substring(beginToken, endToken));
            beginToken = endToken;
        }
        return sigs.toArray(new String[0]);
    }

    public TypeSignature[] getInterfaceBounds() {
        return this.interfaceBounds;
    }

    public static FormalTypeParameter[] getTypeParameters(IClass klass) throws InvalidClassFileException {
        if (klass instanceof ShrikeClass) {
            ShrikeClass sc = (ShrikeClass)klass;
            if (sc.getClassSignature() == null) {
                return null;
            }
            return sc.getClassSignature().getFormalTypeParameters();
        }
        return null;
    }

    public static FormalTypeParameter[] getTypeParameters(IMethod method) throws InvalidClassFileException {
        if (method instanceof ShrikeCTMethod) {
            ShrikeCTMethod sm = (ShrikeCTMethod)method;
            if (sm.getMethodTypeSignature() == null) {
                return null;
            }
            return sm.getMethodTypeSignature().getFormalTypeParameters();
        }
        return null;
    }
}

