/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.generics.FormalTypeParameter;
import com.ibm.wala.types.generics.Signature;
import com.ibm.wala.types.generics.TypeSignature;

public class MethodTypeSignature
extends Signature {
    private MethodTypeSignature(String s2) {
        super(s2);
    }

    public static MethodTypeSignature make(String genericsSignature) throws IllegalArgumentException {
        if (genericsSignature == null) {
            throw new IllegalArgumentException("genericsSignature is null");
        }
        if (genericsSignature.length() == 0) {
            throw new IllegalArgumentException();
        }
        return new MethodTypeSignature(genericsSignature);
    }

    public TypeSignature[] getArguments() {
        String typeSig = this.rawString().replaceAll(".*\\(", "\\(").replaceAll("\\).*", "\\)");
        String[] args = TypeSignature.parseForTypeSignatures(typeSig);
        if (args == null) {
            return null;
        }
        TypeSignature[] result = new TypeSignature[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = TypeSignature.make(args[i]);
        }
        return result;
    }

    public TypeSignature getReturnType() {
        String rtString = this.rawString().substring(this.rawString().indexOf(41) + 1);
        return TypeSignature.make(rtString);
    }

    public FormalTypeParameter[] getFormalTypeParameters() {
        if (this.rawString().charAt(0) != '<') {
            return null;
        }
        int index = this.endOfFormalTypeParameters();
        String[] args = FormalTypeParameter.parseForFormalTypeParameters(this.rawString().substring(0, index));
        FormalTypeParameter[] result = new FormalTypeParameter[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = FormalTypeParameter.make(args[i]);
        }
        return result;
    }

    private int endOfFormalTypeParameters() {
        if (this.rawString().charAt(0) != '<') {
            return 0;
        }
        int i = 1;
        int depth = 1;
        while (depth > 0) {
            if (this.rawString().charAt(i) == '>') {
                --depth;
            }
            if (this.rawString().charAt(i) == '<') {
                ++depth;
            }
            ++i;
        }
        return i;
    }

    public static TypeSignature[] getArguments(IMethod method) throws InvalidClassFileException {
        if (method instanceof ShrikeCTMethod) {
            ShrikeCTMethod sm = (ShrikeCTMethod)method;
            if (sm.getMethodTypeSignature() == null) {
                return null;
            }
            return sm.getMethodTypeSignature().getArguments();
        }
        return null;
    }

    public static MethodTypeSignature getMethodTypeSignature(IMethod method) throws InvalidClassFileException {
        if (method instanceof ShrikeCTMethod) {
            ShrikeCTMethod sm = (ShrikeCTMethod)method;
            return sm.getMethodTypeSignature();
        }
        return null;
    }
}

