/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.generics.ArrayTypeSignature;
import com.ibm.wala.types.generics.BaseType;
import com.ibm.wala.types.generics.ClassTypeSignature;
import com.ibm.wala.types.generics.Signature;
import com.ibm.wala.types.generics.TypeVariableSignature;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class TypeSignature
extends Signature {
    TypeSignature(String s2) {
        super(s2);
    }

    public static TypeSignature make(String s2) throws IllegalArgumentException {
        if (s2 == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (s2.length() == 0) {
            throw new IllegalArgumentException("illegal empty string s");
        }
        assert (s2.length() > 0);
        switch (s2.charAt(0)) {
            case 'V': {
                Assertions.UNREACHABLE();
                return null;
            }
            case 'Z': {
                return BaseType.BOOLEAN;
            }
            case 'B': {
                return BaseType.BYTE;
            }
            case 'S': {
                return BaseType.SHORT;
            }
            case 'I': {
                return BaseType.INT;
            }
            case 'J': {
                return BaseType.LONG;
            }
            case 'F': {
                return BaseType.FLOAT;
            }
            case 'D': {
                return BaseType.DOUBLE;
            }
            case 'C': {
                return BaseType.CHAR;
            }
            case 'L': {
                return ClassTypeSignature.makeClassTypeSig(s2);
            }
            case 'T': {
                return TypeVariableSignature.make(s2);
            }
            case '[': {
                return ArrayTypeSignature.make(s2);
            }
        }
        throw new IllegalArgumentException("malformed TypeSignature string:" + s2);
    }

    public abstract boolean isTypeVariable();

    public abstract boolean isClassTypeSignature();

    public abstract boolean isArrayTypeSignature();

    public abstract boolean isBaseType();

    static String[] parseForTypeSignatures(String typeSigs) throws IllegalArgumentException {
        ArrayList<String> sigs = new ArrayList<String>(10);
        if (typeSigs.length() < 2) {
            throw new IllegalArgumentException("illegal string of TypeSignature " + typeSigs);
        }
        int i = 1;
        block19: while (true) {
            switch (typeSigs.charAt(i++)) {
                case 'V': {
                    sigs.add(TypeReference.VoidName.toString());
                    continue block19;
                }
                case 'Z': {
                    sigs.add(TypeReference.BooleanName.toString());
                    continue block19;
                }
                case 'B': {
                    sigs.add(TypeReference.ByteName.toString());
                    continue block19;
                }
                case 'S': {
                    sigs.add(TypeReference.ShortName.toString());
                    continue block19;
                }
                case 'I': {
                    sigs.add(TypeReference.IntName.toString());
                    continue block19;
                }
                case 'J': {
                    sigs.add(TypeReference.LongName.toString());
                    continue block19;
                }
                case 'F': {
                    sigs.add(TypeReference.FloatName.toString());
                    continue block19;
                }
                case 'D': {
                    sigs.add(TypeReference.DoubleName.toString());
                    continue block19;
                }
                case 'C': {
                    sigs.add(TypeReference.CharName.toString());
                    continue block19;
                }
                case 'L': {
                    int off = i - 1;
                    int depth = 0;
                    while (typeSigs.charAt(i++) != ';' || depth > 0) {
                        if (typeSigs.charAt(i - 1) == '<') {
                            ++depth;
                        }
                        if (typeSigs.charAt(i - 1) != '>') continue;
                        --depth;
                    }
                    sigs.add(typeSigs.substring(off, i));
                    continue block19;
                }
                case '[': {
                    int depth;
                    int off;
                    switch (typeSigs.charAt(i)) {
                        case 'B': 
                        case 'I': 
                        case 'Z': {
                            sigs.add(typeSigs.substring(i - 1, i + 1));
                            continue block19;
                        }
                        case 'L': 
                        case 'T': {
                            off = i - 1;
                            depth = 0;
                            while (true) {
                                int n = ++i;
                                ++i;
                                if (typeSigs.charAt(n) == ';' && depth <= 0) break;
                                if (typeSigs.charAt(i - 1) == '<') {
                                    ++depth;
                                }
                                if (typeSigs.charAt(i - 1) != '>') continue;
                                --depth;
                            }
                            sigs.add(typeSigs.substring(off, i));
                            continue block19;
                        }
                    }
                    Assertions.UNREACHABLE("BANG " + typeSigs.charAt(i));
                    continue block19;
                }
                case 'T': {
                    int off = i - 1;
                    while (typeSigs.charAt(i++) != ';') {
                    }
                    sigs.add(typeSigs.substring(off, i));
                    continue block19;
                }
                case ')': {
                    int size = sigs.size();
                    if (size == 0) {
                        return null;
                    }
                    Iterator it = sigs.iterator();
                    String[] result = new String[size];
                    for (int j = 0; j < size; ++j) {
                        result[j] = (String)it.next();
                    }
                    return result;
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError((Object)("bad type signature list " + typeSigs));
    }
}

