/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.generics.ClassSignature;
import com.ibm.wala.types.generics.FormalTypeParameter;
import com.ibm.wala.types.generics.TypeSignature;
import com.ibm.wala.util.debug.Assertions;

public class TypeVariableSignature
extends TypeSignature {
    private TypeVariableSignature(String s2) throws IllegalArgumentException {
        super(s2);
        if (s2.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (s2.charAt(s2.length() - 1) != ';') {
            throw new IllegalArgumentException(s2);
        }
    }

    public static TypeVariableSignature make(String s2) throws IllegalArgumentException {
        if (s2 == null) {
            throw new IllegalArgumentException("s is null");
        }
        return new TypeVariableSignature(s2);
    }

    @Override
    public boolean isClassTypeSignature() {
        return false;
    }

    @Override
    public boolean isTypeVariable() {
        return true;
    }

    @Override
    public boolean isArrayTypeSignature() {
        return false;
    }

    public String getIdentifier() {
        return this.rawString().substring(1, this.rawString().length() - 1);
    }

    @Override
    public boolean isBaseType() {
        return false;
    }

    public static int getTypeVariablePosition(TypeVariableSignature v, ShrikeClass klass) throws IllegalArgumentException {
        if (klass == null) {
            throw new IllegalArgumentException("klass cannot be null");
        }
        try {
            ClassSignature sig = klass.getClassSignature();
            if (sig == null) {
                return -1;
            }
            FormalTypeParameter[] fp = sig.getFormalTypeParameters();
            if (fp == null) {
                return -1;
            }
            for (int i = 0; i < fp.length; ++i) {
                FormalTypeParameter f = fp[i];
                if (!f.getIdentifier().equals(v.getIdentifier())) continue;
                return i;
            }
            return -1;
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return -1;
        }
    }
}

