/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class PrimitiveAssignability {
    private static final Map<Primitive, Map<Primitive, AssignabilityKind>> assignability = new EnumMap<Primitive, Map<Primitive, AssignabilityKind>>(Primitive.class);
    private static final Map<TypeName, Primitive> namePrimitiveMap;

    private static void putNarrowing(Primitive from, Primitive to) {
        assert (!assignability.get((Object)from).containsKey((Object)to));
        assignability.get((Object)from).put(to, AssignabilityKind.NARROWING);
    }

    private static void putWidening(Primitive from, Primitive to) {
        assert (!assignability.get((Object)from).containsKey((Object)to));
        assignability.get((Object)from).put(to, AssignabilityKind.WIDENING);
    }

    public static AssignabilityKind getAssignableFrom(TypeName from, TypeName to) {
        Primitive f = namePrimitiveMap.get(from);
        Primitive t = namePrimitiveMap.get(to);
        return assignability.get((Object)f).getOrDefault((Object)t, AssignabilityKind.UNASSIGNABLE);
    }

    public static boolean isAssignableFrom(TypeName from, TypeName to) {
        return PrimitiveAssignability.getAssignableFrom(from, to) != AssignabilityKind.UNASSIGNABLE;
    }

    static {
        for (Primitive t : Primitive.values()) {
            EnumMap<Primitive, AssignabilityKind> addendum = new EnumMap<Primitive, AssignabilityKind>(Primitive.class);
            addendum.put(t, AssignabilityKind.IDENTITY);
            assignability.put(t, addendum);
        }
        PrimitiveAssignability.putWidening(Primitive.BYTE, Primitive.SHORT);
        PrimitiveAssignability.putWidening(Primitive.BYTE, Primitive.INT);
        PrimitiveAssignability.putWidening(Primitive.BYTE, Primitive.LONG);
        PrimitiveAssignability.putWidening(Primitive.BYTE, Primitive.FLOAT);
        PrimitiveAssignability.putWidening(Primitive.BYTE, Primitive.DOUBLE);
        PrimitiveAssignability.putWidening(Primitive.SHORT, Primitive.INT);
        PrimitiveAssignability.putWidening(Primitive.SHORT, Primitive.LONG);
        PrimitiveAssignability.putWidening(Primitive.SHORT, Primitive.FLOAT);
        PrimitiveAssignability.putWidening(Primitive.SHORT, Primitive.DOUBLE);
        PrimitiveAssignability.putWidening(Primitive.CHAR, Primitive.INT);
        PrimitiveAssignability.putWidening(Primitive.CHAR, Primitive.LONG);
        PrimitiveAssignability.putWidening(Primitive.CHAR, Primitive.FLOAT);
        PrimitiveAssignability.putWidening(Primitive.CHAR, Primitive.DOUBLE);
        PrimitiveAssignability.putWidening(Primitive.INT, Primitive.LONG);
        PrimitiveAssignability.putWidening(Primitive.INT, Primitive.FLOAT);
        PrimitiveAssignability.putWidening(Primitive.INT, Primitive.DOUBLE);
        PrimitiveAssignability.putWidening(Primitive.LONG, Primitive.FLOAT);
        PrimitiveAssignability.putWidening(Primitive.LONG, Primitive.DOUBLE);
        PrimitiveAssignability.putWidening(Primitive.FLOAT, Primitive.DOUBLE);
        PrimitiveAssignability.putNarrowing(Primitive.SHORT, Primitive.BYTE);
        PrimitiveAssignability.putNarrowing(Primitive.SHORT, Primitive.CHAR);
        PrimitiveAssignability.putNarrowing(Primitive.CHAR, Primitive.BYTE);
        PrimitiveAssignability.putNarrowing(Primitive.CHAR, Primitive.SHORT);
        PrimitiveAssignability.putNarrowing(Primitive.INT, Primitive.BYTE);
        PrimitiveAssignability.putNarrowing(Primitive.INT, Primitive.SHORT);
        PrimitiveAssignability.putNarrowing(Primitive.INT, Primitive.CHAR);
        PrimitiveAssignability.putNarrowing(Primitive.LONG, Primitive.BYTE);
        PrimitiveAssignability.putNarrowing(Primitive.LONG, Primitive.SHORT);
        PrimitiveAssignability.putNarrowing(Primitive.LONG, Primitive.CHAR);
        PrimitiveAssignability.putNarrowing(Primitive.LONG, Primitive.INT);
        PrimitiveAssignability.putNarrowing(Primitive.FLOAT, Primitive.BYTE);
        PrimitiveAssignability.putNarrowing(Primitive.FLOAT, Primitive.SHORT);
        PrimitiveAssignability.putNarrowing(Primitive.FLOAT, Primitive.CHAR);
        PrimitiveAssignability.putNarrowing(Primitive.FLOAT, Primitive.INT);
        PrimitiveAssignability.putNarrowing(Primitive.FLOAT, Primitive.LONG);
        PrimitiveAssignability.putNarrowing(Primitive.DOUBLE, Primitive.BYTE);
        PrimitiveAssignability.putNarrowing(Primitive.DOUBLE, Primitive.SHORT);
        PrimitiveAssignability.putNarrowing(Primitive.DOUBLE, Primitive.CHAR);
        PrimitiveAssignability.putNarrowing(Primitive.DOUBLE, Primitive.INT);
        PrimitiveAssignability.putNarrowing(Primitive.DOUBLE, Primitive.LONG);
        PrimitiveAssignability.putNarrowing(Primitive.DOUBLE, Primitive.FLOAT);
        assignability.get((Object)Primitive.BYTE).put(Primitive.CHAR, AssignabilityKind.WIDENING_NARROWING);
        namePrimitiveMap = new HashMap<TypeName, Primitive>();
        namePrimitiveMap.put(TypeReference.BooleanName, Primitive.BOOLEAN);
        namePrimitiveMap.put(TypeReference.ByteName, Primitive.BYTE);
        namePrimitiveMap.put(TypeReference.CharName, Primitive.CHAR);
        namePrimitiveMap.put(TypeReference.DoubleName, Primitive.DOUBLE);
        namePrimitiveMap.put(TypeReference.FloatName, Primitive.FLOAT);
        namePrimitiveMap.put(TypeReference.IntName, Primitive.INT);
        namePrimitiveMap.put(TypeReference.LongName, Primitive.LONG);
        namePrimitiveMap.put(TypeReference.ShortName, Primitive.SHORT);
    }

    private static enum Primitive {
        BOOLEAN,
        CHAR,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }

    public static enum AssignabilityKind {
        IDENTITY,
        WIDENING,
        NARROWING,
        WIDENING_NARROWING,
        UNASSIGNABLE;

    }
}

