/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import java.util.Arrays;
import java.util.NoSuchElementException;

public abstract class Heap<T> {
    private int numberOfElements = 0;
    private T[] backingStore;

    protected abstract boolean compareElements(T var1, T var2);

    public int size() {
        return this.numberOfElements;
    }

    public Heap(int initialCapacity) {
        this.backingStore = new Object[initialCapacity];
    }

    public final boolean isEmpty() {
        return this.numberOfElements == 0;
    }

    public void insert(T elt) {
        this.ensureCapacity(this.numberOfElements + 1);
        this.bubbleUp(elt, this.numberOfElements);
        ++this.numberOfElements;
    }

    public T take() throws NoSuchElementException {
        if (this.numberOfElements == 0) {
            throw new NoSuchElementException();
        }
        T result = this.backingStore[0];
        this.removeElement(0);
        return result;
    }

    private static int heapParent(int index) {
        return (index - 1) / 2;
    }

    private static int heapLeftChild(int index) {
        return index * 2 + 1;
    }

    private static int heapRightChild(int index) {
        return index * 2 + 2;
    }

    private final void ensureCapacity(int min2) {
        if (this.backingStore.length < min2) {
            this.backingStore = Arrays.copyOf(this.backingStore, 2 * min2);
        }
    }

    private final void removeElement(int index) {
        int leftIndex;
        int ne = this.numberOfElements;
        T[] bs = this.backingStore;
        while ((leftIndex = Heap.heapLeftChild(index)) < ne) {
            int rightIndex = Heap.heapRightChild(index);
            if (rightIndex < ne) {
                T leftObject = bs[leftIndex];
                T rightObject = bs[rightIndex];
                if (this.compareElements(leftObject, rightObject)) {
                    bs[index] = leftObject;
                    index = leftIndex;
                    continue;
                }
                bs[index] = rightObject;
                index = rightIndex;
                continue;
            }
            bs[index] = bs[leftIndex];
            index = leftIndex;
        }
        --this.numberOfElements;
        ne = this.numberOfElements;
        if (index != ne) {
            this.bubbleUp(bs[ne], index);
        }
    }

    private final void bubbleUp(T elt, int index) {
        T[] bs = this.backingStore;
        while (true) {
            if (index == 0) {
                bs[index] = elt;
                return;
            }
            int hpIndex = Heap.heapParent(index);
            T parent = bs[hpIndex];
            if (this.compareElements(parent, elt)) {
                bs[index] = elt;
                return;
            }
            bs[index] = parent;
            index = hpIndex;
        }
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append('[');
        for (int i = 0; i < this.size(); ++i) {
            if (this.backingStore[i] == null) continue;
            if (i > 0) {
                s2.append(',');
            }
            s2.append(this.backingStore[i].toString());
        }
        s2.append(']');
        return s2.toString();
    }
}

