/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.ParanoidHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ParanoidHashSet<T>
extends LinkedHashSet<T> {
    public static final long serialVersionUID = 30919839181133333L;
    private final Map<Integer, Set<T>> hcFreq;
    private int nAdded = 0;
    private final int BAD_HC = 3;

    public ParanoidHashSet(Collection<T> s2) throws NullPointerException {
        super(s2.size());
        this.hcFreq = HashMapFactory.make(s2.size());
        this.addAll(s2);
    }

    public ParanoidHashSet() {
        this.hcFreq = HashMapFactory.make();
    }

    public ParanoidHashSet(int size) {
        super(size);
        this.hcFreq = HashMapFactory.make(size);
    }

    @Override
    public boolean add(T arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("arg0 is null");
        }
        ParanoidHashMap.assertOverridesHashCode(arg0);
        boolean result = super.add(arg0);
        if (result) {
            ++this.nAdded;
            int hc = arg0.hashCode();
            Set<T> s2 = this.hcFreq.get(hc);
            if (s2 == null) {
                LinkedHashSet<T> h2 = new LinkedHashSet<T>(1);
                h2.add(arg0);
                this.hcFreq.put(hc, h2);
            } else if (s2.size() == 3) {
                Iterator<T> iterator = s2.iterator();
                while (iterator.hasNext()) {
                    T t;
                    T o = t = iterator.next();
                    System.err.println(o + " " + o.hashCode());
                }
                assert (false) : "bad hc " + arg0.getClass() + ' ' + arg0;
            } else {
                s2.add(arg0);
            }
        }
        return result;
    }
}

