/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.config;

import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.strings.Atom;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.StringTokenizer;
import java.util.jar.JarFile;

public class AnalysisScopeReader {
    private static final ClassLoader MY_CLASSLOADER = AnalysisScopeReader.class.getClassLoader();
    protected static final String BASIC_FILE = "primordial.txt";

    public static AnalysisScope readJavaScope(String scopeFileName, File exclusionsFile, ClassLoader javaLoader) throws IOException {
        AnalysisScope scope = AnalysisScope.createJavaAnalysisScope();
        return AnalysisScopeReader.read(scope, scopeFileName, exclusionsFile, javaLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalysisScope read(AnalysisScope scope, String scopeFileName, File exclusionsFile, ClassLoader javaLoader) throws IOException {
        block24: {
            BufferedReader r = null;
            try {
                String line;
                File scopeFile = new File(scopeFileName);
                if (scopeFile.exists()) {
                    r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(scopeFile), "UTF-8"));
                } else {
                    InputStream inFromJar = javaLoader.getResourceAsStream(scopeFileName);
                    if (inFromJar == null) {
                        throw new IllegalArgumentException("Unable to retreive " + scopeFileName + " from the jar using " + javaLoader);
                    }
                    r = new BufferedReader(new InputStreamReader(inFromJar));
                }
                while ((line = r.readLine()) != null) {
                    AnalysisScopeReader.processScopeDefLine(scope, javaLoader, line);
                }
                if (exclusionsFile == null) break block24;
                try (InputStream fs = exclusionsFile.exists() ? new FileInputStream(exclusionsFile) : FileProvider.class.getClassLoader().getResourceAsStream(exclusionsFile.getName());){
                    scope.setExclusions(new FileOfClasses(fs));
                }
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AnalysisScope read(AnalysisScope scope, URI scopeFileURI, File exclusionsFile, ClassLoader javaLoader) throws IOException {
        block22: {
            BufferedReader r = null;
            try {
                String line;
                InputStream inStream = scopeFileURI.toURL().openStream();
                if (inStream == null) {
                    throw new IllegalArgumentException("Unable to retrieve URI " + scopeFileURI.toString());
                }
                r = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                while ((line = r.readLine()) != null) {
                    AnalysisScopeReader.processScopeDefLine(scope, javaLoader, line);
                }
                if (exclusionsFile == null) break block22;
                try (InputStream fs = exclusionsFile.exists() ? new FileInputStream(exclusionsFile) : FileProvider.class.getClassLoader().getResourceAsStream(exclusionsFile.getName());){
                    scope.setExclusions(new FileOfClasses(fs));
                }
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return scope;
    }

    public static void processScopeDefLine(AnalysisScope scope, ClassLoader javaLoader, String line) throws IOException {
        if (line == null) {
            throw new IllegalArgumentException("null line");
        }
        StringTokenizer toks = new StringTokenizer(line, "\n,");
        if (!toks.hasMoreTokens()) {
            return;
        }
        Atom loaderName = Atom.findOrCreateUnicodeAtom(toks.nextToken());
        ClassLoaderReference walaLoader = scope.getLoader(loaderName);
        String language = toks.nextToken();
        String entryType = toks.nextToken();
        String entryPathname = toks.nextToken();
        FileProvider fp = new FileProvider();
        if ("classFile".equals(entryType)) {
            File cf = fp.getFile(entryPathname, javaLoader);
            try {
                scope.addClassFileToScope(walaLoader, cf);
            }
            catch (InvalidClassFileException e) {
                Assertions.UNREACHABLE(e.toString());
            }
        } else if ("sourceFile".equals(entryType)) {
            File sf = fp.getFile(entryPathname, javaLoader);
            scope.addSourceFileToScope(walaLoader, sf, entryPathname);
        } else if ("binaryDir".equals(entryType)) {
            File bd = fp.getFile(entryPathname, javaLoader);
            assert (bd.isDirectory());
            scope.addToScope(walaLoader, new BinaryDirectoryTreeModule(bd));
        } else if ("sourceDir".equals(entryType)) {
            File sd = fp.getFile(entryPathname, javaLoader);
            assert (sd.isDirectory());
            scope.addToScope(walaLoader, new SourceDirectoryTreeModule(sd));
        } else if ("jarFile".equals(entryType)) {
            Module M = fp.getJarFileModule(entryPathname, javaLoader);
            scope.addToScope(walaLoader, M);
        } else if ("loaderImpl".equals(entryType)) {
            scope.setLoaderImpl(walaLoader, entryPathname);
        } else if ("stdlib".equals(entryType)) {
            String[] stdlibs;
            for (String stdlib : stdlibs = WalaProperties.getJ2SEJarFiles()) {
                scope.addToScope(walaLoader, new JarFile(stdlib, false));
            }
        } else {
            Assertions.UNREACHABLE();
        }
    }

    public static AnalysisScope makePrimordialScope(File exclusionsFile) throws IOException {
        return AnalysisScopeReader.readJavaScope(BASIC_FILE, exclusionsFile, MY_CLASSLOADER);
    }

    public static AnalysisScope makeJavaBinaryAnalysisScope(String classPath, File exclusionsFile) throws IOException {
        if (classPath == null) {
            throw new IllegalArgumentException("classPath null");
        }
        AnalysisScope scope = AnalysisScopeReader.makePrimordialScope(exclusionsFile);
        ClassLoaderReference loader = scope.getLoader(AnalysisScope.APPLICATION);
        AnalysisScopeReader.addClassPathToScope(classPath, scope, loader);
        return scope;
    }

    public static void addClassPathToScope(String classPath, AnalysisScope scope, ClassLoaderReference loader) {
        if (classPath == null) {
            throw new IllegalArgumentException("null classPath");
        }
        try {
            StringTokenizer paths = new StringTokenizer(classPath, File.pathSeparator);
            while (paths.hasMoreTokens()) {
                String path = paths.nextToken();
                if (path.endsWith(".jar")) {
                    JarFile jar = new JarFile(path, false);
                    scope.addToScope(loader, jar);
                    try {
                        String cp;
                        if (jar.getManifest() == null || (cp = jar.getManifest().getMainAttributes().getValue("Class-Path")) == null) continue;
                        for (String cpEntry : cp.split(" ")) {
                            AnalysisScopeReader.addClassPathToScope(new File(path).getParent() + File.separator + cpEntry, scope, loader);
                        }
                        continue;
                    }
                    catch (RuntimeException e) {
                        System.err.println("warning: trouble processing class path of " + path);
                        continue;
                    }
                }
                File f = new File(path);
                if (f.isDirectory()) {
                    scope.addToScope(loader, new BinaryDirectoryTreeModule(f));
                    continue;
                }
                scope.addClassFileToScope(loader, f);
            }
        }
        catch (InvalidClassFileException | IOException e) {
            Assertions.UNREACHABLE(e.toString());
        }
    }
}

