/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorFramework;
import com.ibm.wala.dataflow.graph.BitVectorIdentity;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.BitVectorUnionConstant;
import com.ibm.wala.dataflow.graph.DataflowSolver;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.function.Predicate;

public class GraphReachability<T, S> {
    private final Graph<T> g;
    private DataflowSolver<T, BitVectorVariable> solver;
    final OrdinalSetMapping<S> domain;

    public GraphReachability(Graph<T> g2, Predicate<? super T> filter) {
        if (g2 == null) {
            throw new IllegalArgumentException("g is null");
        }
        this.g = g2;
        FilterIterator<? super T> i = new FilterIterator<T>(g2.iterator(), filter);
        this.domain = new MutableMapping<S>(Iterator2Collection.toSet(i).toArray());
    }

    public OrdinalSet<S> getReachableSet(Object n) throws IllegalStateException {
        if (this.solver == null) {
            throw new IllegalStateException("must call solve() before calling getReachableSet()");
        }
        BitVectorVariable v = this.solver.getOut(n);
        assert (v != null) : "null variable for node " + n;
        if (v.getValue() == null) {
            return OrdinalSet.empty();
        }
        return new OrdinalSet<S>(v.getValue(), this.domain);
    }

    public boolean solve(MonitorUtil.IProgressMonitor monitor) throws CancelException {
        ITransferFunctionProvider functions = new ITransferFunctionProvider<T, BitVectorVariable>(){

            @Override
            public UnaryOperator<BitVectorVariable> getNodeTransferFunction(T n) {
                int index = GraphReachability.this.domain.getMappedIndex(n);
                if (index > -1) {
                    return new BitVectorUnionConstant(index);
                }
                return BitVectorIdentity.instance();
            }

            @Override
            public boolean hasNodeTransferFunctions() {
                return true;
            }

            @Override
            public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(Object from, Object to) {
                Assertions.UNREACHABLE();
                return null;
            }

            @Override
            public boolean hasEdgeTransferFunctions() {
                return false;
            }

            @Override
            public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
                return BitVectorUnion.instance();
            }
        };
        BitVectorFramework<T, S> f = new BitVectorFramework<T, S>(GraphInverter.invert(this.g), functions, this.domain);
        this.solver = new BitVectorSolver<T>(f);
        return this.solver.solve(monitor);
    }
}

